/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ToolCommandsRegistration
implements CommandRegistration<ToolCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ToolCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"Type of tree to generate")).defaultsTo(ImmutableList.of("tree")).ofTypes(ImmutableList.of(treeType_Key)).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to place")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern to flood fill")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument rangePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range to perform the fill")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument primaryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"primary"), (Component)TextComponent.of((String)"Pattern to set on left-click")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument secondaryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"secondary"), (Component)TextComponent.of((String)"Pattern to set on right-click")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();

    private ToolCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ToolCommandsRegistration builder() {
        return new ToolCommandsRegistration();
    }

    public ToolCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ToolCommandsRegistration containerInstance(ToolCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ToolCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ToolCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("none", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Unbind a bound tool from your current item"));
            b.parts(ImmutableList.of());
            b.action(this::none);
        });
        this.commandManager.register("/selwand", b -> {
            b.aliases(ImmutableList.of("selwand"));
            b.description((Component)TextComponent.of((String)"Selection wand tool"));
            b.parts(ImmutableList.of());
            b.action(this::_selwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"selwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/navwand", b -> {
            b.aliases(ImmutableList.of("navwand"));
            b.description((Component)TextComponent.of((String)"Navigation wand tool"));
            b.parts(ImmutableList.of());
            b.action(this::_navwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"navwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("info", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block information tool"));
            b.parts(ImmutableList.of());
            b.action(this::info);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"info", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("tree", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Tree generator tool"));
            b.parts(ImmutableList.of(this.typePart));
            b.action(this::tree);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"tree", (Class[])new Class[]{Player.class, LocalSession.class, TreeGenerator.TreeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("repl", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block replacer tool"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::repl);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"repl", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cycler", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block data cycler tool"));
            b.parts(ImmutableList.of());
            b.action(this::cycler);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"cycler", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("floodfill", b -> {
            b.aliases(ImmutableList.of("flood"));
            b.description((Component)TextComponent.of((String)"Flood fill tool"));
            b.parts(ImmutableList.of(this.patternPart2, this.rangePart));
            b.action(this::floodfill);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"floodFill", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deltree", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Floating tree remover tool"));
            b.parts(ImmutableList.of());
            b.action(this::deltree);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"deltree", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("farwand", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Wand at a distance tool"));
            b.parts(ImmutableList.of());
            b.action(this::farwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"farwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lrbuild", b -> {
            b.aliases(ImmutableList.of("/lrbuild"));
            b.description((Component)TextComponent.of((String)"Long-range building tool"));
            b.parts(ImmutableList.of(this.primaryPart, this.secondaryPart));
            b.action(this::lrbuild);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"longrangebuildtool", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int none(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"none", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.none(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _selwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"selwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.selwand(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _navwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"navwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.navwand(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int info(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"info", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.info(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int tree(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"tree", (Class[])new Class[]{Player.class, LocalSession.class, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.tree(this.player(parameters), this.session(parameters), this.type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int repl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"repl", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.repl(this.player(parameters), this.session(parameters), this.pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cycler(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"cycler", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cycler(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int floodfill(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"floodFill", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.floodFill(this.player(parameters), this.session(parameters), this.pattern2(parameters), this.range(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int deltree(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"deltree", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deltree(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int farwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"farwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.farwand(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int lrbuild(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"longrangebuildtool", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.longrangebuildtool(this.player(parameters), this.session(parameters), this.primary(parameters), this.secondary(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Pattern pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private int range(CommandParameters parameters) {
        return (Integer)this.rangePart.value(parameters).asSingle(integer_Key);
    }

    private Pattern secondary(CommandParameters parameters) {
        return (Pattern)this.secondaryPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern primary(CommandParameters parameters) {
        return (Pattern)this.primaryPart.value(parameters).asSingle(pattern_Key);
    }
}

