/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SuperPickaxeCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class SuperPickaxeCommandsRegistration
implements CommandRegistration<SuperPickaxeCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private SuperPickaxeCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument rangePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range of the area pickaxe")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument rangePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range of the recursive pickaxe")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_Key)).build();

    private SuperPickaxeCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SuperPickaxeCommandsRegistration builder() {
        return new SuperPickaxeCommandsRegistration();
    }

    public SuperPickaxeCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SuperPickaxeCommandsRegistration containerInstance(SuperPickaxeCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SuperPickaxeCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SuperPickaxeCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("single", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Enable the single block super pickaxe mode"));
            b.parts(ImmutableList.of());
            b.action(this::single);
            Method commandMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"single", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("area", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Enable the area super pickaxe pickaxe mode"));
            b.parts(ImmutableList.of(this.rangePart));
            b.action(this::area);
            Method commandMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"area", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("recursive", b -> {
            b.aliases(ImmutableList.of("recur"));
            b.description((Component)TextComponent.of((String)"Enable the recursive super pickaxe pickaxe mode"));
            b.parts(ImmutableList.of(this.rangePart2));
            b.action(this::recursive);
            Method commandMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"recursive", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int single(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"single", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.single(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int area(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"area", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.area(this.player(parameters), this.session(parameters), this.range(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int recursive(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SuperPickaxeCommands.class, (String)"recursive", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.recursive(this.player(parameters), this.session(parameters), this.range2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int range(CommandParameters parameters) {
        return (Integer)this.rangePart.value(parameters).asSingle(integer_Key);
    }

    private double range2(CommandParameters parameters) {
        return (Double)this.rangePart2.value(parameters).asSingle(double_Key);
    }
}

