/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ScriptingCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ScriptingCommandsRegistration
implements CommandRegistration<ScriptingCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ScriptingCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument filenamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filename"), (Component)TextComponent.of((String)"Filename of the CraftScript to load")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).build();
    private final CommandArgument argsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"args"), (Component)TextComponent.of((String)"Arguments to the CraftScript")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(string_Key)).variable(true).build();

    private ScriptingCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ScriptingCommandsRegistration builder() {
        return new ScriptingCommandsRegistration();
    }

    public ScriptingCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ScriptingCommandsRegistration containerInstance(ScriptingCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ScriptingCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ScriptingCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("cs", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Execute a CraftScript"));
            b.parts(ImmutableList.of(this.filenamePart, this.argsPart));
            b.action(this::cs);
            Method commandMethod = RegistrationUtil.getCommandMethod(ScriptingCommands.class, (String)"execute", (Class[])new Class[]{Player.class, LocalSession.class, String.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register(".s", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Execute last CraftScript"));
            b.parts(ImmutableList.of(this.argsPart));
            b.action(this::_s);
            Method commandMethod = RegistrationUtil.getCommandMethod(ScriptingCommands.class, (String)"executeLast", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cs(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ScriptingCommands.class, (String)"execute", (Class[])new Class[]{Player.class, LocalSession.class, String.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.execute(this.player(parameters), this.session(parameters), this.filename(parameters), this.args(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _s(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ScriptingCommands.class, (String)"executeLast", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.executeLast(this.player(parameters), this.session(parameters), this.args(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private List<String> args(CommandParameters parameters) {
        return this.argsPart.value(parameters).asMultiple(string_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private String filename(CommandParameters parameters) {
        return (String)this.filenamePart.value(parameters).asSingle(string_Key);
    }
}

