/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SchematicCommandsRegistration
implements CommandRegistration<SchematicCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private SchematicCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument filenamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filename"), (Component)TextComponent.of((String)"File name.")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).build();
    private final CommandArgument formatNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"formatName"), (Component)TextComponent.of((String)"Format name.")).defaultsTo(ImmutableList.of("sponge")).ofTypes(ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag allowOverwritePart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Overwrite an existing file.")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page to view.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag oldFirstPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Sort by date, oldest first")).build();
    private final NoArgCommandFlag newFirstPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Sort by date, newest first")).build();

    private SchematicCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SchematicCommandsRegistration builder() {
        return new SchematicCommandsRegistration();
    }

    public SchematicCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SchematicCommandsRegistration containerInstance(SchematicCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SchematicCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SchematicCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("load", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Load a schematic into your clipboard"));
            b.parts(ImmutableList.of(this.filenamePart, this.formatNamePart));
            b.action(this::load);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Player.class, LocalSession.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("save", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Save a schematic into your clipboard"));
            b.parts(ImmutableList.of(this.filenamePart, this.formatNamePart, this.allowOverwritePart));
            b.action(this::save);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Player.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete", b -> {
            b.aliases(ImmutableList.of("d"));
            b.description((Component)TextComponent.of((String)"Delete a saved schematic"));
            b.parts(ImmutableList.of(this.filenamePart));
            b.action(this::delete);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("formats", b -> {
            b.aliases(ImmutableList.of("listformats", "f"));
            b.description((Component)TextComponent.of((String)"List available formats"));
            b.parts(ImmutableList.of());
            b.action(this::formats);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases(ImmutableList.of("all", "ls"));
            b.description((Component)TextComponent.of((String)"List saved schematics"));
            b.footer((Component)TextComponent.of((String)"Note: Format is not fully verified until loading."));
            b.parts(ImmutableList.of(this.pagePart, this.oldFirstPart, this.newFirstPart));
            b.action(this::list);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int load(CommandParameters parameters) throws FilenameException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Player.class, LocalSession.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.load(this.player(parameters), this.session(parameters), this.filename(parameters), this.formatName(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int save(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Player.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.save(this.player(parameters), this.session(parameters), this.filename(parameters), this.formatName(parameters), this.allowOverwrite(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int delete(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.delete(this.actor(parameters), this.filename(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int formats(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.formats(this.actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int list(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.actor(parameters), this.page(parameters), this.oldFirst(parameters), this.newFirst(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private boolean oldFirst(CommandParameters parameters) {
        return this.oldFirstPart.in(parameters);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private boolean allowOverwrite(CommandParameters parameters) {
        return this.allowOverwritePart.in(parameters);
    }

    private String formatName(CommandParameters parameters) {
        return (String)this.formatNamePart.value(parameters).asSingle(string_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean newFirst(CommandParameters parameters) {
        return this.newFirstPart.in(parameters);
    }

    private Actor actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private int page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private String filename(CommandParameters parameters) {
        return (String)this.filenamePart.value(parameters).asSingle(string_Key);
    }
}

