/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.RegionCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class RegionCommandsRegistration
implements CommandRegistration<RegionCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<BlockVector3> blockVector3_directionIncludeDiagonalstrue_Key = Key.of(BlockVector3.class, (Annotation)new Object(){

        Annotation a(@Direction(includeDiagonals=true) Object ah) {
            return this.getClass().getDeclaredMethods()[0].getParameterAnnotations()[0][0];
        }
    }.a(null));
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private RegionCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to place")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument thicknessPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"The thickness of the line")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag shellPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Generate only a shell")).build();
    private final CommandArgument thicknessPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"The thickness of the curve")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument fromPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"from"), (Component)TextComponent.of((String)"The mask representing blocks to replace")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument toPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"to"), (Component)TextComponent.of((String)"The pattern of blocks to replace with")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to overlay")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"# of iterations to perform")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to use as the height map")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument countPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"count"), (Component)TextComponent.of((String)"# of blocks to move")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"The direction to move")).defaultsTo(ImmutableList.of("me")).ofTypes(ImmutableList.of(blockVector3_directionIncludeDiagonalstrue_Key)).build();
    private final CommandArgument replacePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"replace"), (Component)TextComponent.of((String)"The pattern of blocks to leave")).defaultsTo(ImmutableList.of("air")).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final NoArgCommandFlag moveSelectionPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Shift the selection to the target location")).build();
    private final NoArgCommandFlag ignoreAirBlocksPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Ignore air blocks")).build();
    private final NoArgCommandFlag copyEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Also copy entities")).build();
    private final NoArgCommandFlag copyBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also copy biomes")).build();
    private final ArgAcceptingCommandFlag maskPart2 = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Set the include mask, non-matching blocks become air")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument countPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"count"), (Component)TextComponent.of((String)"# of copies to stack")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"The direction to stack")).defaultsTo(ImmutableList.of("me")).ofTypes(ImmutableList.of(blockVector3_directionIncludeDiagonalstrue_Key)).build();
    private final NoArgCommandFlag moveSelectionPart2 = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Shift the selection to the last stacked copy")).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"The expression to use")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag offsetPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the selection's center as origin")).build();
    private final CommandArgument thicknessPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"Thickness of the shell to leave")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument patternPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to replace the hollowed area with")).defaultsTo(ImmutableList.of("air")).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to place")).defaultsTo(ImmutableList.of("tree")).ofTypes(ImmutableList.of(treeType_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the forest")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();

    private RegionCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static RegionCommandsRegistration builder() {
        return new RegionCommandsRegistration();
    }

    public RegionCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public RegionCommandsRegistration containerInstance(RegionCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public RegionCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public RegionCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/set", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets all the blocks in the region"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::_set);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"set", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/line", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Draws a line segment between cuboid selection corners"));
            b.footer((Component)TextComponent.of((String)"Can only be used with a cuboid selection"));
            b.parts(ImmutableList.of(this.patternPart2, this.thicknessPart, this.shellPart));
            b.action(this::_line);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"line", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/curve", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Draws a spline through selected points"));
            b.footer((Component)TextComponent.of((String)"Can only be used with a convex polyhedral selection"));
            b.parts(ImmutableList.of(this.patternPart2, this.thicknessPart2, this.shellPart));
            b.action(this::_curve);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"curve", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/replace", b -> {
            b.aliases(ImmutableList.of("/re", "/rep"));
            b.description((Component)TextComponent.of((String)"Replace all blocks in the selection with another"));
            b.parts(ImmutableList.of(this.fromPart, this.toPart));
            b.action(this::_replace);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"replace", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Mask.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/overlay", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set a block on top of blocks in the region"));
            b.parts(ImmutableList.of(this.patternPart3));
            b.action(this::_overlay);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"overlay", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/center", b -> {
            b.aliases(ImmutableList.of("/middle"));
            b.description((Component)TextComponent.of((String)"Set the center block(s)"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::_center);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"center", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/naturalize", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"3 layers of dirt on top then rock below"));
            b.parts(ImmutableList.of());
            b.action(this::_naturalize);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"naturalize", (Class[])new Class[]{Player.class, EditSession.class, Region.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/walls", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Build the four sides of the selection"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::_walls);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"walls", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/faces", b -> {
            b.aliases(ImmutableList.of("/outline"));
            b.description((Component)TextComponent.of((String)"Build the walls, ceiling, and floor of a selection"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::_faces);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"faces", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/smooth", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Smooth the elevation in the selection"));
            b.footer((Component)TextComponent.of((String)"Example: '//smooth 1 grass_block,dirt,stone' would only smooth natural surface terrain."));
            b.parts(ImmutableList.of(this.iterationsPart, this.maskPart));
            b.action(this::_smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"smooth", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Integer.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/move", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Move the contents of the selection"));
            b.parts(ImmutableList.of(this.countPart, this.directionPart, this.replacePart, this.moveSelectionPart, this.ignoreAirBlocksPart, this.copyEntitiesPart, this.copyBiomesPart, this.maskPart2));
            b.action(this::_move);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"move", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/stack", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Repeat the contents of the selection"));
            b.parts(ImmutableList.of(this.countPart2, this.directionPart2, this.moveSelectionPart2, this.ignoreAirBlocksPart, this.copyEntitiesPart, this.copyBiomesPart, this.maskPart2));
            b.action(this::_stack);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"stack", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/regen", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Regenerates the contents of the selection"));
            b.footer((Component)TextComponent.of((String)"This command might affect things outside the selection,\nif they are within the same chunk."));
            b.parts(ImmutableList.of());
            b.action(this::_regen);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"regenerateChunk", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/deform", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deforms a selected region with an expression"));
            b.footer((Component)TextComponent.of((String)"The expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. See also https://tinyurl.com/weexpr"));
            b.parts(ImmutableList.of(this.expressionPart, this.useRawCoordsPart, this.offsetPart));
            b.action(this::_deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hollow", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Hollows out the object contained in this selection"));
            b.footer((Component)TextComponent.of((String)"Thickness is measured in manhattan distance."));
            b.parts(ImmutableList.of(this.thicknessPart3, this.patternPart4));
            b.action(this::_hollow);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"hollow", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/forest", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Make a forest within the region"));
            b.parts(ImmutableList.of(this.typePart, this.densityPart));
            b.action(this::_forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"forest", (Class[])new Class[]{Player.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/flora", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Make flora within the region"));
            b.parts(ImmutableList.of(this.densityPart));
            b.action(this::_flora);
            Method commandMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"flora", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _set(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"set", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.set(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _line(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"line", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.line(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern2(parameters), this.thickness(parameters), this.shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _curve(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"curve", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.curve(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern2(parameters), this.thickness2(parameters), this.shell(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _replace(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"replace", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Mask.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.replace(this.player(parameters), this.editSession(parameters), this.region(parameters), this.from(parameters), this.to(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _overlay(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"overlay", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.overlay(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _center(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"center", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.center(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _naturalize(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"naturalize", (Class[])new Class[]{Player.class, EditSession.class, Region.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.naturalize(this.player(parameters), this.editSession(parameters), this.region(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _walls(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"walls", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.walls(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _faces(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"faces", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.faces(this.player(parameters), this.editSession(parameters), this.region(parameters), this.pattern(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"smooth", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Integer.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.smooth(this.player(parameters), this.editSession(parameters), this.region(parameters), this.iterations(parameters), this.mask(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _move(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"move", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.move(this.player(parameters), this.editSession(parameters), this.session(parameters), this.region(parameters), this.count(parameters), this.direction(parameters), this.replace(parameters), this.moveSelection(parameters), this.ignoreAirBlocks(parameters), this.copyEntities(parameters), this.copyBiomes(parameters), this.mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _stack(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"stack", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Region.class, Integer.TYPE, BlockVector3.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.stack(this.player(parameters), this.editSession(parameters), this.session(parameters), this.region(parameters), this.count2(parameters), this.direction2(parameters), this.moveSelection2(parameters), this.ignoreAirBlocks(parameters), this.copyEntities(parameters), this.copyBiomes(parameters), this.mask2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _regen(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"regenerateChunk", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.regenerateChunk(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, List.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.deform(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.expression(parameters), this.useRawCoords(parameters), this.offset(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _hollow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"hollow", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Integer.TYPE, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hollow(this.player(parameters), this.editSession(parameters), this.region(parameters), this.thickness3(parameters), this.pattern4(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"forest", (Class[])new Class[]{Player.class, EditSession.class, Region.class, TreeGenerator.TreeType.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.forest(this.player(parameters), this.editSession(parameters), this.region(parameters), this.type(parameters), this.density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _flora(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(RegionCommands.class, (String)"flora", (Class[])new Class[]{Player.class, EditSession.class, Region.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.flora(this.player(parameters), this.editSession(parameters), this.region(parameters), this.density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private int thickness3(CommandParameters parameters) {
        return (Integer)this.thicknessPart3.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int thickness(CommandParameters parameters) {
        return (Integer)this.thicknessPart.value(parameters).asSingle(integer_Key);
    }

    private double density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private Pattern to(CommandParameters parameters) {
        return (Pattern)this.toPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern replace(CommandParameters parameters) {
        return (Pattern)this.replacePart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern pattern3(CommandParameters parameters) {
        return (Pattern)this.patternPart3.value(parameters).asSingle(pattern_Key);
    }

    private boolean copyBiomes(CommandParameters parameters) {
        return this.copyBiomesPart.in(parameters);
    }

    private List<String> expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asMultiple(string_Key);
    }

    private Mask from(CommandParameters parameters) {
        return (Mask)this.fromPart.value(parameters).asSingle(mask_Key);
    }

    private boolean moveSelection(CommandParameters parameters) {
        return this.moveSelectionPart.in(parameters);
    }

    private int count2(CommandParameters parameters) {
        return (Integer)this.countPart2.value(parameters).asSingle(integer_Key);
    }

    private boolean ignoreAirBlocks(CommandParameters parameters) {
        return this.ignoreAirBlocksPart.in(parameters);
    }

    private int iterations(CommandParameters parameters) {
        return (Integer)this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private Mask mask2(CommandParameters parameters) {
        return (Mask)this.maskPart2.value(parameters).asSingle(mask_Key);
    }

    private Pattern pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private int thickness2(CommandParameters parameters) {
        return (Integer)this.thicknessPart2.value(parameters).asSingle(integer_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private boolean copyEntities(CommandParameters parameters) {
        return this.copyEntitiesPart.in(parameters);
    }

    private boolean moveSelection2(CommandParameters parameters) {
        return this.moveSelectionPart2.in(parameters);
    }

    private Region region(CommandParameters parameters) {
        return (Region)RegistrationUtil.requireOptional(region_selection_Key, (String)"region", (Optional)parameters.injectedValue(region_selection_Key));
    }

    private BlockVector3 direction(CommandParameters parameters) {
        return (BlockVector3)this.directionPart.value(parameters).asSingle(blockVector3_directionIncludeDiagonalstrue_Key);
    }

    private EditSession editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private int count(CommandParameters parameters) {
        return (Integer)this.countPart.value(parameters).asSingle(integer_Key);
    }

    private boolean useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private BlockVector3 direction2(CommandParameters parameters) {
        return (BlockVector3)this.directionPart2.value(parameters).asSingle(blockVector3_directionIncludeDiagonalstrue_Key);
    }

    private Mask mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private Pattern pattern4(CommandParameters parameters) {
        return (Pattern)this.patternPart4.value(parameters).asSingle(pattern_Key);
    }

    private boolean shell(CommandParameters parameters) {
        return this.shellPart.in(parameters);
    }

    private boolean offset(CommandParameters parameters) {
        return this.offsetPart.in(parameters);
    }
}

