/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.NavigationCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class NavigationCommandsRegistration
implements CommandRegistration<NavigationCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private CommandManager commandManager;
    private NavigationCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument levelsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"levels"), (Component)TextComponent.of((String)"# of levels to ascend")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument levelsPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"levels"), (Component)TextComponent.of((String)"# of levels to descend")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument clearancePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"clearance"), (Component)TextComponent.of((String)"# of blocks to leave above you")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag forceFlightPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Force using flight to keep you still")).build();
    private final NoArgCommandFlag forceGlassPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Force using glass to keep you still")).build();
    private final CommandArgument distancePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"distance"), (Component)TextComponent.of((String)"Distance to go upwards")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();

    private NavigationCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static NavigationCommandsRegistration builder() {
        return new NavigationCommandsRegistration();
    }

    public NavigationCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public NavigationCommandsRegistration containerInstance(NavigationCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public NavigationCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public NavigationCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("unstuck", b -> {
            b.aliases(ImmutableList.of("!"));
            b.description((Component)TextComponent.of((String)"Escape from being stuck inside a block"));
            b.parts(ImmutableList.of());
            b.action(this::unstuck);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"unstuck", (Class[])new Class[]{Player.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("ascend", b -> {
            b.aliases(ImmutableList.of("asc"));
            b.description((Component)TextComponent.of((String)"Go up a floor"));
            b.parts(ImmutableList.of(this.levelsPart));
            b.action(this::ascend);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"ascend", (Class[])new Class[]{Player.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("descend", b -> {
            b.aliases(ImmutableList.of("desc"));
            b.description((Component)TextComponent.of((String)"Go down a floor"));
            b.parts(ImmutableList.of(this.levelsPart2));
            b.action(this::descend);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"descend", (Class[])new Class[]{Player.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("ceil", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Go to the ceiling"));
            b.parts(ImmutableList.of(this.clearancePart, this.forceFlightPart, this.forceGlassPart));
            b.action(this::ceil);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"ceiling", (Class[])new Class[]{Player.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("thru", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Pass through walls"));
            b.parts(ImmutableList.of());
            b.action(this::thru);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"thru", (Class[])new Class[]{Player.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("jumpto", b -> {
            b.aliases(ImmutableList.of("j"));
            b.description((Component)TextComponent.of((String)"Teleport to a location"));
            b.parts(ImmutableList.of());
            b.action(this::jumpto);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"jumpTo", (Class[])new Class[]{Player.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("up", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Go upwards some distance"));
            b.parts(ImmutableList.of(this.distancePart, this.forceFlightPart, this.forceGlassPart));
            b.action(this::up);
            Method commandMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"up", (Class[])new Class[]{Player.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int unstuck(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"unstuck", (Class[])new Class[]{Player.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.unstuck(this.player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int ascend(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"ascend", (Class[])new Class[]{Player.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.ascend(this.player(parameters), this.levels(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int descend(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"descend", (Class[])new Class[]{Player.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.descend(this.player(parameters), this.levels2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int ceil(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"ceiling", (Class[])new Class[]{Player.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.ceiling(this.player(parameters), this.clearance(parameters), this.forceFlight(parameters), this.forceGlass(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int thru(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"thru", (Class[])new Class[]{Player.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.thru(this.player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int jumpto(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"jumpTo", (Class[])new Class[]{Player.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.jumpTo(this.player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int up(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(NavigationCommands.class, (String)"up", (Class[])new Class[]{Player.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.up(this.player(parameters), this.distance(parameters), this.forceFlight(parameters), this.forceGlass(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private boolean forceFlight(CommandParameters parameters) {
        return this.forceFlightPart.in(parameters);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private int clearance(CommandParameters parameters) {
        return (Integer)this.clearancePart.value(parameters).asSingle(integer_Key);
    }

    private int levels2(CommandParameters parameters) {
        return (Integer)this.levelsPart2.value(parameters).asSingle(integer_Key);
    }

    private int levels(CommandParameters parameters) {
        return (Integer)this.levelsPart.value(parameters).asSingle(integer_Key);
    }

    private int distance(CommandParameters parameters) {
        return (Integer)this.distancePart.value(parameters).asSingle(integer_Key);
    }

    private boolean forceGlass(CommandParameters parameters) {
        return this.forceGlassPart.in(parameters);
    }
}

