/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import org.enginehub.piston.annotation.Command;

public class NavigationCommands {
    private final WorldEdit worldEdit;

    public NavigationCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="unstuck", aliases={"!"}, desc="Escape from being stuck inside a block")
    @CommandPermissions(value={"worldedit.navigation.unstuck"})
    public void unstuck(Player player) throws WorldEditException {
        player.findFreePosition();
        player.print("There you go!");
    }

    @Command(name="ascend", aliases={"asc"}, desc="Go up a floor")
    @CommandPermissions(value={"worldedit.navigation.ascend"})
    public void ascend(Player player, int levels) throws WorldEditException {
        int ascentLevels = 0;
        while (player.ascendLevel() && levels != ++ascentLevels) {
        }
        if (ascentLevels == 0) {
            player.printError("No free spot above you found.");
        } else {
            player.print(ascentLevels != 1 ? "Ascended " + ascentLevels + " levels." : "Ascended a level.");
        }
    }

    @Command(name="descend", aliases={"desc"}, desc="Go down a floor")
    @CommandPermissions(value={"worldedit.navigation.descend"})
    public void descend(Player player, int levels) throws WorldEditException {
        int descentLevels = 0;
        while (player.descendLevel() && levels != ++descentLevels) {
        }
        if (descentLevels == 0) {
            player.printError("No free spot below you found.");
        } else {
            player.print(descentLevels != 1 ? "Descended " + descentLevels + " levels." : "Descended a level.");
        }
    }

    @Command(name="ceil", desc="Go to the ceiling")
    @CommandPermissions(value={"worldedit.navigation.ceiling"})
    @Logging(value=Logging.LogMode.POSITION)
    public void ceiling(Player player, int clearance, boolean forceFlight, boolean forceGlass) throws WorldEditException {
        boolean alwaysGlass;
        if (player.ascendToCeiling(clearance = Math.max(0, clearance), alwaysGlass = this.getAlwaysGlass(forceFlight, forceGlass))) {
            player.print("Whoosh!");
        } else {
            player.printError("No free spot above you found.");
        }
    }

    @Command(name="thru", desc="Pass through walls")
    @CommandPermissions(value={"worldedit.navigation.thru.command"})
    public void thru(Player player) throws WorldEditException {
        if (player.passThroughForwardWall(6)) {
            player.print("Whoosh!");
        } else {
            player.printError("No free spot ahead of you found.");
        }
    }

    @Command(name="jumpto", aliases={"j"}, desc="Teleport to a location")
    @CommandPermissions(value={"worldedit.navigation.jumpto.command"})
    public void jumpTo(Player player) throws WorldEditException {
        Location pos = player.getSolidBlockTrace(300);
        if (pos != null) {
            player.findFreePosition(pos);
            player.print("Poof!");
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(name="up", desc="Go upwards some distance")
    @CommandPermissions(value={"worldedit.navigation.up"})
    @Logging(value=Logging.LogMode.POSITION)
    public void up(Player player, int distance, boolean forceFlight, boolean forceGlass) throws WorldEditException {
        boolean alwaysGlass = this.getAlwaysGlass(forceFlight, forceGlass);
        if (player.ascendUpwards(distance, alwaysGlass)) {
            player.print("Whoosh!");
        } else {
            player.printError("You would hit something above you.");
        }
    }

    private boolean getAlwaysGlass(boolean forceFlight, boolean forceGlass) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        return forceGlass || config.navigationUseGlass && !forceFlight;
    }
}

