/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.entity.Player;
import org.enginehub.piston.annotation.Command;

public class HistoryCommands {
    private final WorldEdit worldEdit;

    public HistoryCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="undo", aliases={"/undo"}, desc="Undoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.undo", "worldedit.history.undo.self"})
    public void undo(Player player, LocalSession session, int times, String playerName) throws WorldEditException {
        EditSession undone;
        times = Math.max(1, times);
        LocalSession undoSession = session;
        if (playerName != null) {
            player.checkPermission("worldedit.history.undo.other");
            undoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (undoSession == null) {
                player.printError("Unable to find session for " + playerName);
                return;
            }
        }
        int timesUndone = 0;
        for (int i = 0; i < times && (undone = undoSession.undo(undoSession.getBlockBag(player), player)) != null; ++i) {
            ++timesUndone;
            this.worldEdit.flushBlockBag(player, undone);
        }
        if (timesUndone > 0) {
            player.print("Undid " + timesUndone + " available edits.");
        } else {
            player.printError("Nothing left to undo.");
        }
    }

    @Command(name="redo", aliases={"/redo"}, desc="Redoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.redo", "worldedit.history.redo.self"})
    public void redo(Player player, LocalSession session, int times, String playerName) throws WorldEditException {
        EditSession redone;
        times = Math.max(1, times);
        LocalSession redoSession = session;
        if (playerName != null) {
            player.checkPermission("worldedit.history.redo.other");
            redoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (redoSession == null) {
                player.printError("Unable to find session for " + playerName);
                return;
            }
        }
        int timesRedone = 0;
        for (int i = 0; i < times && (redone = redoSession.redo(redoSession.getBlockBag(player), player)) != null; ++i) {
            ++timesRedone;
            this.worldEdit.flushBlockBag(player, redone);
        }
        if (timesRedone > 0) {
            player.print("Redid " + timesRedone + " available edits.");
        } else {
            player.printError("Nothing left to redo.");
        }
    }

    @Command(name="clearhistory", aliases={"/clearhistory"}, desc="Clear your history")
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(Player player, LocalSession session) {
        session.clearHistory();
        player.print("History cleared.");
    }
}

