/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GenerationCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Radii;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class GenerationCommandsRegistration
implements CommandRegistration<GenerationCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_radii2_Key = Key.of(Double.class, (Annotation)new Object(){

        Annotation a(@Radii(value=2) Object ah) {
            return this.getClass().getDeclaredMethods()[0].getParameterAnnotations()[0][0];
        }
    }.a(null));
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Double> double_radii3_Key = Key.of(Double.class, (Annotation)new Object(){

        Annotation a(@Radii(value=3) Object ah) {
            return this.getClass().getDeclaredMethods()[0].getParameterAnnotations()[0][0];
        }
    }.a(null));
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<BiomeType> biomeType_Key = Key.of(BiomeType.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private CommandManager commandManager;
    private GenerationCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to generate")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiiPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radii"), (Component)TextComponent.of((String)"The radii of the cylinder. 1st is N/S, 2nd is E/W")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_radii2_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cylinder")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow cylinder")).build();
    private final CommandArgument radiiPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radii"), (Component)TextComponent.of((String)"The radii of the sphere. Order is N/S, U/D, E/W")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_radii3_Key)).build();
    private final NoArgCommandFlag raisedPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Raise the bottom of the sphere to the placement position")).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow sphere")).build();
    private final CommandArgument sizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the forest, in blocks")).defaultsTo(ImmutableList.of("10")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of forest")).defaultsTo(ImmutableList.of("tree")).ofTypes(ImmutableList.of(treeType_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the forest, between 0 and 100")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument sizePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the patch")).defaultsTo(ImmutableList.of("10")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument sizePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the pyramid")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart3 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow pyramid")).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to test block placement locations and set block type")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag hollowPart4 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Generate a hollow shape")).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag offsetPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement's coordinate origin")).build();
    private final NoArgCommandFlag offsetCenterPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Use the selection's center as origin")).build();
    private final CommandArgument targetPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"target"), (Component)TextComponent.of((String)"The biome type to set")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(biomeType_Key)).build();
    private final CommandArgument expressionPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to test block placement locations and set biome type")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).variable(true).build();

    private GenerationCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static GenerationCommandsRegistration builder() {
        return new GenerationCommandsRegistration();
    }

    public GenerationCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public GenerationCommandsRegistration containerInstance(GenerationCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public GenerationCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public GenerationCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/hcyl", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a hollow cylinder."));
            b.parts(ImmutableList.of(this.patternPart, this.radiiPart, this.heightPart));
            b.action(this::_hcyl);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hcyl", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/cyl", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a cylinder."));
            b.parts(ImmutableList.of(this.patternPart, this.radiiPart, this.heightPart, this.hollowPart));
            b.action(this::_cyl);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cyl", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hsphere", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a hollow sphere."));
            b.parts(ImmutableList.of(this.patternPart, this.radiiPart2, this.raisedPart));
            b.action(this::_hsphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hsphere", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/sphere", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a filled sphere."));
            b.parts(ImmutableList.of(this.patternPart, this.radiiPart2, this.raisedPart, this.hollowPart2));
            b.action(this::_sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"sphere", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forestgen", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate a forest"));
            b.parts(ImmutableList.of(this.sizePart, this.typePart, this.densityPart));
            b.action(this::forestgen);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"forestGen", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, TreeGenerator.TreeType.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("pumpkins", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate pumpkin patches"));
            b.parts(ImmutableList.of(this.sizePart2));
            b.action(this::pumpkins);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pumpkins", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpyramid", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate a hollow pyramid"));
            b.parts(ImmutableList.of(this.patternPart2, this.sizePart3));
            b.action(this::_hpyramid);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hollowPyramid", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/pyramid", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate a filled pyramid"));
            b.parts(ImmutableList.of(this.patternPart2, this.sizePart3, this.hollowPart3));
            b.action(this::_pyramid);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pyramid", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/generate", b -> {
            b.aliases(ImmutableList.of("/gen", "/g"));
            b.description((Component)TextComponent.of((String)"Generates a shape according to a formula."));
            b.footer((Component)TextComponent.of((String)"See also https://tinyurl.com/weexpr."));
            b.parts(ImmutableList.of(this.patternPart2, this.expressionPart, this.hollowPart4, this.useRawCoordsPart, this.offsetPart, this.offsetCenterPart));
            b.action(this::_generate);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generate", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/generatebiome", b -> {
            b.aliases(ImmutableList.of("/genbiome", "/gb"));
            b.description((Component)TextComponent.of((String)"Sets biome according to a formula."));
            b.footer((Component)TextComponent.of((String)"See also https://tinyurl.com/weexpr."));
            b.parts(ImmutableList.of(this.targetPart, this.expressionPart2, this.hollowPart4, this.useRawCoordsPart, this.offsetPart, this.offsetCenterPart));
            b.action(this::_generatebiome);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generateBiome", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, BiomeType.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _hcyl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hcyl", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hcyl(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radii(parameters), this.height(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _cyl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cyl", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.cyl(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radii(parameters), this.height(parameters), this.hollow(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _hsphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hsphere", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hsphere(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radii2(parameters), this.raised(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"sphere", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.sphere(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern(parameters), this.radii2(parameters), this.raised(parameters), this.hollow2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int forestgen(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"forestGen", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE, TreeGenerator.TreeType.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.forestGen(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size(parameters), this.type(parameters), this.density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int pumpkins(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pumpkins", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.pumpkins(this.player(parameters), this.session(parameters), this.editSession(parameters), this.size2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _hpyramid(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hollowPyramid", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hollowPyramid(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern2(parameters), this.size3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _pyramid(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pyramid", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.pyramid(this.player(parameters), this.session(parameters), this.editSession(parameters), this.pattern2(parameters), this.size3(parameters), this.hollow3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _generate(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generate", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.generate(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.pattern2(parameters), this.expression(parameters), this.hollow4(parameters), this.useRawCoords(parameters), this.offset(parameters), this.offsetCenter(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _generatebiome(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generateBiome", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, BiomeType.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.generateBiome(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.target(parameters), this.expression2(parameters), this.hollow4(parameters), this.useRawCoords(parameters), this.offset(parameters), this.offsetCenter(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private int height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean hollow3(CommandParameters parameters) {
        return this.hollowPart3.in(parameters);
    }

    private int size3(CommandParameters parameters) {
        return (Integer)this.sizePart3.value(parameters).asSingle(integer_Key);
    }

    private double density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private int size(CommandParameters parameters) {
        return (Integer)this.sizePart.value(parameters).asSingle(integer_Key);
    }

    private List<String> expression2(CommandParameters parameters) {
        return this.expressionPart2.value(parameters).asMultiple(string_Key);
    }

    private List<Double> radii(CommandParameters parameters) {
        return this.radiiPart.value(parameters).asMultiple(double_radii2_Key);
    }

    private List<String> expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asMultiple(string_Key);
    }

    private boolean raised(CommandParameters parameters) {
        return this.raisedPart.in(parameters);
    }

    private int size2(CommandParameters parameters) {
        return (Integer)this.sizePart2.value(parameters).asSingle(integer_Key);
    }

    private boolean offsetCenter(CommandParameters parameters) {
        return this.offsetCenterPart.in(parameters);
    }

    private List<Double> radii2(CommandParameters parameters) {
        return this.radiiPart2.value(parameters).asMultiple(double_radii3_Key);
    }

    private Pattern pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private BiomeType target(CommandParameters parameters) {
        return (BiomeType)this.targetPart.value(parameters).asSingle(biomeType_Key);
    }

    private boolean hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private boolean hollow4(CommandParameters parameters) {
        return this.hollowPart4.in(parameters);
    }

    private boolean hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private Region region(CommandParameters parameters) {
        return (Region)RegistrationUtil.requireOptional(region_selection_Key, (String)"region", (Optional)parameters.injectedValue(region_selection_Key));
    }

    private EditSession editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private boolean useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean offset(CommandParameters parameters) {
        return this.offsetPart.in(parameters);
    }
}

