/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Radii;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.List;
import org.enginehub.piston.annotation.Command;

public class GenerationCommands {
    private final WorldEdit worldEdit;

    public GenerationCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="/hcyl", desc="Generates a hollow cylinder.")
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int hcyl(Player player, LocalSession session, EditSession editSession, Pattern pattern, @Radii(value=2) List<Double> radii, int height) throws WorldEditException {
        return this.cyl(player, session, editSession, pattern, radii, height, true);
    }

    @Command(name="/cyl", desc="Generates a cylinder.")
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int cyl(Player player, LocalSession session, EditSession editSession, Pattern pattern, @Radii(value=2) List<Double> radii, int height, boolean hollow) throws WorldEditException {
        double radiusX;
        double radiusZ;
        switch (radii.size()) {
            case 1: {
                radiusX = radiusZ = Math.max(1.0, radii.get(0));
                break;
            }
            case 2: {
                radiusX = Math.max(1.0, radii.get(0));
                radiusZ = Math.max(1.0, radii.get(1));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 2 radius values.");
                return 0;
            }
        }
        this.worldEdit.checkMaxRadius(radiusX);
        this.worldEdit.checkMaxRadius(radiusZ);
        this.worldEdit.checkMaxRadius(height);
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, pattern, radiusX, radiusZ, height, !hollow);
        player.print(affected + " block(s) have been created.");
        return affected;
    }

    @Command(name="/hsphere", desc="Generates a hollow sphere.")
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int hsphere(Player player, LocalSession session, EditSession editSession, Pattern pattern, @Radii(value=3) List<Double> radii, boolean raised) throws WorldEditException {
        return this.sphere(player, session, editSession, pattern, radii, raised, true);
    }

    @Command(name="/sphere", desc="Generates a filled sphere.")
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int sphere(Player player, LocalSession session, EditSession editSession, Pattern pattern, @Radii(value=3) List<Double> radii, boolean raised, boolean hollow) throws WorldEditException {
        double radiusX;
        double radiusY;
        double radiusZ;
        switch (radii.size()) {
            case 1: {
                radiusY = radiusZ = Math.max(0.0, radii.get(0));
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = Math.max(0.0, radii.get(0));
                radiusY = Math.max(0.0, radii.get(1));
                radiusZ = Math.max(0.0, radii.get(2));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 3 radius values.");
                return 0;
            }
        }
        this.worldEdit.checkMaxRadius(radiusX);
        this.worldEdit.checkMaxRadius(radiusY);
        this.worldEdit.checkMaxRadius(radiusZ);
        BlockVector3 pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0, (int)radiusY, 0);
        }
        int affected = editSession.makeSphere(pos, pattern, radiusX, radiusY, radiusZ, !hollow);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
        return affected;
    }

    @Command(name="forestgen", desc="Generate a forest")
    @CommandPermissions(value={"worldedit.generation.forest"})
    @Logging(value=Logging.LogMode.POSITION)
    public int forestGen(Player player, LocalSession session, EditSession editSession, int size, TreeGenerator.TreeType type, double density) throws WorldEditException {
        CommandUtil.checkCommandArgument(0.0 <= density && density <= 100.0, "Density must be between 0 and 100");
        this.worldEdit.checkMaxRadius(size);
        int affected = editSession.makeForest(session.getPlacementPosition(player), size, density /= 100.0, type);
        player.print(affected + " trees created.");
        return affected;
    }

    @Command(name="pumpkins", desc="Generate pumpkin patches")
    @CommandPermissions(value={"worldedit.generation.pumpkins"})
    @Logging(value=Logging.LogMode.POSITION)
    public int pumpkins(Player player, LocalSession session, EditSession editSession, int size) throws WorldEditException {
        this.worldEdit.checkMaxRadius(size);
        int affected = editSession.makePumpkinPatches(session.getPlacementPosition(player), size);
        player.print(affected + " pumpkin patches created.");
        return affected;
    }

    @Command(name="/hpyramid", desc="Generate a hollow pyramid")
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int hollowPyramid(Player player, LocalSession session, EditSession editSession, Pattern pattern, int size) throws WorldEditException {
        return this.pyramid(player, session, editSession, pattern, size, true);
    }

    @Command(name="/pyramid", desc="Generate a filled pyramid")
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public int pyramid(Player player, LocalSession session, EditSession editSession, Pattern pattern, int size, boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxRadius(size);
        BlockVector3 pos = session.getPlacementPosition(player);
        int affected = editSession.makePyramid(pos, pattern, size, !hollow);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
        return affected;
    }

    @Command(name="/generate", aliases={"/gen", "/g"}, desc="Generates a shape according to a formula.", descFooter="See also https://tinyurl.com/weexpr.")
    @CommandPermissions(value={"worldedit.generation.shape"})
    @Logging(value=Logging.LogMode.ALL)
    public int generate(Player player, LocalSession session, EditSession editSession, @Selection Region region, Pattern pattern, List<String> expression, boolean hollow, boolean useRawCoords, boolean offset, boolean offsetCenter) throws WorldEditException {
        Vector3 min;
        Vector3 unit;
        Vector3 zero;
        if (useRawCoords) {
            zero = Vector3.ZERO;
            unit = Vector3.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player).toVector3();
            unit = Vector3.ONE;
        } else if (offsetCenter) {
            min = region.getMinimumPoint().toVector3();
            Vector3 max = region.getMaximumPoint().toVector3();
            zero = max.add(min).multiply(0.5);
            unit = Vector3.ONE;
        } else {
            min = region.getMinimumPoint().toVector3();
            Vector3 max = region.getMaximumPoint().toVector3();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.withX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.withY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.withZ(1.0);
            }
        }
        try {
            int affected = editSession.makeShape(region, zero, unit, pattern, String.join((CharSequence)" ", expression), hollow, session.getTimeout());
            player.findFreePosition();
            player.print(affected + " block(s) have been created.");
            return affected;
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
            return 0;
        }
    }

    @Command(name="/generatebiome", aliases={"/genbiome", "/gb"}, desc="Sets biome according to a formula.", descFooter="See also https://tinyurl.com/weexpr.")
    @CommandPermissions(value={"worldedit.generation.shape.biome"})
    @Logging(value=Logging.LogMode.ALL)
    public int generateBiome(Player player, LocalSession session, EditSession editSession, @Selection Region region, BiomeType target, List<String> expression, boolean hollow, boolean useRawCoords, boolean offset, boolean offsetCenter) throws WorldEditException {
        Vector3 min;
        Vector3 unit;
        Vector3 zero;
        if (useRawCoords) {
            zero = Vector3.ZERO;
            unit = Vector3.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player).toVector3();
            unit = Vector3.ONE;
        } else if (offsetCenter) {
            min = region.getMinimumPoint().toVector3();
            Vector3 max = region.getMaximumPoint().toVector3();
            zero = max.add(min).multiply(0.5);
            unit = Vector3.ONE;
        } else {
            min = region.getMinimumPoint().toVector3();
            Vector3 max = region.getMaximumPoint().toVector3();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.withX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.withY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.withZ(1.0);
            }
        }
        try {
            int affected = editSession.makeBiomeShape(region, zero, unit, target, String.join((CharSequence)" ", expression), hollow, session.getTimeout());
            player.findFreePosition();
            player.print("" + affected + " columns affected.");
            return affected;
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
            return 0;
        }
    }
}

