/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GeneralCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class GeneralCommandsRegistration
implements CommandRegistration<GeneralCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<EditSession.ReorderMode> reorderMode_Key = Key.of(EditSession.ReorderMode.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private GeneralCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument limitPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"limit"), (Component)TextComponent.of((String)"The limit to set")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument limitPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"limit"), (Component)TextComponent.of((String)"The timeout time to set")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument fastModePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fastMode"), (Component)TextComponent.of((String)"The new fast mode state")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(boolean_Key)).build();
    private final CommandArgument reorderModePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"reorderMode"), (Component)TextComponent.of((String)"The reorder mode")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(reorderMode_Key)).build();
    private final CommandArgument drawSelectionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"drawSelection"), (Component)TextComponent.of((String)"The new draw selection state")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(boolean_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask to set")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag blocksOnlyPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Only search for blocks")).build();
    private final NoArgCommandFlag itemsOnlyPart = CommandParts.flag((char)'i', (Component)TextComponent.of((String)"Only search for items")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page of results to return")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument queryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"query"), (Component)TextComponent.of((String)"Search query")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(string_Key)).variable(true).build();

    private GeneralCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static GeneralCommandsRegistration builder() {
        return new GeneralCommandsRegistration();
    }

    public GeneralCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public GeneralCommandsRegistration containerInstance(GeneralCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public GeneralCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public GeneralCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/limit", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Modify block change limit"));
            b.parts(ImmutableList.of(this.limitPart));
            b.action(this::_limit);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"limit", (Class[])new Class[]{Player.class, LocalSession.class, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/timeout", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Modify evaluation timeout time."));
            b.parts(ImmutableList.of(this.limitPart2));
            b.action(this::_timeout);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"timeout", (Class[])new Class[]{Player.class, LocalSession.class, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/fast", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle fast mode"));
            b.parts(ImmutableList.of(this.fastModePart));
            b.action(this::_fast);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"fast", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/reorder", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets the reorder mode of WorldEdit"));
            b.parts(ImmutableList.of(this.reorderModePart));
            b.action(this::_reorder);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"reorderMode", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.ReorderMode.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/drawsel", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle drawing the current selection"));
            b.parts(ImmutableList.of(this.drawSelectionPart));
            b.action(this::_drawsel);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"drawSelection", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gmask", b -> {
            b.aliases(ImmutableList.of("/gmask"));
            b.description((Component)TextComponent.of((String)"Set the global mask"));
            b.parts(ImmutableList.of(this.maskPart));
            b.action(this::gmask);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"gmask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggleplace", b -> {
            b.aliases(ImmutableList.of("/toggleplace"));
            b.description((Component)TextComponent.of((String)"Switch between your position and pos1 for placement"));
            b.parts(ImmutableList.of());
            b.action(this::toggleplace);
        });
        this.commandManager.register("searchitem", b -> {
            b.aliases(ImmutableList.of("/searchitem", "/l", "/search"));
            b.description((Component)TextComponent.of((String)"Search for an item"));
            b.parts(ImmutableList.of(this.blocksOnlyPart, this.itemsOnlyPart, this.pagePart, this.queryPart));
            b.action(this::searchitem);
            Method commandMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"searchItem", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _limit(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"limit", (Class[])new Class[]{Player.class, LocalSession.class, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.limit(this.player(parameters), this.session(parameters), this.limit(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _timeout(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"timeout", (Class[])new Class[]{Player.class, LocalSession.class, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.timeout(this.player(parameters), this.session(parameters), this.limit2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _fast(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"fast", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.fast(this.player(parameters), this.session(parameters), this.fastMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _reorder(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"reorderMode", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.ReorderMode.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.reorderMode(this.player(parameters), this.session(parameters), this.reorderMode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _drawsel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"drawSelection", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.drawSelection(this.player(parameters), this.session(parameters), this.drawSelection(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int gmask(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"gmask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.gmask(this.player(parameters), this.session(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int toggleplace(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"togglePlace", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.togglePlace(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int searchitem(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GeneralCommands.class, (String)"searchItem", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.searchItem(this.actor(parameters), this.blocksOnly(parameters), this.itemsOnly(parameters), this.page(parameters), this.query(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Boolean fastMode(CommandParameters parameters) {
        return (Boolean)this.fastModePart.value(parameters).asSingle(boolean_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean blocksOnly(CommandParameters parameters) {
        return this.blocksOnlyPart.in(parameters);
    }

    private List<String> query(CommandParameters parameters) {
        return this.queryPart.value(parameters).asMultiple(string_Key);
    }

    private Integer limit(CommandParameters parameters) {
        return (Integer)this.limitPart.value(parameters).asSingle(integer_Key);
    }

    private int page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private EditSession.ReorderMode reorderMode(CommandParameters parameters) {
        return (EditSession.ReorderMode)((Object)this.reorderModePart.value(parameters).asSingle(reorderMode_Key));
    }

    private Boolean drawSelection(CommandParameters parameters) {
        return (Boolean)this.drawSelectionPart.value(parameters).asSingle(boolean_Key);
    }

    private Integer limit2(CommandParameters parameters) {
        return (Integer)this.limitPart2.value(parameters).asSingle(integer_Key);
    }

    private Actor actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private Mask mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private boolean itemsOnly(CommandParameters parameters) {
        return this.itemsOnlyPart.in(parameters);
    }
}

