/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.DisallowedUsageException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.enginehub.piston.annotation.Command;

public class GeneralCommands {
    private final WorldEdit worldEdit;

    public GeneralCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="/limit", desc="Modify block change limit")
    @CommandPermissions(value={"worldedit.limit"})
    public void limit(Player player, LocalSession session, Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = player.hasPermission("worldedit.limit.unrestricted");
        limit = limit == null ? config.defaultChangeLimit : Math.max(-1, limit);
        if (!mayDisable && config.maxChangeLimit > -1 && limit > config.maxChangeLimit) {
            player.printError("Your maximum allowable limit is " + config.maxChangeLimit + ".");
            return;
        }
        session.setBlockChangeLimit(limit);
        player.print("Block change limit set to " + limit + "." + (limit == config.defaultChangeLimit ? "" : " (Use //limit to go back to the default.)"));
    }

    @Command(name="/timeout", desc="Modify evaluation timeout time.")
    @CommandPermissions(value={"worldedit.timeout"})
    public void timeout(Player player, LocalSession session, Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = player.hasPermission("worldedit.timeout.unrestricted");
        limit = limit == null ? config.calculationTimeout : Math.max(-1, limit);
        if (!mayDisable && config.maxCalculationTimeout > -1 && limit > config.maxCalculationTimeout) {
            player.printError("Your maximum allowable timeout is " + config.maxCalculationTimeout + " ms.");
            return;
        }
        session.setTimeout(limit);
        player.print("Timeout time set to " + limit + " ms." + (limit == config.calculationTimeout ? "" : " (Use //timeout to go back to the default.)"));
    }

    @Command(name="/fast", desc="Toggle fast mode")
    @CommandPermissions(value={"worldedit.fast"})
    public void fast(Player player, LocalSession session, Boolean fastMode) {
        boolean hasFastMode = session.hasFastMode();
        if (fastMode != null && fastMode == hasFastMode) {
            player.printError("Fast mode already " + (fastMode != false ? "enabled" : "disabled") + ".");
            return;
        }
        if (hasFastMode) {
            session.setFastMode(false);
            player.print("Fast mode disabled.");
        } else {
            session.setFastMode(true);
            player.print("Fast mode enabled. Lighting in the affected chunks may be wrong and/or you may need to rejoin to see changes.");
        }
    }

    @Command(name="/reorder", desc="Sets the reorder mode of WorldEdit")
    @CommandPermissions(value={"worldedit.reorder"})
    public void reorderMode(Player player, LocalSession session, EditSession.ReorderMode reorderMode) {
        if (reorderMode == null) {
            player.print("The reorder mode is " + session.getReorderMode().getDisplayName());
        } else {
            session.setReorderMode(reorderMode);
            player.print("The reorder mode is now " + session.getReorderMode().getDisplayName());
        }
    }

    @Command(name="/drawsel", desc="Toggle drawing the current selection")
    @CommandPermissions(value={"worldedit.drawsel"})
    public void drawSelection(Player player, LocalSession session, Boolean drawSelection) throws WorldEditException {
        if (!WorldEdit.getInstance().getConfiguration().serverSideCUI) {
            throw new DisallowedUsageException("This functionality is disabled in the configuration!");
        }
        boolean useServerCui = session.shouldUseServerCUI();
        if (drawSelection != null && drawSelection == useServerCui) {
            player.printError("Server CUI already " + (useServerCui ? "enabled" : "disabled") + ".");
            return;
        }
        if (useServerCui) {
            session.setUseServerCUI(false);
            session.updateServerCUI(player);
            player.print("Server CUI disabled.");
        } else {
            session.setUseServerCUI(true);
            session.updateServerCUI(player);
            player.print("Server CUI enabled. This only supports cuboid regions, with a maximum size of 32x32x32.");
        }
    }

    @Command(name="gmask", aliases={"/gmask"}, desc="Set the global mask")
    @CommandPermissions(value={"worldedit.global-mask"})
    public void gmask(Player player, LocalSession session, Mask mask) {
        if (mask == null) {
            session.setMask(null);
            player.print("Global mask disabled.");
        } else {
            session.setMask(mask);
            player.print("Global mask set.");
        }
    }

    @Command(name="toggleplace", aliases={"/toggleplace"}, desc="Switch between your position and pos1 for placement")
    public void togglePlace(Player player, LocalSession session) {
        if (session.togglePlacementPosition()) {
            player.print("Now placing at pos #1.");
        } else {
            player.print("Now placing at the block you stand in.");
        }
    }

    @Command(name="searchitem", aliases={"/searchitem", "/l", "/search"}, desc="Search for an item")
    @CommandPermissions(value={"worldedit.searchitem"})
    public void searchItem(Actor actor, boolean blocksOnly, boolean itemsOnly, int page, List<String> query) {
        String search = String.join((CharSequence)" ", query);
        if (search.length() <= 2) {
            actor.printError("Enter a longer search string (len > 2).");
            return;
        }
        if (blocksOnly && itemsOnly) {
            actor.printError("You cannot use both the 'b' and 'i' flags simultaneously.");
            return;
        }
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, new ItemSearcher(search, blocksOnly, itemsOnly, page), "(Please wait... searching items.)");
    }

    private static class ItemSearcher
    implements Callable<Component> {
        private final boolean blocksOnly;
        private final boolean itemsOnly;
        private final String search;
        private final int page;

        ItemSearcher(String search, boolean blocksOnly, boolean itemsOnly, int page) {
            this.blocksOnly = blocksOnly;
            this.itemsOnly = itemsOnly;
            this.search = search;
            this.page = page;
        }

        @Override
        public Component call() throws Exception {
            String command = "/searchitem " + (this.blocksOnly ? "-b " : "") + (this.itemsOnly ? "-i " : "") + "-p %page% " + this.search;
            TreeMap<String, String> results = new TreeMap<String, String>();
            String idMatch = this.search.replace(' ', '_');
            String nameMatch = this.search.toLowerCase(Locale.ROOT);
            for (ItemType searchType : ItemType.REGISTRY) {
                if (this.blocksOnly && !searchType.hasBlockType() || this.itemsOnly && searchType.hasBlockType()) continue;
                String id = searchType.getId();
                String name = searchType.getName();
                boolean hasName = !name.equals(id);
                name = name.toLowerCase(Locale.ROOT);
                if (!id.contains(idMatch) && (!hasName || !name.contains(nameMatch))) continue;
                results.put(id, name + (hasName ? " (" + id + ")" : ""));
            }
            ArrayList<String> list = new ArrayList<String>(results.values());
            return PaginationBox.fromStrings("Search results for '" + this.search + "'", command, list).create(this.page);
        }
    }
}

