/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ExpandCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ExpandCommandsRegistration
implements CommandRegistration<ExpandCommands> {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<BlockVector3> blockVector3_multiDirection_Key = Key.of(BlockVector3.class, MultiDirection.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ExpandCommands containerInstance;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument amountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to expand the selection by, can be `vert` to expand to the whole vertical column")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument reverseAmountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"reverseAmount"), (Component)TextComponent.of((String)"Amount to expand the selection by in the other direction")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"Direction to expand")).defaultsTo(ImmutableList.of("me")).ofTypes(ImmutableList.of(blockVector3_multiDirection_Key)).build();

    private ExpandCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ExpandCommandsRegistration builder() {
        return new ExpandCommandsRegistration();
    }

    public ExpandCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ExpandCommandsRegistration containerInstance(ExpandCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public ExpandCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/expand", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Expand the selection area"));
            b.parts(ImmutableList.of(this.amountPart, this.reverseAmountPart, this.directionPart));
            b.action(this::_expand);
        });
    }

    private int _expand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ExpandCommands.class, (String)"expand", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.expand(this.player(parameters), this.session(parameters), this.amount(parameters), this.reverseAmount(parameters), this.direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int amount(CommandParameters parameters) {
        return (Integer)this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private int reverseAmount(CommandParameters parameters) {
        return (Integer)this.reverseAmountPart.value(parameters).asSingle(integer_Key);
    }

    private List<BlockVector3> direction(CommandParameters parameters) {
        return this.directionPart.value(parameters).asMultiple(blockVector3_multiDirection_Key);
    }
}

