/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ClipboardCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.ClipboardMask;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class ClipboardCommandsRegistration
implements CommandRegistration<ClipboardCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Mask> mask_clipboardMask_Key = Key.of(Mask.class, ClipboardMask.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<BlockVector3> blockVector3_direction_Key = Key.of(BlockVector3.class, Direction.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private CommandManager commandManager;
    private ClipboardCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final NoArgCommandFlag copyEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Also copy entities")).build();
    private final NoArgCommandFlag copyBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also copy biomes")).build();
    private final ArgAcceptingCommandFlag maskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Set the include mask, non-matching blocks become air")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument leavePatternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"leavePattern"), (Component)TextComponent.of((String)"Pattern to leave in place of the selection")).defaultsTo(ImmutableList.of("air")).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final NoArgCommandFlag copyEntitiesPart2 = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Also cut entities")).build();
    private final NoArgCommandFlag copyBiomesPart2 = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also copy biomes, source biomes are unaffected")).build();
    private final ArgAcceptingCommandFlag maskPart2 = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Set the exclude mask, non-matching blocks become air")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag ignoreAirBlocksPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Skip air blocks")).build();
    private final NoArgCommandFlag atOriginPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Paste at the original position")).build();
    private final NoArgCommandFlag selectPastedPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Select the region after pasting")).build();
    private final NoArgCommandFlag pasteEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Paste entities if available")).build();
    private final NoArgCommandFlag pasteBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Paste biomes if available")).build();
    private final ArgAcceptingCommandFlag sourceMaskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Only paste blocks matching this mask")).withRequiredArg().argNamed(TranslatableComponent.of((String)"sourceMask")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_clipboardMask_Key)).build();
    private final CommandArgument yRotatePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"yRotate"), (Component)TextComponent.of((String)"Amount to rotate on the y-axis")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument xRotatePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"xRotate"), (Component)TextComponent.of((String)"Amount to rotate on the x-axis")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument zRotatePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"zRotate"), (Component)TextComponent.of((String)"Amount to rotate on the z-axis")).defaultsTo(ImmutableList.of("0")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"The direction to flip, defaults to look direction.")).defaultsTo(ImmutableList.of("me")).ofTypes(ImmutableList.of(blockVector3_direction_Key)).build();

    private ClipboardCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ClipboardCommandsRegistration builder() {
        return new ClipboardCommandsRegistration();
    }

    public ClipboardCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ClipboardCommandsRegistration containerInstance(ClipboardCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ClipboardCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ClipboardCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/copy", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Copy the selection to the clipboard"));
            b.parts(ImmutableList.of(this.copyEntitiesPart, this.copyBiomesPart, this.maskPart));
            b.action(this::_copy);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"copy", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/cut", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Cut the selection to the clipboard"));
            b.parts(ImmutableList.of(this.leavePatternPart, this.copyEntitiesPart2, this.copyBiomesPart2, this.maskPart2));
            b.action(this::_cut);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"cut", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/paste", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Paste the clipboard's contents"));
            b.parts(ImmutableList.of(this.ignoreAirBlocksPart, this.atOriginPart, this.selectPastedPart, this.pasteEntitiesPart, this.pasteBiomesPart, this.sourceMaskPart));
            b.action(this::_paste);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"paste", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/rotate", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Rotate the contents of the clipboard"));
            b.footer((Component)TextComponent.of((String)"Non-destructively rotate the contents of the clipboard.\nAngles are provided in degrees and a positive angle will result in a clockwise rotation. Multiple rotations can be stacked. Interpolation is not performed so angles should be a multiple of 90 degrees.\n"));
            b.parts(ImmutableList.of(this.yRotatePart, this.xRotatePart, this.zRotatePart));
            b.action(this::_rotate);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"rotate", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Double.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/flip", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Flip the contents of the clipboard across the origin"));
            b.parts(ImmutableList.of(this.directionPart));
            b.action(this::_flip);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"flip", (Class[])new Class[]{Player.class, LocalSession.class, BlockVector3.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clearclipboard", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Clear your clipboard"));
            b.parts(ImmutableList.of());
            b.action(this::clearclipboard);
            Method commandMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"clearClipboard", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int _copy(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"copy", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.copy(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.copyEntities(parameters), this.copyBiomes(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _cut(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"cut", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cut(this.player(parameters), this.session(parameters), this.editSession(parameters), this.region(parameters), this.leavePattern(parameters), this.copyEntities2(parameters), this.copyBiomes2(parameters), this.mask2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _paste(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"paste", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.paste(this.player(parameters), this.session(parameters), this.editSession(parameters), this.ignoreAirBlocks(parameters), this.atOrigin(parameters), this.selectPasted(parameters), this.pasteEntities(parameters), this.pasteBiomes(parameters), this.sourceMask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _rotate(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"rotate", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Double.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.rotate(this.player(parameters), this.session(parameters), this.yRotate(parameters), this.xRotate(parameters), this.zRotate(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _flip(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"flip", (Class[])new Class[]{Player.class, LocalSession.class, BlockVector3.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.flip(this.player(parameters), this.session(parameters), this.direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int clearclipboard(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ClipboardCommands.class, (String)"clearClipboard", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clearClipboard(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private boolean copyEntities2(CommandParameters parameters) {
        return this.copyEntitiesPart2.in(parameters);
    }

    private boolean copyBiomes2(CommandParameters parameters) {
        return this.copyBiomesPart2.in(parameters);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private Mask mask2(CommandParameters parameters) {
        return (Mask)this.maskPart2.value(parameters).asSingle(mask_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private double xRotate(CommandParameters parameters) {
        return (Double)this.xRotatePart.value(parameters).asSingle(double_Key);
    }

    private double yRotate(CommandParameters parameters) {
        return (Double)this.yRotatePart.value(parameters).asSingle(double_Key);
    }

    private Pattern leavePattern(CommandParameters parameters) {
        return (Pattern)this.leavePatternPart.value(parameters).asSingle(pattern_Key);
    }

    private boolean selectPasted(CommandParameters parameters) {
        return this.selectPastedPart.in(parameters);
    }

    private Mask sourceMask(CommandParameters parameters) {
        return (Mask)this.sourceMaskPart.value(parameters).asSingle(mask_clipboardMask_Key);
    }

    private BlockVector3 direction(CommandParameters parameters) {
        return (BlockVector3)this.directionPart.value(parameters).asSingle(blockVector3_direction_Key);
    }

    private boolean copyEntities(CommandParameters parameters) {
        return this.copyEntitiesPart.in(parameters);
    }

    private boolean atOrigin(CommandParameters parameters) {
        return this.atOriginPart.in(parameters);
    }

    private double zRotate(CommandParameters parameters) {
        return (Double)this.zRotatePart.value(parameters).asSingle(double_Key);
    }

    private Region region(CommandParameters parameters) {
        return (Region)RegistrationUtil.requireOptional(region_selection_Key, (String)"region", (Optional)parameters.injectedValue(region_selection_Key));
    }

    private boolean copyBiomes(CommandParameters parameters) {
        return this.copyBiomesPart.in(parameters);
    }

    private EditSession editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private boolean pasteEntities(CommandParameters parameters) {
        return this.pasteEntitiesPart.in(parameters);
    }

    private Mask mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private boolean ignoreAirBlocks(CommandParameters parameters) {
        return this.ignoreAirBlocksPart.in(parameters);
    }

    private boolean pasteBiomes(CommandParameters parameters) {
        return this.pasteBiomesPart.in(parameters);
    }
}

