/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.google.gson.JsonIOException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.anvil.ChunkDeletionInfo;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.storage.LegacyChunkStore;
import com.sk89q.worldedit.world.storage.McRegionChunkStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.exception.StopExecutionException;

public class ChunkCommands {
    private final WorldEdit worldEdit;

    public ChunkCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull(worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="chunkinfo", desc="Get information about the chunk you're inside")
    @CommandPermissions(value={"worldedit.chunkinfo"})
    public void chunkInfo(Player player) {
        Location pos = player.getBlockIn();
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        BlockVector2 chunkPos = BlockVector2.at(chunkX, chunkZ);
        player.print("Chunk: " + chunkX + ", " + chunkZ);
        player.print("Old format: " + LegacyChunkStore.getFilename(chunkPos));
        player.print("McRegion: region/" + McRegionChunkStore.getFilename(chunkPos));
    }

    @Command(name="listchunks", desc="List chunks that your selection includes")
    @CommandPermissions(value={"worldedit.listchunks"})
    public void listChunks(Player player, LocalSession session, int page) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        WorldEditAsyncCommandBuilder.createAndSendMessage(player, () -> new ChunkListPaginationBox(region).create(page), "Listing chunks for " + player.getName());
    }

    @Command(name="delchunks", desc="Delete chunks that your selection includes")
    @CommandPermissions(value={"worldedit.delchunks"})
    @Logging(value=Logging.LogMode.REGION)
    public void deleteChunks(Player player, LocalSession session, ZonedDateTime beforeTime) throws WorldEditException {
        Path worldDir = player.getWorld().getStoragePath();
        if (worldDir == null) {
            throw new StopExecutionException((Component)TextComponent.of((String)"Couldn't find world folder for this world."));
        }
        File chunkFile = this.worldEdit.getWorkingDirectoryFile("delete_chunks.json");
        Path chunkPath = chunkFile.toPath();
        ChunkDeletionInfo currentInfo = null;
        if (Files.exists(chunkPath, new LinkOption[0])) {
            try {
                currentInfo = ChunkDeleter.readInfo(chunkFile.toPath());
            }
            catch (IOException e) {
                throw new StopExecutionException((Component)TextComponent.of((String)"Error reading existing chunk file."));
            }
        }
        if (currentInfo == null) {
            currentInfo = new ChunkDeletionInfo();
            currentInfo.batches = new ArrayList<ChunkDeletionInfo.ChunkBatch>();
        }
        ChunkDeletionInfo.ChunkBatch newBatch = new ChunkDeletionInfo.ChunkBatch();
        newBatch.worldPath = worldDir.toAbsolutePath().normalize().toString();
        newBatch.backup = true;
        Region selection = session.getSelection(player.getWorld());
        if (selection instanceof CuboidRegion) {
            newBatch.minChunk = selection.getMinimumPoint().shr(4).toBlockVector2();
            newBatch.maxChunk = selection.getMaximumPoint().shr(4).toBlockVector2();
        } else {
            Set<BlockVector2> chunks = selection.getChunks();
            newBatch.chunks = new ArrayList<BlockVector2>(chunks);
        }
        if (beforeTime != null) {
            newBatch.deletionPredicates = new ArrayList<ChunkDeletionInfo.DeletionPredicate>();
            ChunkDeletionInfo.DeletionPredicate timePred = new ChunkDeletionInfo.DeletionPredicate();
            timePred.property = "modification";
            timePred.comparison = "<";
            timePred.value = String.valueOf((int)beforeTime.toOffsetDateTime().toEpochSecond());
            newBatch.deletionPredicates.add(timePred);
        }
        currentInfo.batches.add(newBatch);
        try {
            ChunkDeleter.writeInfo(currentInfo, chunkPath);
        }
        catch (JsonIOException | IOException e) {
            throw new StopExecutionException((Component)TextComponent.of((String)("Failed to write chunk list: " + e.getMessage())));
        }
        player.print(String.format("%d chunk(s) have been marked for deletion the next time the server starts.", newBatch.getChunkCount()));
        if (currentInfo.batches.size() > 1) {
            player.printDebug(String.format("%d chunks total marked for deletion. (May have overlaps).", currentInfo.batches.stream().mapToInt(ChunkDeletionInfo.ChunkBatch::getChunkCount).sum()));
        }
        player.print(TextComponent.of((String)"You can mark more chunks for deletion, or to stop now, run: ", (TextColor)TextColor.LIGHT_PURPLE).append(TextComponent.of((String)"/stop", (TextColor)TextColor.AQUA).clickEvent(ClickEvent.of((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)"/stop"))));
    }

    private static class ChunkListPaginationBox
    extends PaginationBox {
        private final List<BlockVector2> chunks;

        ChunkListPaginationBox(Region region) {
            super("Selected Chunks", "/listchunks -p %page%");
            this.chunks = new ArrayList<BlockVector2>(region.getChunks());
        }

        @Override
        public Component getComponent(int number) {
            return TextComponent.of((String)this.chunks.get(number).toString());
        }

        @Override
        public int getComponentsSize() {
            return this.chunks.size();
        }
    }
}

