/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.ClipboardMask;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class BrushCommandsRegistration
implements CommandRegistration<BrushCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_clipboardMask_Key = Key.of(Mask.class, ClipboardMask.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<RegionFactory> regionFactory_Key = Key.of(RegionFactory.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private BrushCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiusPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the sphere")).defaultsTo(ImmutableList.of("2")).ofTypes(ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow spheres instead")).build();
    private final CommandArgument radiusPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the cylinder")).defaultsTo(ImmutableList.of("2")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cylinder")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow cylinders instead")).build();
    private final NoArgCommandFlag ignoreAirPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Don't paste air from the clipboard")).build();
    private final NoArgCommandFlag usingOriginPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Paste starting at the target location, instead of centering on it")).build();
    private final NoArgCommandFlag pasteEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Paste entities if available")).build();
    private final NoArgCommandFlag pasteBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Paste biomes if available")).build();
    private final ArgAcceptingCommandFlag sourceMaskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Skip blocks matching this mask in the clipboard")).withRequiredArg().argNamed(TranslatableComponent.of((String)"sourceMask")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_clipboardMask_Key)).build();
    private final CommandArgument radiusPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for softening")).defaultsTo(ImmutableList.of("2")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"The number of iterations to perform")).defaultsTo(ImmutableList.of("4")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to use for the heightmap")).defaultsTo(ImmutableList.of("")).ofTypes(ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to extinguish")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart5 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to apply gravity in")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag fromMaxYPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Affect blocks starting at max Y, rather than the target location Y + radius")).build();
    private final CommandArgument radiusPart6 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Radius to kill mobs in")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag killPetsPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Also kill pets")).build();
    private final NoArgCommandFlag killNpcsPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Also kill NPCs")).build();
    private final NoArgCommandFlag killGolemsPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Also kill golems")).build();
    private final NoArgCommandFlag killAnimalsPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Also kill animals")).build();
    private final NoArgCommandFlag killAmbientPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also kill ambient mobs")).build();
    private final NoArgCommandFlag killWithNamePart = CommandParts.flag((char)'t', (Component)TextComponent.of((String)"Also kill mobs with name tags")).build();
    private final NoArgCommandFlag killFriendlyPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Also kill all friendly mobs (Applies the flags `-abgnpt`)")).build();
    private final NoArgCommandFlag killArmorStandsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Also destroy armor stands")).build();
    private final CommandArgument shapePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"shape"), (Component)TextComponent.of((String)"The shape of the region")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(regionFactory_Key)).build();
    private final CommandArgument radiusPart7 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to apply")).defaultsTo(ImmutableList.of("y-=0.2")).ofTypes(ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag usePlacementPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement position as the origin")).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the brush")).defaultsTo(ImmutableList.of("20")).ofTypes(ImmutableList.of(double_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to use")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(treeType_Key)).build();

    private BrushCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static BrushCommandsRegistration builder() {
        return new BrushCommandsRegistration();
    }

    public BrushCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public BrushCommandsRegistration containerInstance(BrushCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public BrushCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public BrushCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("sphere", b -> {
            b.aliases(ImmutableList.of("s"));
            b.description((Component)TextComponent.of((String)"Choose the sphere brush"));
            b.parts(ImmutableList.of(this.patternPart, this.radiusPart, this.hollowPart));
            b.action(this::sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cylinder", b -> {
            b.aliases(ImmutableList.of("cyl", "c"));
            b.description((Component)TextComponent.of((String)"Choose the cylinder brush"));
            b.parts(ImmutableList.of(this.patternPart, this.radiusPart2, this.heightPart, this.hollowPart2));
            b.action(this::cylinder);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clipboard", b -> {
            b.aliases(ImmutableList.of("copy"));
            b.description((Component)TextComponent.of((String)"Choose the clipboard brush"));
            b.parts(ImmutableList.of(this.ignoreAirPart, this.usingOriginPart, this.pasteEntitiesPart, this.pasteBiomesPart, this.sourceMaskPart));
            b.action(this::clipboard);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("smooth", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Choose the terrain softener brush"));
            b.footer((Component)TextComponent.of((String)"Example: '/brush smooth 2 4 grass_block,dirt,stone'"));
            b.parts(ImmutableList.of(this.radiusPart3, this.iterationsPart, this.maskPart));
            b.action(this::smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("extinguish", b -> {
            b.aliases(ImmutableList.of("ex"));
            b.description((Component)TextComponent.of((String)"Shortcut fire extinguisher brush"));
            b.parts(ImmutableList.of(this.radiusPart4));
            b.action(this::extinguish);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gravity", b -> {
            b.aliases(ImmutableList.of("grav"));
            b.description((Component)TextComponent.of((String)"Gravity brush, simulates the effect of gravity"));
            b.parts(ImmutableList.of(this.radiusPart5, this.fromMaxYPart));
            b.action(this::gravity);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("butcher", b -> {
            b.aliases(ImmutableList.of("kill"));
            b.description((Component)TextComponent.of((String)"Butcher brush, kills mobs within a radius"));
            b.parts(ImmutableList.of(this.radiusPart6, this.killPetsPart, this.killNpcsPart, this.killGolemsPart, this.killAnimalsPart, this.killAmbientPart, this.killWithNamePart, this.killFriendlyPart, this.killArmorStandsPart));
            b.action(this::butcher);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deform", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deform brush, applies an expression to an area"));
            b.parts(ImmutableList.of(this.shapePart, this.radiusPart7, this.expressionPart, this.useRawCoordsPart, this.usePlacementPart));
            b.action(this::deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("set", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set brush, sets all blocks in the area"));
            b.parts(ImmutableList.of(this.shapePart, this.radiusPart7, this.patternPart));
            b.action(this::set);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forest", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Forest brush, creates a forest in the area"));
            b.parts(ImmutableList.of(this.shapePart, this.radiusPart7, this.densityPart, this.typePart));
            b.action(this::forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("raise", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Raise brush, raise all blocks by one"));
            b.parts(ImmutableList.of(this.shapePart, this.radiusPart7));
            b.action(this::raise);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lower", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lower brush, lower all blocks by one"));
            b.parts(ImmutableList.of(this.shapePart, this.radiusPart7));
            b.action(this::lower);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.sphereBrush(this.player(parameters), this.session(parameters), this.pattern(parameters), this.radius(parameters), this.hollow(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cylinder(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cylinderBrush(this.player(parameters), this.session(parameters), this.pattern(parameters), this.radius2(parameters), this.height(parameters), this.hollow2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int clipboard(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clipboardBrush(this.player(parameters), this.session(parameters), this.ignoreAir(parameters), this.usingOrigin(parameters), this.pasteEntities(parameters), this.pasteBiomes(parameters), this.sourceMask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.smoothBrush(this.player(parameters), this.session(parameters), this.radius3(parameters), this.iterations(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int extinguish(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.extinguishBrush(this.player(parameters), this.session(parameters), this.radius4(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int gravity(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.gravityBrush(this.player(parameters), this.session(parameters), this.radius5(parameters), this.fromMaxY(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int butcher(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.butcherBrush(this.player(parameters), this.session(parameters), this.radius6(parameters), this.killPets(parameters), this.killNpcs(parameters), this.killGolems(parameters), this.killAnimals(parameters), this.killAmbient(parameters), this.killWithName(parameters), this.killFriendly(parameters), this.killArmorStands(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deform(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.expression(parameters), this.useRawCoords(parameters), this.usePlacement(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int set(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.set(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.forest(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.density(parameters), this.type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int raise(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.raise(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int lower(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.lower(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private int height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Mask sourceMask(CommandParameters parameters) {
        return (Mask)this.sourceMaskPart.value(parameters).asSingle(mask_clipboardMask_Key);
    }

    private RegionFactory shape(CommandParameters parameters) {
        return (RegionFactory)this.shapePart.value(parameters).asSingle(regionFactory_Key);
    }

    private double density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private boolean killAnimals(CommandParameters parameters) {
        return this.killAnimalsPart.in(parameters);
    }

    private boolean killNpcs(CommandParameters parameters) {
        return this.killNpcsPart.in(parameters);
    }

    private double radius4(CommandParameters parameters) {
        return (Double)this.radiusPart4.value(parameters).asSingle(double_Key);
    }

    private boolean usingOrigin(CommandParameters parameters) {
        return this.usingOriginPart.in(parameters);
    }

    private boolean killFriendly(CommandParameters parameters) {
        return this.killFriendlyPart.in(parameters);
    }

    private boolean fromMaxY(CommandParameters parameters) {
        return this.fromMaxYPart.in(parameters);
    }

    private boolean pasteEntities(CommandParameters parameters) {
        return this.pasteEntitiesPart.in(parameters);
    }

    private double radius5(CommandParameters parameters) {
        return (Double)this.radiusPart5.value(parameters).asSingle(double_Key);
    }

    private double radius3(CommandParameters parameters) {
        return (Double)this.radiusPart3.value(parameters).asSingle(double_Key);
    }

    private double radius2(CommandParameters parameters) {
        return (Double)this.radiusPart2.value(parameters).asSingle(double_Key);
    }

    private boolean pasteBiomes(CommandParameters parameters) {
        return this.pasteBiomesPart.in(parameters);
    }

    private int iterations(CommandParameters parameters) {
        return (Integer)this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private double radius6(CommandParameters parameters) {
        return (Double)this.radiusPart6.value(parameters).asSingle(double_Key);
    }

    private boolean killArmorStands(CommandParameters parameters) {
        return this.killArmorStandsPart.in(parameters);
    }

    private String expression(CommandParameters parameters) {
        return (String)this.expressionPart.value(parameters).asSingle(string_Key);
    }

    private double radius7(CommandParameters parameters) {
        return (Double)this.radiusPart7.value(parameters).asSingle(double_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private boolean hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private boolean killPets(CommandParameters parameters) {
        return this.killPetsPart.in(parameters);
    }

    private boolean hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private double radius(CommandParameters parameters) {
        return (Double)this.radiusPart.value(parameters).asSingle(double_Key);
    }

    private boolean killWithName(CommandParameters parameters) {
        return this.killWithNamePart.in(parameters);
    }

    private boolean useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean ignoreAir(CommandParameters parameters) {
        return this.ignoreAirPart.in(parameters);
    }

    private boolean killGolems(CommandParameters parameters) {
        return this.killGolemsPart.in(parameters);
    }

    private boolean killAmbient(CommandParameters parameters) {
        return this.killAmbientPart.in(parameters);
    }

    private boolean usePlacement(CommandParameters parameters) {
        return this.usePlacementPart.in(parameters);
    }

    private Mask mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private LocalSession localSession(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"localSession", (Optional)parameters.injectedValue(localSession_Key));
    }
}

