/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.BiomeCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class BiomeCommandsRegistration
implements CommandRegistration<BiomeCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<BiomeType> biomeType_Key = Key.of(BiomeType.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private CommandManager commandManager;
    private BiomeCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page number.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo(ImmutableList.of("1")).ofTypes(ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag useLineOfSightPart = CommandParts.flag((char)'t', (Component)TextComponent.of((String)"Use the block you are looking at.")).build();
    private final NoArgCommandFlag usePositionPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Use the block you are currently in.")).build();
    private final CommandArgument targetPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"target"), (Component)TextComponent.of((String)"Biome type.")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(biomeType_Key)).build();
    private final NoArgCommandFlag atPositionPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Use your current position")).build();

    private BiomeCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static BiomeCommandsRegistration builder() {
        return new BiomeCommandsRegistration();
    }

    public BiomeCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public BiomeCommandsRegistration containerInstance(BiomeCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public BiomeCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public BiomeCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("biomelist", b -> {
            b.aliases(ImmutableList.of("biomels"));
            b.description((Component)TextComponent.of((String)"Gets all biomes available."));
            b.parts(ImmutableList.of(this.pagePart));
            b.action(this::biomelist);
            Method commandMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"biomeList", (Class[])new Class[]{Actor.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("biomeinfo", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Get the biome of the targeted block."));
            b.footer((Component)TextComponent.of((String)"By default, uses all blocks in your selection."));
            b.parts(ImmutableList.of(this.useLineOfSightPart, this.usePositionPart));
            b.action(this::biomeinfo);
            Method commandMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"biomeInfo", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/setbiome", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Sets the biome of your current block or region."));
            b.footer((Component)TextComponent.of((String)"By default, uses all the blocks in your selection"));
            b.parts(ImmutableList.of(this.targetPart, this.atPositionPart));
            b.action(this::_setbiome);
            Method commandMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"setBiome", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, BiomeType.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int biomelist(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"biomeList", (Class[])new Class[]{Actor.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.biomeList(this.actor(parameters), this.page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int biomeinfo(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"biomeInfo", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.biomeInfo(this.player(parameters), this.session(parameters), this.useLineOfSight(parameters), this.usePosition(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int _setbiome(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BiomeCommands.class, (String)"setBiome", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, BiomeType.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.setBiome(this.player(parameters), this.session(parameters), this.editSession(parameters), this.target(parameters), this.atPosition(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private boolean useLineOfSight(CommandParameters parameters) {
        return this.useLineOfSightPart.in(parameters);
    }

    private LocalSession session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean usePosition(CommandParameters parameters) {
        return this.usePositionPart.in(parameters);
    }

    private BiomeType target(CommandParameters parameters) {
        return (BiomeType)this.targetPart.value(parameters).asSingle(biomeType_Key);
    }

    private boolean atPosition(CommandParameters parameters) {
        return this.atPositionPart.in(parameters);
    }

    private EditSession editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private Actor actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private int page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }
}

