/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.FlatRegionMaskingFilter;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeData;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.enginehub.piston.annotation.Command;

public class BiomeCommands {
    @Command(name="biomelist", aliases={"biomels"}, desc="Gets all biomes available.")
    @CommandPermissions(value={"worldedit.biome.list"})
    public void biomeList(Actor actor, int page) {
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, () -> {
            BiomeRegistry biomeRegistry = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
            PaginationBox paginationBox = PaginationBox.fromStrings("Available Biomes", "/biomelist -p %page%", BiomeType.REGISTRY.values().stream().map(biomeType -> {
                String id = biomeType.getId();
                BiomeData data = biomeRegistry.getData((BiomeType)biomeType);
                if (data != null) {
                    String name = data.getName();
                    return id + " (" + name + ")";
                }
                return id;
            }).collect(Collectors.toList()));
            return paginationBox.create(page);
        }, null);
    }

    @Command(name="biomeinfo", desc="Get the biome of the targeted block.", descFooter="By default, uses all blocks in your selection.")
    @CommandPermissions(value={"worldedit.biome.info"})
    public void biomeInfo(Player player, LocalSession session, boolean useLineOfSight, boolean usePosition) throws WorldEditException {
        String qualifier;
        BiomeRegistry biomeRegistry = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
        HashSet<BiomeType> biomes = new HashSet<BiomeType>();
        if (useLineOfSight) {
            Location blockPosition = player.getBlockTrace(300);
            if (blockPosition == null) {
                player.printError("No block in sight!");
                return;
            }
            BiomeType biome = player.getWorld().getBiome(blockPosition.toVector().toBlockPoint().toBlockVector2());
            biomes.add(biome);
            qualifier = "at line of sight point";
        } else if (usePosition) {
            BiomeType biome = player.getWorld().getBiome(player.getLocation().toVector().toBlockPoint().toBlockVector2());
            biomes.add(biome);
            qualifier = "at your position";
        } else {
            World world = player.getWorld();
            Region region = session.getSelection(world);
            if (region instanceof FlatRegion) {
                for (BlockVector2 blockVector2 : ((FlatRegion)region).asFlatRegion()) {
                    biomes.add(world.getBiome(blockVector2));
                }
            } else {
                for (BlockVector3 blockVector3 : region) {
                    biomes.add(world.getBiome(blockVector3.toBlockVector2()));
                }
            }
            qualifier = "in your selection";
        }
        player.print(biomes.size() != 1 ? "Biomes " + qualifier + ":" : "Biome " + qualifier + ":");
        for (BiomeType biome : biomes) {
            BiomeData data = biomeRegistry.getData(biome);
            if (data != null) {
                player.print(" " + data.getName());
                continue;
            }
            player.print(" <unknown #" + biome.getId() + ">");
        }
    }

    @Command(name="/setbiome", desc="Sets the biome of your current block or region.", descFooter="By default, uses all the blocks in your selection")
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.biome.set"})
    public void setBiome(Player player, LocalSession session, EditSession editSession, BiomeType target, boolean atPosition) throws WorldEditException {
        Region region;
        Mask2D mask2d;
        World world = player.getWorld();
        Mask mask = editSession.getMask();
        Mask2D mask2D = mask2d = mask != null ? mask.toMask2D() : null;
        if (atPosition) {
            BlockVector3 pos = player.getLocation().toVector().toBlockPoint();
            region = new CuboidRegion(pos, pos);
        } else {
            region = session.getSelection(world);
        }
        FlatRegionFunction replace = new BiomeReplace((Extent)editSession, target);
        if (mask2d != null) {
            replace = new FlatRegionMaskingFilter(mask2d, replace);
        }
        FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion(region), replace);
        Operations.completeLegacy(visitor);
        player.print("Biomes were changed in " + visitor.getAffected() + " columns. You may have to rejoin your game (or close and reopen your world) to see a change.");
    }
}

