/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.ApplyBrushCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ApplyBrushCommandsRegistration
implements CommandRegistration<ApplyBrushCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<BaseItem> baseItem_Key = Key.of(BaseItem.class);
    private static final Key<com.sk89q.worldedit.util.Direction> direction_directionIncludeDiagonalstrue_Key = Key.of(com.sk89q.worldedit.util.Direction.class, (Annotation)new Object(){

        Annotation a(@Direction(includeDiagonals=true) Object ah) {
            return this.getClass().getDeclaredMethods()[0].getParameterAnnotations()[0][0];
        }
    }.a(null));
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ApplyBrushCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to plant")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(treeType_Key)).build();
    private final CommandArgument itemPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"item"), (Component)TextComponent.of((String)"The type of item to use")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(baseItem_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"The direction in which the item will be applied")).defaultsTo(ImmutableList.of("up")).ofTypes(ImmutableList.of(direction_directionIncludeDiagonalstrue_Key)).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to use")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(pattern_Key)).build();

    private ApplyBrushCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ApplyBrushCommandsRegistration builder() {
        return new ApplyBrushCommandsRegistration();
    }

    public ApplyBrushCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ApplyBrushCommandsRegistration containerInstance(ApplyBrushCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ApplyBrushCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ApplyBrushCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("forest", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Plant trees"));
            b.parts(ImmutableList.of(this.typePart));
            b.action(this::forest);
        });
        this.commandManager.register("item", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Use an item"));
            b.parts(ImmutableList.of(this.itemPart, this.directionPart));
            b.action(this::item);
            Method commandMethod = RegistrationUtil.getCommandMethod(ApplyBrushCommands.class, (String)"item", (Class[])new Class[]{CommandParameters.class, Player.class, LocalSession.class, BaseItem.class, com.sk89q.worldedit.util.Direction.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("set", b -> {
            b.aliases(ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Place a block"));
            b.parts(ImmutableList.of(this.patternPart));
            b.action(this::set);
        });
    }

    private int forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ApplyBrushCommands.class, (String)"forest", (Class[])new Class[]{CommandParameters.class, Player.class, LocalSession.class, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.forest(this.parameters(parameters), this.player(parameters), this.localSession(parameters), this.type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int item(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ApplyBrushCommands.class, (String)"item", (Class[])new Class[]{CommandParameters.class, Player.class, LocalSession.class, BaseItem.class, com.sk89q.worldedit.util.Direction.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.item(this.parameters(parameters), this.player(parameters), this.localSession(parameters), this.item2(parameters), this.direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int set(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ApplyBrushCommands.class, (String)"set", (Class[])new Class[]{CommandParameters.class, Player.class, LocalSession.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.set(this.parameters(parameters), this.player(parameters), this.localSession(parameters), this.pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private CommandParameters parameters(CommandParameters parameters) {
        return parameters;
    }

    private Player player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private com.sk89q.worldedit.util.Direction direction(CommandParameters parameters) {
        return (com.sk89q.worldedit.util.Direction)((Object)this.directionPart.value(parameters).asSingle(direction_directionIncludeDiagonalstrue_Key));
    }

    private LocalSession localSession(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"localSession", (Optional)parameters.injectedValue(localSession_Key));
    }

    private BaseItem item2(CommandParameters parameters) {
        return (BaseItem)this.itemPart.value(parameters).asSingle(baseItem_Key);
    }
}

