/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.ApplyBrushCommandsRegistration;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.factory.ItemUseFactory;
import com.sk89q.worldedit.command.factory.ReplaceFactory;
import com.sk89q.worldedit.command.factory.TreeGeneratorFactory;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.Contextual;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.factory.Apply;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.SubCommandPart;

public class ApplyBrushCommands {
    private static final CommandArgument REGION_FACTORY = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"shape"), (Component)TextComponent.of((String)"The shape of the region")).defaultsTo(ImmutableList.of()).ofTypes(ImmutableList.of(Key.of(RegionFactory.class))).build();
    private static final CommandArgument RADIUS = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo(ImmutableList.of("5")).ofTypes(ImmutableList.of(Key.of(Double.TYPE))).build();

    public static void register(CommandManagerService service, CommandManager commandManager, CommandRegistrationHandler registration) {
        commandManager.register("apply", builder -> {
            builder.description((Component)TextComponent.of((String)"Apply brush, apply a function to every block"));
            builder.action(Command.Action.NULL_ACTION);
            CommandManager manager = service.newCommandManager();
            registration.register(manager, ApplyBrushCommandsRegistration.builder(), new ApplyBrushCommands());
            builder.condition((Command.Condition)new PermissionCondition(ImmutableSet.of("worldedit.brush.apply")));
            builder.addParts(new CommandPart[]{REGION_FACTORY, RADIUS});
            builder.addPart((CommandPart)SubCommandPart.builder((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"Type of brush to use")).withCommands((Collection)manager.getAllCommands().collect(Collectors.toList())).required().build());
        });
    }

    private void setApplyBrush(CommandParameters parameters, Player player, LocalSession localSession, Contextual<? extends RegionFunction> generatorFactory) throws WorldEditException {
        double radius = (Double)Objects.requireNonNull(RADIUS.value(parameters).asSingle(Double.TYPE));
        RegionFactory regionFactory = (RegionFactory)REGION_FACTORY.value(parameters).asSingle(RegionFactory.class);
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Apply(generatorFactory), regionFactory, "worldedit.brush.apply");
    }

    @Command(name="forest", desc="Plant trees")
    public void forest(CommandParameters parameters, Player player, LocalSession localSession, TreeGenerator.TreeType type) throws WorldEditException {
        this.setApplyBrush(parameters, player, localSession, new TreeGeneratorFactory(type));
    }

    @Command(name="item", desc="Use an item")
    @CommandPermissions(value={"worldedit.brush.item"})
    public void item(CommandParameters parameters, Player player, LocalSession localSession, BaseItem item, @Direction(includeDiagonals=true) com.sk89q.worldedit.util.Direction direction) throws WorldEditException {
        player.print((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append("WARNING: ", TextColor.RED, new TextDecoration[]{TextDecoration.BOLD})).append("This brush simulates item usages. Its effects may not work on all platforms, may not be undo-able, and may cause strange interactions with other mods/plugins. Use at your own risk.")).build());
        this.setApplyBrush(parameters, player, localSession, new ItemUseFactory(item, direction));
    }

    @Command(name="set", desc="Place a block")
    public void set(CommandParameters parameters, Player player, LocalSession localSession, Pattern pattern) throws WorldEditException {
        this.setApplyBrush(parameters, player, localSession, new ReplaceFactory(pattern));
    }
}

