/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldEditPlugin
extends JavaPlugin
implements TabCompleter {
    private static final Logger log = LoggerFactory.getLogger(WorldEditPlugin.class);
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private BukkitImplAdapter bukkitAdapter;
    private BukkitServerInterface server;
    private BukkitConfiguration config;

    @Override
    public void onLoad() {
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.server = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register(this.server);
        Path delChunks = Paths.get(this.getDataFolder().getPath(), "delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile(delChunks, true);
        }
    }

    @Override
    public void onEnable() {
        PermissionsResolverManager.initialize(this);
        this.getServer().getMessenger().registerIncomingPluginChannel(this, CUI_PLUGIN_CHANNEL, new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel(this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents(new WorldEditListener(this), this);
        if (PaperLib.isPaper()) {
            this.getServer().getPluginManager().registerEvents(new AsyncTabCompleteListener(), this);
        }
        this.initializeRegistries();
        if (Bukkit.getWorlds().isEmpty()) {
            this.setupPreWorldData();
            this.getServer().getPluginManager().registerEvents(new WorldInitListener(), this);
        } else {
            this.getLogger().warning("Server reload detected. This may cause various issues with WorldEdit and dependent plugins.");
            try {
                this.setupPreWorldData();
                this.setupWorldData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        new Metrics((Plugin)this);
        PaperLib.suggestPaper((Plugin)this);
    }

    private void setupPreWorldData() {
        this.loadAdapter();
        this.loadConfig();
        WorldEdit.getInstance().loadMappings();
    }

    private void setupWorldData() {
        this.setupTags();
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent());
    }

    private void initializeRegistries() {
        for (Biome biome : Biome.values()) {
            String lowerCaseBiomeName = biome.name().toLowerCase(Locale.ROOT);
            BiomeType.REGISTRY.register("minecraft:" + lowerCaseBiomeName, new BiomeType("minecraft:" + lowerCaseBiomeName));
        }
        for (Enum enum_ : Material.values()) {
            if (((Material)enum_).isBlock() && !((Material)enum_).isLegacy()) {
                BlockType.REGISTRY.register(((Material)enum_).getKey().toString(), new BlockType(((Material)enum_).getKey().toString(), arg_0 -> this.lambda$initializeRegistries$0((Material)enum_, arg_0)));
            }
            if (!((Material)enum_).isItem() || ((Material)enum_).isLegacy()) continue;
            ItemType.REGISTRY.register(((Material)enum_).getKey().toString(), new ItemType(((Material)enum_).getKey().toString()));
        }
        for (Enum enum_ : EntityType.values()) {
            String mcid = ((EntityType)enum_).getName();
            if (mcid == null) continue;
            String lowerCaseMcId = mcid.toLowerCase(Locale.ROOT);
            com.sk89q.worldedit.world.entity.EntityType.REGISTRY.register("minecraft:" + lowerCaseMcId, new com.sk89q.worldedit.world.entity.EntityType("minecraft:" + lowerCaseMcId));
        }
        GameModes.get("");
        WeatherTypes.get("");
    }

    private void setupTags() {
        try {
            for (Tag<Material> blockTag : Bukkit.getTags("blocks", Material.class)) {
                BlockCategory.REGISTRY.register(blockTag.getKey().toString(), new BlockCategory(blockTag.getKey().toString()));
            }
            for (Tag<Material> itemTag : Bukkit.getTags("items", Material.class)) {
                ItemCategory.REGISTRY.register(itemTag.getKey().toString(), new ItemCategory(itemTag.getKey().toString()));
            }
        }
        catch (NoSuchMethodError ignored) {
            this.getLogger().warning("The version of Spigot/Paper you are using doesn't support Tags. The usage of tags with WorldEdit will not work until you update.");
        }
    }

    private void loadConfig() {
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        this.config.load();
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(this.getClass().getClassLoader());
        }
        catch (IOException e) {
            log.warn("Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            log.warn("Failed to search " + this.getFile() + " for Bukkit adapters", e);
        }
        try {
            this.bukkitAdapter = adapterLoader.loadAdapter();
            log.info("Using " + this.bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                log.warn(e.getMessage());
            }
            log.info("WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
        }
    }

    @Override
    public void onDisable() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister(this.server);
        if (this.config != null) {
            this.config.unload();
        }
        if (this.server != null) {
            this.server.unregisterCommands();
        }
        this.getServer().getScheduler().cancelTasks(this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            try (JarFile file = new JarFile(this.getFile());){
                ZipEntry copy = file.getEntry("defaults/" + name);
                if (copy == null) {
                    throw new FileNotFoundException();
                }
                this.copyDefaultConfig(file.getInputStream(copy), actual, name);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
        }
    }

    private void copyDefaultConfig(InputStream input, File actual, String name) {
        try (FileOutputStream output = new FileOutputStream(actual);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = input.read(buf)) > 0) {
                output.write(buf, 0, length);
            }
            this.getLogger().info("Default configuration file written: " + name);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + commandLabel;
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on(" ").join(split));
        this.getWorldEdit().getEventBus().post(event);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + commandLabel;
        String arguments = Joiner.on(" ").join(split);
        CommandSuggestionEvent event = new CommandSuggestionEvent(this.wrapCommandSender(sender), arguments);
        this.getWorldEdit().getEventBus().post(event);
        return CommandUtil.fixSuggestions(arguments, event.getSuggestions());
    }

    public LocalSession getSession(Player player) {
        return WorldEdit.getInstance().getSessionManager().get(this.wrapPlayer(player));
    }

    public EditSession createEditSession(Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        BlockBag blockBag = session.getBlockBag(wePlayer);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(wePlayer.getWorld(), session.getBlockChangeLimit(), blockBag, wePlayer);
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        session.remember(editSession);
        editSession.flushSession();
        WorldEdit.getInstance().flushBlockBag(wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    BukkitServerInterface getInternalPlatform() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    static WorldEditPlugin getInstance() {
        return Preconditions.checkNotNull(INSTANCE);
    }

    @Nullable
    BukkitImplAdapter getBukkitImplAdapter() {
        return this.bukkitAdapter;
    }

    private /* synthetic */ BlockState lambda$initializeRegistries$0(Material material, BlockState blockState) {
        ParserContext context = new ParserContext();
        context.setPreferringWildcard(true);
        context.setTryLegacy(false);
        context.setRestricted(false);
        try {
            FuzzyBlockState state = (FuzzyBlockState)((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(BukkitAdapter.adapt(blockState.getBlockType()).createBlockData().getAsString(), context)).toImmutableState();
            BlockStateHolder<BlockState> defaultState = blockState.getBlockType().getAllStates().get(0);
            for (Map.Entry<Property<?>, Object> propertyObjectEntry : state.getStates().entrySet()) {
                defaultState = defaultState.with(propertyObjectEntry.getKey(), propertyObjectEntry.getValue());
            }
            return defaultState;
        }
        catch (InputParseException e) {
            this.getLogger().log(Level.WARNING, "Error loading block state for " + material.getKey(), e);
            return blockState;
        }
    }

    private class AsyncTabCompleteListener
    implements Listener {
        AsyncTabCompleteListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
            if (!event.isCommand()) {
                return;
            }
            String buffer = event.getBuffer();
            int firstSpace = buffer.indexOf(32);
            if (firstSpace < 0) {
                return;
            }
            String label = buffer.substring(0, firstSpace);
            Optional command = WorldEdit.getInstance().getPlatformManager().getPlatformCommandManager().getCommandManager().getCommand(label);
            if (!command.isPresent()) {
                return;
            }
            CommandSuggestionEvent suggestEvent = new CommandSuggestionEvent(WorldEditPlugin.this.wrapCommandSender(event.getSender()), event.getBuffer());
            WorldEditPlugin.this.getWorldEdit().getEventBus().post(suggestEvent);
            event.setCompletions(CommandUtil.fixSuggestions(event.getBuffer(), suggestEvent.getSuggestions()));
            event.setHandled(true);
        }
    }

    private class WorldInitListener
    implements Listener {
        private boolean loaded = false;

        private WorldInitListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onWorldInit(WorldInitEvent event) {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            WorldEditPlugin.this.setupWorldData();
        }
    }
}

