/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.MockBukkit;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TeamMock
implements Team {
    private final String name;
    private String displayName;
    private String prefix;
    private String suffic;
    private ChatColor color;
    private boolean allowFriendlyFire = false;
    private final HashSet<String> entries;
    private boolean canSeeFriendly = true;
    private EnumMap<Team.Option, Team.OptionStatus> options = new EnumMap(Team.Option.class);
    private boolean registered;
    private Scoreboard board;

    public TeamMock(String name, Scoreboard board) {
        this.name = name;
        this.board = board;
        this.registered = true;
        this.entries = new HashSet();
        this.options.put(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
    }

    @Override
    public String getName() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.name;
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.displayName;
    }

    @Override
    public void setDisplayName(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.displayName = s;
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.prefix;
    }

    @Override
    public void setPrefix(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.prefix = s;
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.suffic;
    }

    @Override
    public void setSuffix(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.suffic = s;
    }

    @Override
    public ChatColor getColor() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.color;
    }

    @Override
    public void setColor(ChatColor chatColor) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.color = chatColor;
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.allowFriendlyFire;
    }

    @Override
    public void setAllowFriendlyFire(boolean b) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.allowFriendlyFire = b;
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.canSeeFriendly;
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean b) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.canSeeFriendly = b;
    }

    @Override
    @Deprecated
    public NameTagVisibility getNameTagVisibility() {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        Team.OptionStatus s = this.options.get((Object)Team.Option.NAME_TAG_VISIBILITY);
        switch (s) {
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Option not compatible");
    }

    @Override
    @Deprecated
    public void setNameTagVisibility(NameTagVisibility nameTagVisibility) {
        MockBukkit.getMock().getLogger().log(Level.WARNING, "Consider USE setOption() DEPRECATED");
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        switch (nameTagVisibility) {
            case ALWAYS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
                return;
            }
            case NEVER: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                return;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
                return;
            }
            case HIDE_FOR_OWN_TEAM: {
                this.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OWN_TEAM);
                return;
            }
        }
        throw new IllegalArgumentException("Option not compatible");
    }

    @Override
    @Deprecated
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String s : this.entries) {
            OfflinePlayer player;
            if (s == null || (player = MockBukkit.getMock().getOfflinePlayer(s)) == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public Set<String> getEntries() throws IllegalStateException {
        return this.entries;
    }

    @Override
    public int getSize() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.size();
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.board;
    }

    @Override
    public void addPlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.entries.add(offlinePlayer.getName());
    }

    @Override
    public void addEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.entries.add(s);
    }

    @Override
    @Deprecated
    public boolean removePlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.remove(offlinePlayer.getName());
    }

    @Override
    public boolean removeEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.remove(s);
    }

    @Override
    public void unregister() throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.registered = false;
    }

    @Override
    @Deprecated
    public boolean hasPlayer(OfflinePlayer offlinePlayer) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.contains(offlinePlayer.getName());
    }

    @Override
    public boolean hasEntry(String s) {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.entries.contains(s);
    }

    @Override
    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        return this.options.get((Object)option);
    }

    @Override
    public void setOption(Team.Option option, Team.OptionStatus optionStatus) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("Team not registered");
        }
        this.options.put(option, optionStatus);
    }
}

