/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.scoreboard;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.scoreboard.ScoreMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardMock;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;

public class ObjectiveMock
implements Objective {
    private final ScoreboardMock scoreboard;
    private final String name;
    private final String criteria;
    private final Map<String, ScoreMock> scores = new HashMap<String, ScoreMock>();
    private String displayName;
    private DisplaySlot displaySlot;
    private RenderType renderType;

    public ObjectiveMock(ScoreboardMock scoreboard, String name, String criteria) {
        this.scoreboard = scoreboard;
        this.name = name;
        this.displayName = name;
        this.criteria = criteria;
    }

    @Override
    public String getName() throws IllegalStateException {
        return this.name;
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        this.displayName = displayName;
    }

    @Override
    public String getCriteria() throws IllegalStateException {
        return this.criteria;
    }

    @Override
    public boolean isModifiable() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    @Override
    public ScoreboardMock getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public void unregister() throws IllegalStateException {
        this.scoreboard.unregister(this);
    }

    public boolean isRegistered() {
        return this.scoreboard.getObjectives().contains(this);
    }

    @Override
    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        this.displaySlot = slot;
        this.scoreboard.setDisplaySlot(this, slot);
    }

    @Override
    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        return this.displaySlot;
    }

    @Override
    public ScoreMock getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        return this.getScore(player.getName());
    }

    @Override
    public ScoreMock getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        if (this.scores.containsKey(entry)) {
            return this.scores.get(entry);
        }
        ScoreMock score = new ScoreMock(this, entry);
        this.scores.put(entry, score);
        return score;
    }

    @Override
    public void setRenderType(RenderType renderType) throws IllegalStateException {
        this.renderType = renderType;
    }

    @Override
    public RenderType getRenderType() throws IllegalStateException {
        return this.renderType;
    }
}

