/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.plugin;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.plugin.ListenerEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginCommandUtils;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.java.JavaPluginUtils;
import org.junit.Assert;

public class PluginManagerMock
implements PluginManager {
    private final ServerMock server;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final JavaPluginLoader loader;
    private final List<PluginCommand> commands = new ArrayList<PluginCommand>();
    private final Map<Plugin, List<ListenerEntry>> eventListeners = new HashMap<Plugin, List<ListenerEntry>>();
    private final List<Event> events = new ArrayList<Event>();
    private final List<File> temporaryFiles = new LinkedList<File>();
    private final List<Class<?>> pluginConstructorTypes = Arrays.asList(JavaPluginLoader.class, PluginDescriptionFile.class, File.class, File.class);
    private final List<Permission> permissions = new ArrayList<Permission>();
    private final Map<Permissible, Set<String>> permissionSubscriptions = new HashMap<Permissible, Set<String>>();

    public PluginManagerMock(ServerMock server) {
        this.server = server;
        this.loader = new JavaPluginLoader(this.server);
    }

    public void unload() {
        for (File file : this.temporaryFiles) {
            try {
                FileUtils.deleteDirectory(file);
            }
            catch (IOException e) {
                System.err.println("Could not remove file");
                e.printStackTrace();
            }
        }
    }

    public void assertEventFired(String message, Predicate<Event> predicate) {
        for (Event event : this.events) {
            if (!predicate.test(event)) continue;
            return;
        }
        Assert.fail(message);
    }

    public void assertEventFired(Predicate<Event> predicate) {
        this.assertEventFired("Event assert failed", predicate);
    }

    public <T extends Event> void assertEventFired(String message, Class<T> eventClass, Predicate<T> predicate) {
        for (Event event : this.events) {
            if (!eventClass.isInstance(event) || !predicate.test(event)) continue;
            return;
        }
        Assert.fail(message);
    }

    public <T extends Event> void assertEventFired(Class<T> eventClass, Predicate<T> predicate) {
        this.assertEventFired("No event of the correct class tested true", eventClass, predicate);
    }

    public void assertEventFired(Class<? extends Event> eventClass) {
        this.assertEventFired("No event of that type has been fired", (Event event) -> eventClass.isInstance(event));
    }

    @Override
    public Plugin getPlugin(String name) {
        for (Plugin plugin : this.plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[this.plugins.size()]);
    }

    public Collection<PluginCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    private boolean isConstructorCompatible(Constructor<?> constructor, Class<?>[] types) {
        Class<?>[] parameters = constructor.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Class<?> parameter = parameters[i];
            if (!(i < 4 ? !type.equals(parameter) : !parameter.isAssignableFrom(type))) continue;
            return false;
        }
        return true;
    }

    private Constructor<? extends JavaPlugin> getCompatibleConstructor(Class<? extends JavaPlugin> class1, Class<?>[] types) throws NoSuchMethodException {
        for (Constructor<?> constructor : class1.getDeclaredConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length != types.length || !this.isConstructorCompatible(constructor, types)) continue;
            return constructor;
        }
        StringBuilder parameters = new StringBuilder("[");
        for (Class<?> type : types) {
            parameters.append(type.getName()).append(", ");
        }
        String str = parameters.substring(0, parameters.length() - 2) + "]";
        throw new NoSuchMethodException("No compatible constructor for " + class1.getName() + " with parameters " + str);
    }

    private File createTemporaryDirectory(String name) throws IOException {
        Random random = new Random();
        File directory = File.createTempFile(name + "-" + random.nextInt(), ".d");
        if (!directory.delete()) {
            throw new IOException("Could not create temporary directory: file could not be removed");
        }
        if (!directory.mkdir()) {
            throw new IOException("Could not create temporary directory: directory could not be created");
        }
        this.temporaryFiles.add(directory);
        return directory;
    }

    public void registerLoadedPlugin(Plugin plugin) {
        this.addCommandsFrom(plugin);
        this.plugins.add(plugin);
        plugin.onLoad();
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, PluginDescriptionFile description, Object[] parameters) {
        try {
            ArrayList types = new ArrayList(this.pluginConstructorTypes);
            for (Object parameter : parameters) {
                types.add(parameter.getClass());
            }
            Constructor<? extends JavaPlugin> constructor = this.getCompatibleConstructor(class1, types.toArray(new Class[0]));
            constructor.setAccessible(true);
            Object[] arguments = new Object[types.size()];
            arguments[0] = this.loader;
            arguments[1] = description;
            arguments[2] = this.createTemporaryDirectory("MockBukkit-" + description.getName() + "-" + description.getVersion());
            System.arraycopy(parameters, 0, arguments, 4, parameters.length);
            JavaPlugin plugin = constructor.newInstance(arguments);
            this.registerLoadedPlugin(plugin);
            return plugin;
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate plugin", e);
        }
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, PluginDescriptionFile description) {
        return this.loadPlugin(class1, description, new Object[0]);
    }

    public JavaPlugin loadPlugin(Class<? extends JavaPlugin> class1, Object[] parameters) {
        try {
            PluginDescriptionFile description = this.findPluginDescription(class1);
            return this.loadPlugin(class1, description, parameters);
        }
        catch (IOException | InvalidDescriptionException e) {
            throw new RuntimeException(e);
        }
    }

    private PluginDescriptionFile findPluginDescription(Class<? extends JavaPlugin> class1) throws IOException, InvalidDescriptionException {
        Enumeration<URL> resources = class1.getClassLoader().getResources("plugin.yml");
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            PluginDescriptionFile description = new PluginDescriptionFile(url.openStream());
            String mainClass = description.getMain();
            if (!class1.getName().equals(mainClass)) continue;
            return description;
        }
        throw new FileNotFoundException(String.format("Could not find file plugin.yml. Maybe forgot to add the 'main' property?", new Object[0]));
    }

    @Override
    public void callEvent(Event event) throws IllegalStateException {
        this.events.add(event);
        for (List<ListenerEntry> listeners : this.eventListeners.values()) {
            for (ListenerEntry entry : listeners) {
                if (!entry.isCompatibleFor(event)) continue;
                entry.invokeUnsafe(event);
            }
        }
    }

    @Override
    public void registerEvents(Listener listener, Plugin plugin) {
        if (!this.eventListeners.containsKey(plugin)) {
            this.eventListeners.put(plugin, new LinkedList());
        }
        List<ListenerEntry> listeners = this.eventListeners.get(plugin);
        for (Method method : listener.getClass().getMethods()) {
            EventHandler annotation = method.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            listeners.add(new ListenerEntry(plugin, listener, method));
        }
    }

    @Override
    public void enablePlugin(Plugin plugin) {
        if (plugin instanceof JavaPlugin) {
            if (!plugin.isEnabled()) {
                JavaPluginUtils.setEnabled((JavaPlugin)plugin, true);
                this.callEvent(new PluginEnableEvent(plugin));
            }
        } else {
            throw new IllegalArgumentException("Not a JavaPlugin");
        }
    }

    private void addSection(PluginCommand command, String name, Object value) {
        switch (name) {
            case "description": {
                command.setDescription((String)value);
                break;
            }
            case "aliases": {
                ArrayList aliases = new ArrayList();
                if (value instanceof List) {
                    command.setAliases(aliases.stream().map(object -> object.toString()).collect(Collectors.toList()));
                    break;
                }
                command.setAliases(Arrays.asList(value.toString()));
                break;
            }
            case "permission": {
                command.setPermission((String)value);
                break;
            }
            case "permission-message": {
                command.setPermissionMessage((String)value);
                break;
            }
            case "usage": {
                command.setUsage((String)value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown section " + value);
            }
        }
    }

    protected void addCommandsFrom(Plugin plugin) {
        Map<String, Map<String, Object>> commands = plugin.getDescription().getCommands();
        if (commands != null) {
            for (Map.Entry<String, Map<String, Object>> entry : commands.entrySet()) {
                PluginCommand command = PluginCommandUtils.createPluginCommand(entry.getKey(), plugin);
                for (Map.Entry<String, Object> section : entry.getValue().entrySet()) {
                    this.addSection(command, section.getKey(), section.getValue());
                }
                this.commands.add(command);
                this.server.getCommandMap().register(plugin.getName(), command);
            }
        }
    }

    @Override
    public void registerInterface(Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPluginEnabled(String name) {
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.getName().equals(name)) continue;
            result = mockedPlugin.isEnabled();
        }
        return result;
    }

    @Override
    public boolean isPluginEnabled(Plugin plugin) {
        boolean result = false;
        for (Plugin mockedPlugin : this.plugins) {
            if (!mockedPlugin.equals(plugin)) continue;
            result = plugin.isEnabled();
        }
        return result;
    }

    @Override
    public Plugin loadPlugin(File file) throws InvalidPluginException, InvalidDescriptionException, UnknownDependencyException {
        throw new UnimplementedOperationException();
    }

    @Override
    public Plugin[] loadPlugins(File directory) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void disablePlugins() {
        for (Plugin plugin : this.plugins) {
            this.disablePlugin(plugin);
        }
    }

    @Override
    public void clearPlugins() {
        this.disablePlugins();
        this.plugins.clear();
    }

    public void clearEvents() {
        this.events.clear();
    }

    @Override
    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void disablePlugin(Plugin plugin) {
        if (plugin instanceof JavaPlugin) {
            if (plugin.isEnabled()) {
                JavaPluginUtils.setEnabled((JavaPlugin)plugin, false);
                this.callEvent(new PluginDisableEvent(plugin));
            }
        } else {
            throw new IllegalArgumentException("Not a JavaPlugin");
        }
    }

    @Override
    public Permission getPermission(String name) {
        return this.permissions.stream().filter(permission -> permission.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public void addPermission(Permission perm) {
        this.permissions.add(perm);
    }

    @Override
    public void removePermission(Permission perm) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removePermission(String name) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<Permission> getDefaultPermissions(boolean op) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (Permission permission : this.permissions) {
            PermissionDefault permissionDefault = permission.getDefault();
            if (permissionDefault == PermissionDefault.TRUE) {
                permissions.add(permission);
                continue;
            }
            if (!op || permissionDefault != PermissionDefault.OP) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    @Override
    public void recalculatePermissionDefaults(Permission perm) {
    }

    private Set<String> getPermissionSubscriptions(Permissible permissible) {
        if (this.permissionSubscriptions.containsKey(permissible)) {
            return this.permissionSubscriptions.get(permissible);
        }
        HashSet<String> subscriptions = new HashSet<String>();
        this.permissionSubscriptions.put(permissible, subscriptions);
        return subscriptions;
    }

    @Override
    public void subscribeToPermission(String permission, Permissible permissible) {
        this.getPermissionSubscriptions(permissible).add(permission);
    }

    @Override
    public void unsubscribeFromPermission(String permission, Permissible permissible) {
        this.getPermissionSubscriptions(permissible).remove(permission);
    }

    @Override
    public Set<Permissible> getPermissionSubscriptions(String permission) {
        HashSet<Permissible> subscriptions = new HashSet<Permissible>();
        for (Map.Entry<Permissible, Set<String>> entry : this.permissionSubscriptions.entrySet()) {
            Permissible permissible = entry.getKey();
            Set<String> permissions = entry.getValue();
            if (!permissions.contains(permission)) continue;
            subscriptions.add(permissible);
        }
        return subscriptions;
    }

    @Override
    public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<Permission> getPermissions() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean useTimings() {
        throw new UnimplementedOperationException();
    }
}

