/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.persistence;

import be.seeseemelk.mockbukkit.persistence.PersistentDataAdapterContextMock;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentDataContainerMock
implements PersistentDataContainer {
    private final PersistentDataAdapterContext context = new PersistentDataAdapterContextMock();
    private final Map<NamespacedKey, Object> map;

    public PersistentDataContainerMock() {
        this.map = new HashMap<NamespacedKey, Object>();
    }

    public PersistentDataContainerMock(PersistentDataContainerMock mock) {
        this.map = new HashMap<NamespacedKey, Object>(mock.map);
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PersistentDataContainerMock)) {
            return false;
        }
        return this.map.equals(((PersistentDataContainerMock)obj).map);
    }

    @Override
    @Nullable
    public <T, Z> Z get(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Object value = this.map.get(key);
        if (value == null || !type.getPrimitiveType().isInstance(value)) {
            return null;
        }
        return type.fromPrimitive(type.getPrimitiveType().cast(value), this.context);
    }

    @Override
    public <T, Z> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        this.map.put(key, type.toPrimitive(value, this.context));
    }

    @Override
    public <T, Z> boolean has(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        Object value = this.map.get(key);
        return value != null && type.getPrimitiveType().isInstance(value);
    }

    @Override
    @NotNull
    public PersistentDataAdapterContext getAdapterContext() {
        return this.context;
    }

    @Override
    @NotNull
    public <T, Z> Z getOrDefault(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z defaultValue) {
        Z value = this.get(key, type);
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void remove(@NotNull NamespacedKey key) {
        this.map.remove(key);
    }
}

