/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeatherArmorMetaMock
extends ItemMetaMock
implements LeatherArmorMeta {
    private Color color;

    public LeatherArmorMetaMock() {
        this.color = Bukkit.getItemFactory().getDefaultLeatherColor();
    }

    public LeatherArmorMetaMock(LeatherArmorMeta meta) {
        super(meta);
        this.color = meta.getColor();
    }

    @Override
    public LeatherArmorMetaMock clone() {
        LeatherArmorMetaMock mock = (LeatherArmorMetaMock)super.clone();
        mock.setColor(this.color);
        return mock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.color.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LeatherArmorMeta)) {
            return false;
        }
        LeatherArmorMeta other = (LeatherArmorMeta)obj;
        return this.color.equals(other.getColor());
    }

    @Override
    @NotNull
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(@Nullable Color color) {
        this.color = color == null ? Bukkit.getItemFactory().getDefaultLeatherColor() : color;
    }
}

