/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.jetbrains.annotations.NotNull;

public class KnowledgeBookMetaMock
extends ItemMetaMock
implements KnowledgeBookMeta {
    private static final int MAX_RECIPES = Short.MAX_VALUE;
    private List<NamespacedKey> recipes = new ArrayList<NamespacedKey>();

    public KnowledgeBookMetaMock() {
    }

    public KnowledgeBookMetaMock(KnowledgeBookMeta meta) {
        super(meta);
        this.recipes = meta.getRecipes();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.recipes.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof KnowledgeBookMetaMock)) {
            return false;
        }
        KnowledgeBookMetaMock other = (KnowledgeBookMetaMock)obj;
        return this.recipes.equals(other.recipes);
    }

    @Override
    public KnowledgeBookMetaMock clone() {
        KnowledgeBookMetaMock mock = (KnowledgeBookMetaMock)super.clone();
        mock.recipes = new ArrayList<NamespacedKey>(this.recipes);
        return mock;
    }

    @Override
    public void addRecipe(NamespacedKey ... recipes) {
        for (NamespacedKey recipe : recipes) {
            if (this.recipes.size() >= Short.MAX_VALUE) {
                return;
            }
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
    }

    @Override
    @NotNull
    public List<NamespacedKey> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }

    @Override
    public boolean hasRecipes() {
        return !this.recipes.isEmpty();
    }

    @Override
    public void setRecipes(@NotNull List<NamespacedKey> recipes) {
        this.recipes.clear();
        this.addRecipe(recipes.toArray(new NamespacedKey[0]));
    }
}

