/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.jetbrains.annotations.NotNull;

public class EnchantedBookMetaMock
extends ItemMetaMock
implements EnchantmentStorageMeta {
    private Map<Enchantment, Integer> storedEnchantments = new HashMap<Enchantment, Integer>();

    public EnchantedBookMetaMock() {
    }

    public EnchantedBookMetaMock(EnchantmentStorageMeta meta) {
        super(meta);
        this.storedEnchantments = new HashMap<Enchantment, Integer>(meta.getStoredEnchants());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.storedEnchantments.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EnchantedBookMetaMock)) {
            return false;
        }
        EnchantedBookMetaMock other = (EnchantedBookMetaMock)obj;
        return this.storedEnchantments.equals(other.storedEnchantments);
    }

    @Override
    public EnchantedBookMetaMock clone() {
        EnchantedBookMetaMock mock = (EnchantedBookMetaMock)super.clone();
        mock.storedEnchantments = new HashMap<Enchantment, Integer>(this.storedEnchantments);
        return mock;
    }

    @Override
    public boolean addStoredEnchant(@NotNull Enchantment ench, int level, boolean ignoreLevelRestriction) {
        if (!ignoreLevelRestriction && level < ench.getStartLevel()) {
            return false;
        }
        if (!ignoreLevelRestriction && level > ench.getMaxLevel()) {
            return false;
        }
        Integer prev = this.storedEnchantments.put(ench, level);
        return prev == null || prev != level;
    }

    @Override
    public int getStoredEnchantLevel(@NotNull Enchantment ench) {
        return this.storedEnchantments.getOrDefault(ench, 0);
    }

    @Override
    @NotNull
    public Map<Enchantment, Integer> getStoredEnchants() {
        return ImmutableMap.copyOf(this.storedEnchantments);
    }

    @Override
    public boolean hasConflictingStoredEnchant(@NotNull Enchantment ench) {
        for (Enchantment enchantment : this.storedEnchantments.keySet()) {
            if (!enchantment.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStoredEnchant(@NotNull Enchantment ench) {
        return this.storedEnchantments.containsKey(ench);
    }

    @Override
    public boolean hasStoredEnchants() {
        return !this.storedEnchantments.isEmpty();
    }

    @Override
    public boolean removeStoredEnchant(@NotNull Enchantment ench) throws IllegalArgumentException {
        return this.storedEnchantments.remove(ench) != null;
    }
}

