/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory.meta;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.meta.BookMeta;

public class BookMetaMock
extends ItemMetaMock
implements BookMeta {
    private String title;
    private List<String> pages = new ArrayList<String>();
    private String author;

    public BookMetaMock() {
    }

    public BookMetaMock(BookMeta meta) {
        super(meta);
        this.title = meta.getTitle();
        this.author = meta.getAuthor();
        this.pages = new ArrayList<String>(meta.getPages());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.author, this.pages, this.title);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BookMetaMock)) {
            return false;
        }
        BookMetaMock other = (BookMetaMock)obj;
        return Objects.equals(this.author, other.author) && Objects.equals(this.pages, other.pages) && Objects.equals(this.title, other.title);
    }

    @Override
    public boolean hasTitle() {
        return !Strings.isNullOrEmpty(this.title);
    }

    @Override
    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 65535) {
            return false;
        }
        this.title = title;
        return true;
    }

    @Override
    public boolean hasAuthor() {
        return !Strings.isNullOrEmpty(this.author);
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getPage(int page) {
        Validate.isTrue(this.isValidPage(page), "Invalid page number");
        return this.pages.get(page - 1);
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.pages.size();
    }

    @Override
    public void setPage(int page, String text) {
        if (!this.isValidPage(page)) {
            throw new IllegalArgumentException("Invalid page number " + page + "/" + this.pages.size());
        }
        String newText = text != null ? (text.length() > Short.MAX_VALUE ? text.substring(0, Short.MAX_VALUE) : text) : "";
        this.pages.set(page - 1, newText);
    }

    @Override
    public List<String> getPages() {
        return this.pages;
    }

    @Override
    public void setPages(String ... pages) {
        this.pages.clear();
        this.addPage(pages);
    }

    @Override
    public void setPages(List<String> pages) {
        this.pages.clear();
        for (String page : pages) {
            this.addPage(page);
        }
    }

    @Override
    public void addPage(String ... pages) {
        for (String page1 : pages) {
            String page = page1;
            if (page == null) {
                page = "";
            } else if (page.length() > Short.MAX_VALUE) {
                page = page.substring(0, Short.MAX_VALUE);
            }
            this.pages.add(page);
        }
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public BookMetaMock clone() {
        BookMetaMock mock = (BookMetaMock)super.clone();
        mock.pages = new ArrayList<String>(this.pages);
        return mock;
    }

    @Override
    public boolean hasGeneration() {
        throw new UnimplementedOperationException();
    }

    @Override
    public BookMeta.Generation getGeneration() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGeneration(BookMeta.Generation generation) {
        throw new UnimplementedOperationException();
    }
}

