/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventoryMock
extends InventoryMock
implements PlayerInventory {
    protected static final int HOTBAR = 0;
    protected static final int SLOT_BAR = 9;
    protected static final int BOOTS = 36;
    protected static final int LEGGINGS = 37;
    protected static final int CHESTPLATE = 38;
    protected static final int HELMET = 39;
    protected static final int OFF_HAND = 40;
    private int mainHandSlot = 0;

    public PlayerInventoryMock(HumanEntity holder) {
        super(holder, 41, InventoryType.PLAYER);
    }

    @Override
    public HumanEntity getHolder() {
        return (HumanEntity)super.getHolder();
    }

    @Override
    public ItemStack[] getArmorContents() {
        return Arrays.copyOfRange(this.getContents(), 36, 40);
    }

    @Override
    public ItemStack[] getExtraContents() {
        return Arrays.copyOfRange(this.getContents(), 40, 41);
    }

    @Override
    public ItemStack getHelmet() {
        return this.getItem(39);
    }

    @Override
    public ItemStack getChestplate() {
        return this.getItem(38);
    }

    @Override
    public ItemStack getLeggings() {
        return this.getItem(37);
    }

    @Override
    public ItemStack getBoots() {
        return this.getItem(36);
    }

    @Override
    public void setArmorContents(ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 4) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 4 ? items : Arrays.copyOf(items, 4);
        this.setItem(36, items[0]);
        this.setItem(37, items[1]);
        this.setItem(38, items[2]);
        this.setItem(39, items[3]);
    }

    @Override
    public void setExtraContents(ItemStack[] items) {
        if (items == null) {
            throw new NullPointerException("ItemStack was null");
        }
        if (items.length > 1) {
            throw new IllegalArgumentException("ItemStack array too large (max: 4, was: " + items.length + ")");
        }
        items = items.length == 1 ? items : Arrays.copyOf(items, 1);
        this.setItem(40, items[0]);
    }

    @Override
    public void setHelmet(ItemStack helmet) {
        this.setItem(39, helmet);
    }

    @Override
    public void setChestplate(ItemStack chestplate) {
        this.setItem(38, chestplate);
    }

    @Override
    public void setLeggings(ItemStack leggings) {
        this.setItem(37, leggings);
    }

    @Override
    public void setBoots(ItemStack boots) {
        this.setItem(36, boots);
    }

    @Override
    public ItemStack getItemInMainHand() {
        return this.getItem(9 + this.mainHandSlot);
    }

    @Override
    public void setItemInMainHand(ItemStack item) {
        this.setItem(9 + this.mainHandSlot, item);
    }

    @Override
    public ItemStack getItemInOffHand() {
        return this.getItem(40);
    }

    @Override
    public void setItemInOffHand(ItemStack item) {
        this.setItem(40, item);
    }

    @Override
    @Deprecated
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Override
    @Deprecated
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return this.getChestplate();
            }
            case FEET: {
                return this.getBoots();
            }
            case HAND: {
                return this.getItemInMainHand();
            }
            case HEAD: {
                return this.getHelmet();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
        }
        return new ItemStack(Material.AIR);
    }

    @Override
    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        switch (slot) {
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
        }
    }

    @Override
    public int getHeldItemSlot() {
        return this.mainHandSlot;
    }

    @Override
    public void setHeldItemSlot(int slot) {
        if (slot < 0 || slot > 8) {
            throw new ArrayIndexOutOfBoundsException("Slot should be within [0-8] (was: " + slot + ")");
        }
        this.mainHandSlot = slot;
    }
}

