/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.inventory;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.junit.Assert;

public abstract class InventoryMock
implements Inventory {
    private final ItemStack[] items;
    private final InventoryHolder holder;
    private final InventoryType type;

    public InventoryMock(InventoryHolder holder, int size, InventoryType type) {
        this.holder = holder;
        this.type = type;
        this.items = new ItemStack[size];
    }

    public void assertTrueForAll(Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            Assert.assertTrue(condition.test(item));
        }
    }

    public void assertTrueForNonNulls(Predicate<ItemStack> condition) {
        this.assertTrueForAll(itemstack -> itemstack == null || condition.test((ItemStack)itemstack));
    }

    public void assertTrueForSome(Predicate<ItemStack> condition) {
        for (ItemStack item : this.items) {
            if (item == null || !condition.test(item)) continue;
            return;
        }
        Assert.fail("Condition was not met for any items");
    }

    public void assertContainsAny(ItemStack item) {
        this.assertTrueForSome(item::isSimilar);
    }

    public void assertContainsAtLeast(ItemStack item, int amount) {
        int n = this.getNumberOfItems(item);
        String message = String.format("Inventory contains only <%d> but expected at least <%d>", n, amount);
        Assert.assertTrue(message, n >= amount);
    }

    public int getNumberOfItems(ItemStack item) {
        int amount = 0;
        for (ItemStack itemstack : this.items) {
            if (itemstack == null || !item.isSimilar(itemstack)) continue;
            amount += itemstack.getAmount();
        }
        return amount;
    }

    @Override
    public int getSize() {
        return this.items.length;
    }

    @Override
    public ItemStack getItem(int index) {
        if (this.items[index] == null) {
            this.items[index] = new ItemStack(Material.AIR);
        }
        return this.items[index];
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.items[index] = item == null ? null : item.clone();
    }

    public ItemStack addItem(ItemStack item) {
        item = item.clone();
        for (int i = 0; i < this.items.length; ++i) {
            int toAdd;
            ItemStack oItem = this.items[i];
            if (oItem == null) {
                toAdd = Math.min(item.getAmount(), item.getMaxStackSize());
                this.items[i] = item.clone();
                this.items[i].setAmount(toAdd);
                item.setAmount(item.getAmount() - toAdd);
            } else if (item.isSimilar(oItem) && oItem.getAmount() < oItem.getMaxStackSize()) {
                toAdd = Math.min(item.getAmount(), item.getMaxStackSize() - oItem.getAmount());
                oItem.setAmount(oItem.getAmount() + toAdd);
                item.setAmount(item.getAmount() - toAdd);
            }
            if (item.getAmount() != 0) continue;
            return null;
        }
        return item;
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) throws IllegalArgumentException {
        HashMap<Integer, ItemStack> notSaved = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            ItemStack left = this.addItem(item);
            if (left == null) continue;
            notSaved.put(i, left);
        }
        return notSaved;
    }

    @Override
    public ItemStack[] getContents() {
        return this.items;
    }

    @Override
    public void setContents(ItemStack[] items) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.items[i] = i < items.length && items[i] != null ? items[i].clone() : null;
        }
    }

    @Override
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        List list = Arrays.asList(this.items).stream().filter(item -> item != null).collect(Collectors.toList());
        return list.listIterator();
    }

    @Override
    public InventoryType getType() {
        return this.type;
    }

    @Override
    public int getMaxStackSize() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaxStackSize(int size) {
        throw new UnimplementedOperationException();
    }

    @Override
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public ItemStack[] getStorageContents() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean contains(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean contains(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean contains(Material material, int amount) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean contains(ItemStack item, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean containsAtLeast(ItemStack item, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public HashMap<Integer, ? extends ItemStack> all(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public HashMap<Integer, ? extends ItemStack> all(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int first(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public int first(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int firstEmpty() {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.items[i] != null && this.items[i].getType() != Material.AIR) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove(Material material) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public void remove(ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void clear(int index) {
        this.items[index] = null;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, null);
    }

    @Override
    public List<HumanEntity> getViewers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public ListIterator<ItemStack> iterator(int index) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Location getLocation() {
        throw new UnimplementedOperationException();
    }
}

