/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public final class PlayerMockFactory {
    private static final String[] FIRST_NAMES = new String[]{"James", "Mary", "John", "Particia", "Robert", "Jennifer", "Michael", "Elizabeth", "William", "Linda"};
    private static final String[] LAST_NAMES = new String[]{"Smith", "Johnson", "Jones", "Brown", "Davis", "Miller", "Wilson", "Moore", "Taylor", "Anderson"};
    private final ServerMock server;
    private Random random = new Random();
    private Set<String> usedNames = new HashSet<String>();

    public PlayerMockFactory(ServerMock server) {
        this.server = server;
    }

    private String getRandomName() {
        String firstName = FIRST_NAMES[this.random.nextInt(FIRST_NAMES.length)];
        String lastName = LAST_NAMES[this.random.nextInt(LAST_NAMES.length)];
        return firstName + " " + lastName;
    }

    private String getUniqueRandomName() {
        String name;
        if (this.usedNames.size() >= 100) {
            throw new RuntimeException("Out of names");
        }
        while (this.usedNames.contains(name = this.getRandomName())) {
        }
        this.usedNames.add(name);
        return name;
    }

    public PlayerMock createRandomPlayer() {
        String name = this.getUniqueRandomName();
        UUID uuid = new UUID(this.random.nextLong(), this.random.nextLong());
        return new PlayerMock(this.server, name, uuid);
    }

    public OfflinePlayerMock createRandomOfflinePlayer() {
        return new OfflinePlayerMock(this.getUniqueRandomName());
    }
}

