/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.entity.AudioExperience;
import be.seeseemelk.mockbukkit.entity.LivingEntityMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryViewMock;
import be.seeseemelk.mockbukkit.inventory.SimpleInventoryViewMock;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class PlayerMock
extends LivingEntityMock
implements Player {
    private boolean online;
    private PlayerInventoryMock inventory = null;
    private EnderChestInventoryMock enderChest = null;
    private GameMode gamemode = GameMode.SURVIVAL;
    private String displayName = null;
    private int expTotal = 0;
    private float exp = 0.0f;
    private int foodLevel = 20;
    private int expLevel = 0;
    private boolean sneaking = false;
    private boolean whitelisted = true;
    private InventoryView inventoryView;
    private Location compassTarget;
    private Location bedSpawnLocation;
    private ItemStack cursor = null;
    private final List<AudioExperience> heardSounds = new LinkedList<AudioExperience>();

    public PlayerMock(ServerMock server, String name) {
        this(server, name, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)));
        this.online = false;
    }

    public PlayerMock(ServerMock server, String name, UUID uuid) {
        super(server, uuid);
        this.setName(name);
        this.setDisplayName(name);
        this.online = true;
        if (Bukkit.getWorlds().isEmpty()) {
            MockBukkit.getMock().addSimpleWorld("world");
        }
        this.setLocation(Bukkit.getWorlds().get(0).getSpawnLocation().clone());
        this.setCompassTarget(this.getLocation());
        this.closeInventory();
    }

    public void assertGameMode(GameMode expectedGamemode) {
        Assert.assertEquals((Object)expectedGamemode, (Object)this.gamemode);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.attributes, Float.valueOf(this.exp), this.expLevel, this.expTotal, this.displayName, this.gamemode, this.getHealth(), this.inventory, this.enderChest, this.inventoryView, this.getMaxHealth(), this.online, this.whitelisted, this.compassTarget, this.bedSpawnLocation, this.cursor});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PlayerMock)) {
            return false;
        }
        PlayerMock other = (PlayerMock)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.displayName, other.displayName) && this.gamemode == other.gamemode && Double.doubleToLongBits(this.getHealth()) == Double.doubleToLongBits(other.getHealth()) && Objects.equals(this.inventory, other.inventory) && Objects.equals(this.inventoryView, other.inventoryView) && Objects.equals(this.cursor, other.cursor) && Double.doubleToLongBits(this.getMaxHealth()) == Double.doubleToLongBits(other.getMaxHealth()) && this.online == other.online && this.whitelisted == other.whitelisted && this.isDead() == other.isDead();
    }

    protected BlockDamageEvent simulateBlockDamagePure(Block block) {
        BlockDamageEvent event = new BlockDamageEvent(this, block, this.getItemInHand(), false);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public boolean simulateBlockDamage(Block block) {
        if (this.gamemode == GameMode.SURVIVAL) {
            BlockDamageEvent event = this.simulateBlockDamagePure(block);
            if (event.getInstaBreak()) {
                BlockBreakEvent breakEvent = new BlockBreakEvent(block, this);
                Bukkit.getPluginManager().callEvent(breakEvent);
                if (!breakEvent.isCancelled()) {
                    block.setType(Material.AIR);
                }
            }
            return !event.isCancelled();
        }
        return false;
    }

    public boolean simulateBlockBreak(Block block) {
        if (this.gamemode == GameMode.SPECTATOR || this.gamemode == GameMode.ADVENTURE || this.gamemode == GameMode.SURVIVAL && this.simulateBlockDamagePure(block).isCancelled()) {
            return false;
        }
        BlockBreakEvent event = new BlockBreakEvent(block, this);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            block.setType(Material.AIR);
        }
        return !event.isCancelled();
    }

    public void respawn() {
        boolean isBedSpawn;
        Location respawnLocation = this.getBedSpawnLocation();
        boolean bl = isBedSpawn = respawnLocation != null;
        if (!isBedSpawn) {
            respawnLocation = this.getLocation().getWorld().getSpawnLocation();
        }
        PlayerRespawnEvent event = new PlayerRespawnEvent(this, respawnLocation, isBedSpawn);
        Bukkit.getPluginManager().callEvent(event);
        this.setHealth(this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        this.setLocation(event.getRespawnLocation().clone());
        this.alive = true;
    }

    @Override
    public PlayerInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = (PlayerInventoryMock)Bukkit.createInventory((InventoryHolder)this, InventoryType.PLAYER);
        }
        return this.inventory;
    }

    @Override
    public GameMode getGameMode() {
        return this.gamemode;
    }

    @Override
    public void setGameMode(GameMode mode) {
        this.gamemode = mode;
    }

    @Override
    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    @Override
    public void setWhitelisted(boolean value) {
        this.whitelisted = value;
    }

    @Override
    public Player getPlayer() {
        if (this.online) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isOnline() {
        return this.online;
    }

    @Override
    public boolean isBanned() {
        return MockBukkit.getMock().getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public InventoryView getOpenInventory() {
        return this.inventoryView;
    }

    @Override
    public void openInventory(InventoryView inventory) {
        this.closeInventory();
        this.inventoryView = inventory;
    }

    @Override
    public InventoryView openInventory(Inventory inventory) {
        this.closeInventory();
        this.inventoryView = new PlayerInventoryViewMock(this, inventory);
        return this.inventoryView;
    }

    @Override
    public void closeInventory() {
        if (this.inventoryView instanceof PlayerInventoryViewMock) {
            InventoryCloseEvent event = new InventoryCloseEvent(this.inventoryView);
            Bukkit.getPluginManager().callEvent(event);
        }
        this.cursor = null;
        this.inventoryView = new SimpleInventoryViewMock(this, null, this.inventory, InventoryType.CRAFTING);
    }

    @Override
    public boolean performCommand(String command) {
        return Bukkit.dispatchCommand(this, command);
    }

    @Override
    public Inventory getEnderChest() {
        if (this.enderChest == null) {
            this.enderChest = new EnderChestInventoryMock(this);
        }
        return this.enderChest;
    }

    @Override
    public MainHand getMainHand() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public InventoryView openWorkbench(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public InventoryView openEnchanting(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public InventoryView openMerchant(Villager trader, boolean force) {
        return this.openMerchant((Merchant)trader, force);
    }

    @Override
    public InventoryView openMerchant(Merchant merchant, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    @Override
    public ItemStack getItemOnCursor() {
        return this.cursor == null ? null : this.cursor.clone();
    }

    @Override
    public void setItemOnCursor(ItemStack item) {
        this.cursor = item == null ? null : item.clone();
    }

    @Override
    public boolean hasCooldown(Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getCooldown(Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCooldown(Material material, int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSleeping() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getSleepTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isBlocking() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHandRaised() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getExpToLevel() {
        if (this.expLevel >= 31) {
            return 9 * this.expLevel - 158;
        }
        if (this.expLevel >= 16) {
            return 5 * this.expLevel - 38;
        }
        return 2 * this.expLevel + 7;
    }

    @Override
    public Entity getShoulderEntityLeft() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setShoulderEntityLeft(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getShoulderEntityRight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setShoulderEntityRight(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (this.isSneaking() && !ignorePose) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getRemainingAir() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setRemainingAir(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumAir() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumAir(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasPotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removePotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<PotionEffect> getActivePotionEffects() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityEquipment getEquipment() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLeashed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getLeashHolder() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isGliding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGliding(boolean gliding) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAI(boolean ai) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasAI() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isConversing() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void acceptConversationInput(String input) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getFirstPlayed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getLastPlayed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasPlayedBefore() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Map<String, Object> serialize() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public String getPlayerListName() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerListName(String name) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCompassTarget(@NotNull Location loc) {
        this.compassTarget = loc;
    }

    @Override
    @NotNull
    public Location getCompassTarget() {
        return this.compassTarget;
    }

    @Override
    public InetSocketAddress getAddress() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendRawMessage(String message) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void kickPlayer(String message) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void chat(String msg) {
        AsyncPlayerChatEvent eventAsync = new AsyncPlayerChatEvent(false, this, msg, new HashSet<Player>(Bukkit.getOnlinePlayers()));
        PlayerChatEvent eventSync = new PlayerChatEvent((Player)this, msg);
        MockBukkit.getMock().getScheduler().runTaskAsynchronously(null, () -> Bukkit.getPluginManager().callEvent(eventAsync));
        Bukkit.getPluginManager().callEvent(eventSync);
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public boolean isSprinting() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void saveData() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void loadData() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSleepingIgnored() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, String sound, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, Sound sound, float volume, float pitch) {
        this.playSound(location, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location location, String sound, SoundCategory category, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, Sound sound, SoundCategory category, float volume, float pitch) {
        this.heardSounds.add(new AudioExperience(sound, category, location, volume, pitch));
    }

    public void assertSoundHeard(String message, Sound sound) {
        this.assertSoundHeard(message, sound, e -> true);
    }

    public void assertSoundHeard(String message, Sound sound, Predicate<AudioExperience> predicate) {
        for (AudioExperience audio : this.heardSounds) {
            if (audio.getSound() != sound || !predicate.test(audio)) continue;
            return;
        }
        Assert.fail(message);
    }

    public void assertSoundHeard(Sound sound) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound);
    }

    public void assertSoundHeard(Sound sound, Predicate<AudioExperience> predicate) {
        this.assertSoundHeard("Sound Heard Assertion failed", sound, predicate);
    }

    @Override
    public void stopSound(Sound sound) {
        this.stopSound(sound, SoundCategory.MASTER);
    }

    @Override
    public void stopSound(String sound) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void stopSound(Sound sound, SoundCategory category) {
    }

    @Override
    public void stopSound(String sound, SoundCategory category) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean sendChunkChange(Location loc, int sx, int sy, int sz, byte[] data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendSignChange(Location loc, String[] lines) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendMap(MapView map) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void updateInventory() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getStatistic(Statistic statistic) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getPlayerTime() {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getPlayerTimeOffset() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void resetPlayerTime() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public WeatherType getPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void resetPlayerWeather() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void giveExp(int amount) {
        this.exp += (float)amount / (float)this.getExpToLevel();
        this.setTotalExperience(this.expTotal + amount);
        while (this.exp < 0.0f) {
            float total = this.exp * (float)this.getExpToLevel();
            boolean shouldContinue = this.expLevel > 0;
            this.giveExpLevels(-1);
            if (!shouldContinue) continue;
            this.exp = 1.0f + total / (float)this.getExpToLevel();
        }
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.giveExpLevels(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    @Override
    public void giveExpLevels(int amount) {
        int oldLevel = this.expLevel;
        this.expLevel += amount;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
        }
        if (oldLevel != this.expLevel) {
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(this, oldLevel, this.expLevel);
            Bukkit.getPluginManager().callEvent(event);
        }
    }

    @Override
    public float getExp() {
        return this.exp;
    }

    @Override
    public void setExp(float exp) {
        if ((double)exp < 0.0 || (double)exp > 1.0) {
            throw new IllegalArgumentException("Experience progress must be between 0.0 and 1.0");
        }
        this.exp = exp;
    }

    @Override
    public int getLevel() {
        return this.expLevel;
    }

    @Override
    public void setLevel(int level) {
        this.expLevel = level;
    }

    @Override
    public int getTotalExperience() {
        return this.expTotal;
    }

    @Override
    public void setTotalExperience(int exp) {
        this.expTotal = Math.max(0, exp);
    }

    @Override
    public float getExhaustion() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setExhaustion(float value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getSaturation() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSaturation(float value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.foodLevel = foodLevel;
    }

    @Override
    @Nullable
    public Location getBedSpawnLocation() {
        return this.bedSpawnLocation;
    }

    @Override
    public void setBedSpawnLocation(@Nullable Location loc) {
        this.setBedSpawnLocation(loc, false);
    }

    @Override
    public void setBedSpawnLocation(@Nullable Location loc, boolean force) {
        if (force || loc == null || loc.getBlock().getType().name().endsWith("_BED")) {
            this.bedSpawnLocation = loc;
        }
    }

    @Override
    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAllowFlight(boolean flight) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void hidePlayer(Player player) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void hidePlayer(Plugin plugin, Player player) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void showPlayer(Player player) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void showPlayer(Plugin plugin, Player player) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean canSee(Player player) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isFlying() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setFlying(boolean value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setFlySpeed(float value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setWalkSpeed(float value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getFlySpeed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getWalkSpeed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTexturePack(String url) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setResourcePack(String url) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setResourcePack(String url, byte[] hash) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Scoreboard getScoreboard() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHealthScaled() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHealthScaled(boolean scale) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHealthScale(double scale) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getHealthScale() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getSpectatorTarget() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSpectatorTarget(Entity entity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void resetTitle() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public AdvancementProgress getAdvancementProgress(Advancement advancement) {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getLocale() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getPlayerListHeader() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getPlayerListFooter() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerListHeader(String header) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerListFooter(String footer) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPlayerListHeaderFooter(String header, String footer) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendBlockChange(Location loc, BlockData block) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void updateCommands() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getClientViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean sleep(Location location, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void wakeup(boolean setSpawnLocation) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Location getBedLocation() {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> T getMemory(MemoryKey<T> memoryKey) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void setMemory(MemoryKey<T> memoryKey, T memoryValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getAbsorptionAmount() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAbsorptionAmount(double amount) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Pose getPose() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public void openBook(ItemStack book) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void attack(Entity target) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void swingMainHand() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void swingOffHand() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendExperienceChange(float progress) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void sendExperienceChange(float progress, int level) {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getAttackCooldown() {
        throw new UnimplementedOperationException();
    }
}

