/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.attribute.AttributeInstanceMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public abstract class LivingEntityMock
extends EntityMock
implements LivingEntity {
    private static final double MAX_HEALTH = 20.0;
    private double health;
    private double maxHealth = 20.0;
    protected boolean alive = true;
    protected Map<Attribute, AttributeInstanceMock> attributes = new EnumMap<Attribute, AttributeInstanceMock>(Attribute.class);

    public LivingEntityMock(ServerMock server, UUID uuid) {
        super(server, uuid);
        this.attributes.put(Attribute.GENERIC_MAX_HEALTH, new AttributeInstanceMock(Attribute.GENERIC_MAX_HEALTH, 20.0));
        this.setMaxHealth(20.0);
        this.setHealth(20.0);
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    @Override
    public boolean isDead() {
        return !this.alive;
    }

    @Override
    public void setHealth(double health) {
        if (health <= 0.0) {
            this.health = 0.0;
            if (this instanceof Player) {
                Player player = (Player)((Object)this);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.addAll(Arrays.asList(player.getInventory().getContents()));
                PlayerDeathEvent event = new PlayerDeathEvent(player, drops, 0, this.getName() + " got killed");
                Bukkit.getPluginManager().callEvent(event);
                player.closeInventory();
                if (!this.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY).booleanValue()) {
                    player.getInventory().clear();
                }
                player.setLevel(0);
                player.setExp(0.0f);
                player.setFoodLevel(0);
            } else {
                EntityDeathEvent event = new EntityDeathEvent(this, new ArrayList<ItemStack>(), 0);
                Bukkit.getPluginManager().callEvent(event);
            }
            this.alive = false;
        } else {
            this.health = Math.min(health, this.getMaxHealth());
        }
    }

    @Override
    public double getMaxHealth() {
        return this.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    @Override
    public void setMaxHealth(double health) {
        this.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
        if (this.health > health) {
            this.health = health;
        }
    }

    @Override
    public void resetMaxHealth() {
        this.setMaxHealth(this.maxHealth);
    }

    @Override
    public void damage(double amount) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, 1.0);
        EnumMap<EntityDamageEvent.DamageModifier, Function> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, Function>(EntityDamageEvent.DamageModifier.class);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, damage -> damage);
        EntityDamageEvent event = new EntityDamageEvent(this, EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        event.setDamage(amount);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            amount = event.getDamage();
            this.setHealth(this.health - amount);
        }
    }

    @Override
    public void damage(double amount, Entity source) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, 1.0);
        EnumMap<EntityDamageEvent.DamageModifier, Function> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, Function>(EntityDamageEvent.DamageModifier.class);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, damage -> damage);
        EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(source, this, EntityDamageEvent.DamageCause.ENTITY_ATTACK, modifiers, modifierFunctions);
        event.setDamage(amount);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            amount = event.getDamage();
            this.setHealth(this.health - amount);
        }
    }

    @Override
    public AttributeInstance getAttribute(Attribute attribute) {
        if (this.attributes.containsKey(attribute)) {
            return this.attributes.get(attribute);
        }
        throw new UnimplementedOperationException();
    }

    @Override
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPersistent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPersistent(boolean persistent) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockFace getFacing() {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Location getEyeLocation() {
        return this.getLocation().add(0.0, this.getEyeHeight(), 0.0);
    }

    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getRemainingAir() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setRemainingAir(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumAir() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumAir(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaximumNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getLastDamage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamage(double damage) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getNoDamageTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Player getKiller() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasPotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removePotionEffect(PotionEffectType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<PotionEffect> getActivePotionEffects() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityEquipment getEquipment() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getCanPickupItems() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLeashed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getLeashHolder() throws IllegalStateException {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isGliding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGliding(boolean gliding) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSwimming() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSwimming(boolean swimming) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isRiptiding() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAI(boolean ai) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasAI() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCollidable(boolean collidable) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCollidable() {
        throw new UnimplementedOperationException();
    }
}

