/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.entity;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.metadata.MetadataTable;
import be.seeseemelk.mockbukkit.persistence.PersistentDataContainerMock;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class EntityMock
implements Entity,
MessageTarget {
    private final ServerMock server;
    private final UUID uuid;
    private Location location;
    private boolean teleported;
    private PlayerTeleportEvent.TeleportCause teleportCause;
    private MetadataTable metadataTable = new MetadataTable();
    private PersistentDataContainer persistentDataContainer = new PersistentDataContainerMock();
    private boolean operator = false;
    private String name = "entity";
    private final Queue<String> messages = new LinkedTransferQueue<String>();
    private final Set<PermissionAttachment> permissionAttachments = new HashSet<PermissionAttachment>();

    public EntityMock(ServerMock server, UUID uuid) {
        this.server = server;
        this.uuid = uuid;
        this.location = !Bukkit.getWorlds().isEmpty() ? Bukkit.getWorlds().get(0).getSpawnLocation() : new Location(null, 0.0, 0.0, 0.0);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityMock) {
            return this.uuid.equals(((EntityMock)obj).getUniqueId());
        }
        return false;
    }

    public void assertLocation(Location expectedLocation, double maximumDistance) {
        double distance = this.location.distance(expectedLocation);
        Assert.assertEquals(expectedLocation.getWorld(), this.location.getWorld());
        Assert.assertTrue(String.format("Distance was <%.3f> but should be less than or equal to <%.3f>", distance, maximumDistance), distance <= maximumDistance);
    }

    public void assertTeleported(Location expectedLocation, double maximumDistance) {
        Assert.assertTrue("Player did not teleport", this.teleported);
        this.assertLocation(expectedLocation, maximumDistance);
        this.teleported = false;
    }

    public void assertNotTeleported() {
        Assert.assertFalse("Player was teleported", this.teleported);
        this.teleported = false;
    }

    public boolean hasTeleported() {
        return this.teleported;
    }

    public void clearTeleported() {
        this.teleported = false;
    }

    public PlayerTeleportEvent.TeleportCause getTeleportCause() {
        return this.teleportCause;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public Location getLocation() {
        return this.location.clone();
    }

    @Override
    public Location getLocation(Location loc) {
        loc.setWorld(this.location.getWorld());
        loc.setDirection(this.location.getDirection());
        loc.setX(this.location.getX());
        loc.setY(this.location.getY());
        loc.setZ(this.location.getZ());
        return loc;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.metadataTable.setMetadata(metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.metadataTable.getMetadata(metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.metadataTable.hasMetadata(metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.metadataTable.removeMetadata(metadataKey, owningPlugin);
    }

    @Override
    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        this.location = location;
        this.teleported = true;
        this.teleportCause = cause;
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public boolean isOp() {
        return this.operator;
    }

    @Override
    public void setOp(boolean isOperator) {
        this.operator = isOperator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void sendMessage(String message) {
        this.messages.add(message);
    }

    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public String nextMessage() {
        return this.messages.poll();
    }

    @Override
    public boolean isPermissionSet(String name) {
        for (PermissionAttachment attachment : this.permissionAttachments) {
            Map<String, Boolean> permissions = attachment.getPermissions();
            if (!permissions.containsKey(name) || !permissions.get(name).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.isPermissionSet(perm.getName().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean hasPermission(String name) {
        if (this.isPermissionSet(name)) {
            return true;
        }
        Permission perm = this.server.getPluginManager().getPermission(name);
        return perm != null ? this.hasPermission(perm) : Permission.DEFAULT_PERMISSION.getValue(this.isOp());
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.isPermissionSet(perm) || perm.getDefault().getValue(this.isOp());
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        PermissionAttachment attachment = this.addAttachment(plugin);
        attachment.setPermission(name, value);
        return attachment;
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        PermissionAttachment attachment = new PermissionAttachment(plugin, this);
        this.permissionAttachments.add(attachment);
        return attachment;
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void recalculatePermissions() {
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getCustomName() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCustomName(String name) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setVelocity(Vector velocity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Vector getVelocity() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getHeight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getWidth() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isOnGround() {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getEntityId() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getFireTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaxFireTicks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setFireTicks(int ticks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void remove() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isDead() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isValid() {
        return !this.isDead();
    }

    @Override
    public ServerMock getServer() {
        return this.server;
    }

    @Override
    public Entity getPassenger() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Entity> getPassengers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean removePassenger(Entity passenger) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean eject() {
        throw new UnimplementedOperationException();
    }

    @Override
    public float getFallDistance() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setFallDistance(float distance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getTicksLived() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTicksLived(int value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playEffect(EntityEffect type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public EntityType getType() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInsideVehicle() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean leaveVehicle() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getVehicle() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isCustomNameVisible() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGlowing(boolean flag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isGlowing() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setInvulnerable(boolean flag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isInvulnerable() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isSilent() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSilent(boolean flag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasGravity() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setGravity(boolean gravity) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getPortalCooldown() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<String> getScoreboardTags() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        throw new UnimplementedOperationException();
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        throw new UnimplementedOperationException();
    }
}

