/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit.block;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockStateMock;
import java.util.Collection;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.junit.Assert;

public class BlockMock
implements Block {
    private final Location location;
    private BlockState state;
    private Material material;
    private byte data;

    public BlockMock() {
        this(Material.AIR);
    }

    public BlockMock(Location location) {
        this(Material.AIR, location);
    }

    public BlockMock(Material material) {
        this(material, null);
    }

    public BlockMock(Material material, Location location) {
        this.material = material;
        this.location = location;
        this.state = new BlockStateMock();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Deprecated
    public byte getData() {
        return this.data;
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        int x = this.location.getBlockX() + modX;
        int y = this.location.getBlockY() + modY;
        int z = this.location.getBlockZ() + modZ;
        return this.location.getWorld().getBlockAt(x, y, z);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public void assertType(Material material) throws AssertionFailedError {
        if (this.material != material) {
            Assert.fail(String.format("Block material type is <%s>, but <%s> was expected.", this.material, material));
        }
    }

    @Override
    public Material getType() {
        return this.material;
    }

    @Override
    public byte getLightLevel() {
        throw new UnimplementedOperationException();
    }

    @Override
    public byte getLightFromSky() {
        throw new UnimplementedOperationException();
    }

    @Override
    public byte getLightFromBlocks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public int getX() {
        return this.location.getBlockX();
    }

    @Override
    public int getY() {
        return this.location.getBlockY();
    }

    @Override
    public int getZ() {
        return this.location.getBlockZ();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Location getLocation(Location loc) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Chunk getChunk() {
        return this.location.getWorld().getChunkAt(this);
    }

    @Override
    public void setType(Material type) {
        this.material = type;
    }

    @Override
    public void setType(Material type, boolean applyPhysics) {
        this.setType(this.material);
    }

    @Override
    public BlockFace getFace(Block block) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockState getState() {
        return this.state;
    }

    @Override
    public Biome getBiome() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBiome(Biome bio) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isBlockPowered() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getBlockPower(BlockFace face) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getBlockPower() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isLiquid() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getTemperature() {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getHumidity() {
        throw new UnimplementedOperationException();
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean breakNaturally() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean breakNaturally(ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<ItemStack> getDrops() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack tool) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockData getBlockData() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBlockData(BlockData data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBlockData(BlockData data, boolean applyPhysics) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPassable() {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BoundingBox getBoundingBox() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack tool, Entity entity) {
        throw new UnimplementedOperationException();
    }
}

