/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.ChunkMock;
import be.seeseemelk.mockbukkit.Coordinate;
import be.seeseemelk.mockbukkit.MockBukkit;
import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.block.BlockMock;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.ZombieMock;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WorldMock
implements World {
    private Map<Coordinate, BlockMock> blocks = new HashMap<Coordinate, BlockMock>();
    private ServerMock server;
    private Material defaultBlock;
    private int height;
    private int grassHeight;
    private String name = "World";
    private UUID uuid = UUID.randomUUID();
    private Location spawnLocation;
    private int weatherDuration = 0;
    private int thunderDuration = 0;
    private boolean storming = false;
    private Map<GameRule<?>, Object> gameRules = new HashMap();

    public WorldMock(Material defaultBlock, int height, int grassHeight) {
        this.defaultBlock = defaultBlock;
        this.height = height;
        this.grassHeight = grassHeight;
        this.server = MockBukkit.getMock();
        this.gameRules.put(GameRule.ANNOUNCE_ADVANCEMENTS, true);
        this.gameRules.put(GameRule.COMMAND_BLOCK_OUTPUT, true);
        this.gameRules.put(GameRule.DISABLE_ELYTRA_MOVEMENT_CHECK, false);
        this.gameRules.put(GameRule.DO_DAYLIGHT_CYCLE, true);
        this.gameRules.put(GameRule.DO_ENTITY_DROPS, true);
        this.gameRules.put(GameRule.DO_FIRE_TICK, true);
        this.gameRules.put(GameRule.DO_LIMITED_CRAFTING, false);
        this.gameRules.put(GameRule.DO_MOB_LOOT, true);
        this.gameRules.put(GameRule.DO_MOB_SPAWNING, true);
        this.gameRules.put(GameRule.DO_TILE_DROPS, true);
        this.gameRules.put(GameRule.DO_WEATHER_CYCLE, true);
        this.gameRules.put(GameRule.KEEP_INVENTORY, false);
        this.gameRules.put(GameRule.LOG_ADMIN_COMMANDS, true);
        this.gameRules.put(GameRule.MAX_COMMAND_CHAIN_LENGTH, 65536);
        this.gameRules.put(GameRule.MAX_ENTITY_CRAMMING, 24);
        this.gameRules.put(GameRule.MOB_GRIEFING, true);
        this.gameRules.put(GameRule.NATURAL_REGENERATION, true);
        this.gameRules.put(GameRule.RANDOM_TICK_SPEED, 3);
        this.gameRules.put(GameRule.REDUCED_DEBUG_INFO, false);
        this.gameRules.put(GameRule.SEND_COMMAND_FEEDBACK, true);
        this.gameRules.put(GameRule.SHOW_DEATH_MESSAGES, true);
        this.gameRules.put(GameRule.SPAWN_RADIUS, 10);
        this.gameRules.put(GameRule.SPECTATORS_GENERATE_CHUNKS, true);
    }

    public WorldMock(Material defaultBlock, int grassHeight) {
        this(defaultBlock, 128, grassHeight);
    }

    public WorldMock() {
        this(Material.GRASS, 4);
    }

    public BlockMock createBlock(Coordinate c) {
        if (c.y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Y larger than height");
        }
        if (c.y < 0) {
            throw new ArrayIndexOutOfBoundsException("Y smaller than 0");
        }
        Location location = new Location(this, c.x, c.y, c.z);
        BlockMock block = c.y == 0 ? new BlockMock(Material.BEDROCK, location) : (c.y <= this.grassHeight ? new BlockMock(this.defaultBlock, location) : new BlockMock(location));
        this.blocks.put(c, block);
        return block;
    }

    @Override
    public BlockMock getBlockAt(int x, int y, int z) {
        Coordinate coordinate = new Coordinate(x, y, z);
        if (this.blocks.containsKey(coordinate)) {
            return this.blocks.get(coordinate);
        }
        return this.createBlock(coordinate);
    }

    @Override
    public BlockMock getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public UUID getUID() {
        return this.uuid;
    }

    @Override
    public Location getSpawnLocation() {
        if (this.spawnLocation == null) {
            this.setSpawnLocation(0, this.grassHeight + 1, 0);
        }
        return this.spawnLocation;
    }

    @Override
    public boolean setSpawnLocation(Location location) {
        return this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z) {
        if (this.spawnLocation == null) {
            this.spawnLocation = new Location(this, x, y, z);
        } else {
            this.spawnLocation.setX(x);
            this.spawnLocation.setY(y);
            this.spawnLocation.setZ(z);
        }
        return true;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Set<EntityMock> serverEntities = MockBukkit.getMock().getEntities();
        serverEntities.stream().filter(entity -> entity.getWorld() == this).collect(Collectors.toCollection(() -> entities));
        return entities;
    }

    @Override
    public ChunkMock getChunkAt(int x, int z) {
        ChunkMock chunk = new ChunkMock(this, x, z);
        return chunk;
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getHighestBlockAt(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getHighestBlockAt(Location location) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Chunk getChunkAt(Location location) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Chunk getChunkAt(Block block) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isChunkLoaded(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Chunk[] getLoadedChunks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void loadChunk(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isChunkInUse(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void loadChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean loadChunk(int x, int z, boolean generate) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadChunk(int x, int z, boolean save) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadChunkRequest(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    @Deprecated
    public boolean refreshChunk(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Item dropItem(Location location, ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Item dropItemNaturally(Location location, ItemStack item) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Arrow spawnArrow(Location location, Vector direction, float speed, float spread) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean generateTree(Location location, TreeType type) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType type) {
        EntityMock entity = null;
        switch (type) {
            case ZOMBIE: {
                entity = new ZombieMock(this.server, UUID.randomUUID());
                break;
            }
            case DROPPED_ITEM: 
            case ARROW: 
            case PAINTING: 
            case LEASH_HITCH: 
            case EGG: 
            case STRAY: 
            case WITHER_SKELETON: 
            case ELDER_GUARDIAN: 
            case AREA_EFFECT_CLOUD: 
            case EXPERIENCE_ORB: 
            case UNKNOWN: 
            case PLAYER: 
            case LIGHTNING: 
            case FISHING_HOOK: 
            case FOX: 
            case WANDERING_TRADER: 
            case TRADER_LLAMA: 
            case RAVAGER: 
            case PILLAGER: 
            case PANDA: 
            case CAT: 
            case DOLPHIN: 
            case DROWNED: 
            case TROPICAL_FISH: 
            case PUFFERFISH: 
            case SALMON: 
            case COD: 
            case TRIDENT: 
            case PHANTOM: 
            case TURTLE: 
            case ENDER_CRYSTAL: 
            case VILLAGER: 
            case PARROT: 
            case LLAMA_SPIT: 
            case LLAMA: 
            case POLAR_BEAR: 
            case RABBIT: 
            case HORSE: 
            case IRON_GOLEM: 
            case OCELOT: 
            case SNOWMAN: 
            case MUSHROOM_COW: 
            case WOLF: 
            case SQUID: 
            case CHICKEN: 
            case COW: 
            case SHEEP: 
            case PIG: 
            case SHULKER: 
            case GUARDIAN: 
            case ENDERMITE: 
            case WITCH: 
            case BAT: 
            case WITHER: 
            case ENDER_DRAGON: 
            case MAGMA_CUBE: 
            case BLAZE: 
            case SILVERFISH: 
            case CAVE_SPIDER: 
            case ENDERMAN: 
            case PIG_ZOMBIE: 
            case GHAST: 
            case SLIME: 
            case GIANT: 
            case SPIDER: 
            case SKELETON: 
            case CREEPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_HOPPER: 
            case MINECART_TNT: 
            case MINECART_FURNACE: 
            case MINECART_CHEST: 
            case MINECART: 
            case BOAT: 
            case MINECART_COMMAND: 
            case ILLUSIONER: 
            case VINDICATOR: 
            case VEX: 
            case EVOKER: 
            case EVOKER_FANGS: 
            case MULE: 
            case DONKEY: 
            case ARMOR_STAND: 
            case ZOMBIE_HORSE: 
            case SKELETON_HORSE: 
            case ZOMBIE_VILLAGER: 
            case DRAGON_FIREBALL: 
            case SHULKER_BULLET: 
            case SPECTRAL_ARROW: 
            case HUSK: 
            case FIREWORK: 
            case FALLING_BLOCK: 
            case PRIMED_TNT: 
            case WITHER_SKULL: 
            case ITEM_FRAME: 
            case THROWN_EXP_BOTTLE: 
            case SPLASH_POTION: 
            case ENDER_SIGNAL: 
            case ENDER_PEARL: 
            case SMALL_FIREBALL: 
            case FIREBALL: 
            case SNOWBALL: {
                break;
            }
            default: {
                throw new UnimplementedOperationException();
            }
        }
        if (entity != null) {
            entity.setLocation(loc);
            this.server.registerEntity(entity);
        }
        return entity;
    }

    @Override
    public LightningStrike strikeLightning(Location loc) {
        throw new UnimplementedOperationException();
    }

    @Override
    public LightningStrike strikeLightningEffect(Location loc) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        throw new UnimplementedOperationException();
    }

    @Override
    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> cls) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Player> getPlayers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getTime() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTime(long time) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getFullTime() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setFullTime(long time) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasStorm() {
        return this.storming;
    }

    @Override
    public void setStorm(boolean hasStorm) {
        this.storming = hasStorm;
    }

    @Override
    public int getWeatherDuration() {
        return this.weatherDuration;
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.weatherDuration = duration;
    }

    @Override
    public boolean isThundering() {
        return this.thunderDuration > 0;
    }

    @Override
    public void setThundering(boolean thundering) {
        this.thunderDuration = thundering ? 600 : 0;
    }

    @Override
    public int getThunderDuration() {
        return this.thunderDuration;
    }

    @Override
    public void setThunderDuration(int duration) {
        this.thunderDuration = duration;
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(Location loc, float power) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire) {
        throw new UnimplementedOperationException();
    }

    @Override
    public World.Environment getEnvironment() {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getSeed() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getPVP() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setPVP(boolean pvp) {
        throw new UnimplementedOperationException();
    }

    @Override
    public ChunkGenerator getGenerator() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void save() {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<BlockPopulator> getPopulators() {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    @Deprecated
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playEffect(Location location, Effect effect, int data, int radius) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void playEffect(Location location, Effect effect, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void playEffect(Location location, Effect effect, T data, int radius) {
        throw new UnimplementedOperationException();
    }

    @Override
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getAllowAnimals() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getAllowMonsters() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Biome getBiome(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBiome(int x, int z, Biome bio) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getTemperature(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getHumidity(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMaxHeight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getSeaLevel() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getKeepSpawnInMemory() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isAutoSave() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAutoSave(boolean value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Difficulty getDifficulty() {
        throw new UnimplementedOperationException();
    }

    @Override
    public File getWorldFolder() {
        throw new UnimplementedOperationException();
    }

    @Override
    public WorldType getWorldType() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean canGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setMonsterSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAnimalSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setWaterAnimalSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setAmbientSpawnLimit(int limit) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, Sound sound, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, String sound, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, Sound sound, SoundCategory category, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void playSound(Location location, String sound, SoundCategory category, float volume, float pitch) {
        throw new UnimplementedOperationException();
    }

    @Override
    public String[] getGameRules() {
        return this.gameRules.values().stream().map(Object::toString).collect(Collectors.toList()).toArray(new String[0]);
    }

    @Override
    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        GameRule<?> gameRule = GameRule.getByName(rule);
        if (gameRule == null) {
            return null;
        }
        return this.getGameRuleValue(gameRule).toString();
    }

    @Override
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null) {
            return false;
        }
        GameRule<?> gameRule = GameRule.getByName(rule);
        if (gameRule == null) {
            return false;
        }
        if (gameRule.getType().equals(Boolean.TYPE) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            return this.setGameRule(gameRule, value.equalsIgnoreCase("true"));
        }
        if (gameRule.getType().equals(Integer.TYPE)) {
            try {
                int intValue = Integer.parseInt(value);
                return this.setGameRule(gameRule, intValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isGameRule(String rule) {
        return rule != null && GameRule.getByName(rule) != null;
    }

    @Override
    public WorldBorder getWorldBorder() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> T getGameRuleValue(GameRule<T> rule) {
        return rule.getType().cast(this.gameRules.get(rule));
    }

    @Override
    public <T> T getGameRuleDefault(GameRule<T> rule) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        this.gameRules.put(rule, newValue);
        return true;
    }

    @Override
    public boolean isChunkGenerated(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isChunkForceLoaded(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setChunkForceLoaded(int x, int z, boolean forced) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Chunk> getForceLoadedChunks() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void removePluginChunkTickets(Plugin plugin) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends AbstractArrow> T spawnArrow(Location location, Vector direction, float speed, float spread, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Raid locateNearestRaid(Location location, int radius) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Raid> getRaids() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setBiome(int x, int y, int z, Biome bio) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHardcore() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setHardcore(boolean hardcore) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        throw new UnimplementedOperationException();
    }

    @Override
    public DragonBattle getEnderDragonBattle() {
        throw new UnimplementedOperationException();
    }
}

