/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.MockCommandMap;
import be.seeseemelk.mockbukkit.MockUnsafeValues;
import be.seeseemelk.mockbukkit.PlayerList;
import be.seeseemelk.mockbukkit.ThreadAccessException;
import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.command.CommandResult;
import be.seeseemelk.mockbukkit.command.ConsoleCommandSenderMock;
import be.seeseemelk.mockbukkit.command.MessageTarget;
import be.seeseemelk.mockbukkit.entity.EntityMock;
import be.seeseemelk.mockbukkit.entity.OfflinePlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMockFactory;
import be.seeseemelk.mockbukkit.inventory.ChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.EnderChestInventoryMock;
import be.seeseemelk.mockbukkit.inventory.InventoryMock;
import be.seeseemelk.mockbukkit.inventory.ItemFactoryMock;
import be.seeseemelk.mockbukkit.inventory.PlayerInventoryMock;
import be.seeseemelk.mockbukkit.inventory.meta.ItemMetaMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import be.seeseemelk.mockbukkit.scheduler.BukkitSchedulerMock;
import be.seeseemelk.mockbukkit.scoreboard.ScoreboardManagerMock;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapView;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.util.CachedServerIcon;

public class ServerMock
implements Server {
    private static final String BUKKIT_VERSION = "1.15.2";
    private static final String JOIN_MESSAGE = "%s has joined the server.";
    private final Logger logger;
    private final Thread mainThread;
    private final MockUnsafeValues unsafe = new MockUnsafeValues();
    private final List<PlayerMock> players = new ArrayList<PlayerMock>();
    private final Set<OfflinePlayer> offlinePlayers = new HashSet<OfflinePlayer>();
    private final Set<EntityMock> entities = new HashSet<EntityMock>();
    private final List<World> worlds = new ArrayList<World>();
    private final List<Recipe> recipes = new LinkedList<Recipe>();
    private final ItemFactory factory = new ItemFactoryMock();
    private final PlayerMockFactory playerFactory = new PlayerMockFactory(this);
    private final PluginManagerMock pluginManager = new PluginManagerMock(this);
    private final ScoreboardManagerMock scoreboardManager = new ScoreboardManagerMock();
    private final BukkitSchedulerMock scheduler = new BukkitSchedulerMock();
    private final PlayerList playerList = new PlayerList();
    private ConsoleCommandSender consoleSender;
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    private MockCommandMap commandMap;

    public ServerMock() {
        this.mainThread = Thread.currentThread();
        this.logger = Logger.getLogger("ServerMock");
        this.commandMap = new MockCommandMap(this);
        ServerMock.registerSerializables();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream("logger.properties");
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            this.logger.warning("Could not load file logger.properties");
        }
        this.logger.setLevel(Level.ALL);
    }

    public boolean isOnMainThread() {
        return this.mainThread.equals(Thread.currentThread());
    }

    public void assertMainThread() {
        if (!this.isOnMainThread()) {
            throw new ThreadAccessException("The Bukkit API was accessed from asynchronous code.");
        }
    }

    public void registerEntity(EntityMock entity) {
        this.assertMainThread();
        this.entities.add(entity);
    }

    public Set<EntityMock> getEntities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public void addPlayer(PlayerMock player) {
        this.assertMainThread();
        this.players.add(player);
        this.offlinePlayers.add(player);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)player, String.format(JOIN_MESSAGE, player.getDisplayName()));
        Bukkit.getPluginManager().callEvent(playerJoinEvent);
        this.registerEntity(player);
    }

    public PlayerMock addPlayer() {
        this.assertMainThread();
        PlayerMock player = this.playerFactory.createRandomPlayer();
        this.addPlayer(player);
        return player;
    }

    public PlayerMock addPlayer(String name) {
        this.assertMainThread();
        PlayerMock player = new PlayerMock(this, name);
        this.addPlayer(player);
        return player;
    }

    public void setPlayers(int num) {
        this.assertMainThread();
        this.players.clear();
        for (int i = 0; i < num; ++i) {
            this.addPlayer();
        }
    }

    public void setOfflinePlayers(int num) {
        this.assertMainThread();
        this.offlinePlayers.clear();
        this.offlinePlayers.addAll(this.players);
        for (int i = 0; i < num; ++i) {
            OfflinePlayerMock player = this.playerFactory.createRandomOfflinePlayer();
            this.offlinePlayers.add(player);
        }
    }

    public PlayerMock getPlayer(int num) {
        if (num < 0 || num >= this.players.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.players.get(num);
    }

    public WorldMock addSimpleWorld(String name) {
        this.assertMainThread();
        WorldMock world = new WorldMock();
        world.setName(name);
        this.worlds.add(world);
        return world;
    }

    public void addWorld(WorldMock world) {
        this.assertMainThread();
        this.worlds.add(world);
    }

    public CommandResult executeConsole(Command command, String ... args) {
        this.assertMainThread();
        return this.execute(command, (CommandSender)this.getConsoleSender(), args);
    }

    public CommandResult executeConsole(String command, String ... args) {
        this.assertMainThread();
        return this.executeConsole(this.getPluginCommand(command), args);
    }

    public CommandResult executePlayer(Command command, String ... args) {
        this.assertMainThread();
        if (!this.players.isEmpty()) {
            return this.execute(command, (CommandSender)this.players.get(0), args);
        }
        throw new IllegalStateException("Need at least one player to run the command");
    }

    public CommandResult executePlayer(String command, String ... args) {
        this.assertMainThread();
        return this.executePlayer(this.getPluginCommand(command), args);
    }

    public CommandResult execute(Command command, CommandSender sender, String ... args) {
        this.assertMainThread();
        if (!(sender instanceof MessageTarget)) {
            throw new IllegalArgumentException("Only a MessageTarget can be the sender of the command");
        }
        boolean status = command.execute(sender, command.getName(), args);
        return new CommandResult(status, (MessageTarget)((Object)sender));
    }

    public CommandResult execute(String command, CommandSender sender, String ... args) {
        this.assertMainThread();
        return this.execute(this.getPluginCommand(command), sender, args);
    }

    @Override
    public String getName() {
        return "ServerMock";
    }

    @Override
    public String getVersion() {
        return "0.1.0";
    }

    @Override
    public String getBukkitVersion() {
        return BUKKIT_VERSION;
    }

    public Collection<? extends PlayerMock> getOnlinePlayers() {
        this.assertMainThread();
        return this.players;
    }

    @Override
    public OfflinePlayer[] getOfflinePlayers() {
        return this.offlinePlayers.toArray(new OfflinePlayer[0]);
    }

    @Override
    public Player getPlayer(String name) {
        Player player = this.getPlayerExact(name);
        if (player != null) {
            return player;
        }
        String lowercase = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player2 : this.players) {
            int currentDelta;
            if (!player2.getName().toLowerCase(Locale.ENGLISH).startsWith(lowercase) || (currentDelta = Math.abs(player2.getName().length() - lowercase.length())) >= delta) continue;
            delta = currentDelta;
            player = player2;
        }
        return player;
    }

    @Override
    public Player getPlayerExact(String name) {
        this.assertMainThread();
        return this.players.stream().filter(playerMock -> playerMock.getName().toLowerCase(Locale.ENGLISH).equals(name.toLowerCase(Locale.ENGLISH))).findFirst().orElse(null);
    }

    @Override
    public List<Player> matchPlayer(String name) {
        this.assertMainThread();
        return this.players.stream().filter(player -> player.getName().toLowerCase(Locale.ENGLISH).startsWith(name.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    @Override
    public Player getPlayer(UUID id) {
        this.assertMainThread();
        for (Player player : this.getOnlinePlayers()) {
            if (!id.equals(player.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    @Override
    public PluginManagerMock getPluginManager() {
        return this.pluginManager;
    }

    private boolean isLabelOfCommand(PluginCommand command, String label) {
        this.assertMainThread();
        if (label.equals(command.getName())) {
            return true;
        }
        for (String alias : command.getAliases()) {
            if (!label.equals(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PluginCommand getPluginCommand(String name) {
        this.assertMainThread();
        for (PluginCommand command : this.getPluginManager().getCommands()) {
            if (!this.isLabelOfCommand(command, name)) continue;
            return command;
        }
        return null;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public ConsoleCommandSender getConsoleSender() {
        if (this.consoleSender == null) {
            this.consoleSender = new ConsoleCommandSenderMock();
        }
        return this.consoleSender;
    }

    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title, int size) {
        this.assertMainThread();
        switch (type) {
            case PLAYER: {
                PlayerInventoryMock inventory = new PlayerInventoryMock((HumanEntity)owner);
                return inventory;
            }
            case CHEST: {
                ChestInventoryMock inventory = new ChestInventoryMock(owner, size > 0 ? size : 27);
                return inventory;
            }
            case ENDER_CHEST: {
                EnderChestInventoryMock inventory = new EnderChestInventoryMock(owner);
                return inventory;
            }
        }
        throw new UnimplementedOperationException("Inventory type not yet supported");
    }

    @Override
    public InventoryMock createInventory(InventoryHolder owner, InventoryType type) {
        return this.createInventory(owner, type, "Inventory");
    }

    @Override
    public InventoryMock createInventory(InventoryHolder owner, InventoryType type, String title) {
        return this.createInventory(owner, type, title, -1);
    }

    @Override
    public InventoryMock createInventory(InventoryHolder owner, int size) {
        return this.createInventory(owner, size, "Inventory");
    }

    @Override
    public InventoryMock createInventory(InventoryHolder owner, int size, String title) {
        return this.createInventory(owner, InventoryType.CHEST, title, size);
    }

    @Override
    public ItemFactory getItemFactory() {
        return this.factory;
    }

    @Override
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds);
    }

    @Override
    public World getWorld(String name) {
        return this.worlds.stream().filter(world -> world.getName().equals(name)).findAny().orElse(null);
    }

    @Override
    public World getWorld(UUID uid) {
        return this.worlds.stream().filter(world -> world.getUID().equals(uid)).findAny().orElse(null);
    }

    @Override
    public BukkitSchedulerMock getScheduler() {
        return this.scheduler;
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    @Override
    public Set<String> getIPBans() {
        return this.playerList.getIPBans().getBanEntries().stream().map(BanEntry::getTarget).collect(Collectors.toSet());
    }

    @Override
    public void banIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().addBan(address, null, null, null);
    }

    @Override
    public void unbanIP(String address) {
        this.assertMainThread();
        this.playerList.getIPBans().pardon(address);
    }

    @Override
    public BanList getBanList(BanList.Type type) {
        switch (type) {
            case IP: {
                return this.playerList.getIPBans();
            }
        }
        return this.playerList.getProfileBans();
    }

    @Override
    public Set<OfflinePlayer> getOperators() {
        this.assertMainThread();
        HashSet<OfflinePlayer> allPlayers = new HashSet<OfflinePlayer>();
        allPlayers.addAll(this.offlinePlayers);
        allPlayers.addAll(this.players);
        return allPlayers.stream().filter(ServerOperator::isOp).collect(Collectors.toSet());
    }

    @Override
    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    @Override
    public void setDefaultGameMode(GameMode mode) {
        this.assertMainThread();
        this.defaultGameMode = mode;
    }

    @Override
    public int broadcastMessage(String message) {
        this.assertMainThread();
        for (Player player : this.players) {
            player.sendMessage(message);
        }
        return this.players.size();
    }

    public static void registerSerializables() {
        ConfigurationSerialization.registerClass(ItemMetaMock.class);
    }

    @Override
    public boolean addRecipe(Recipe recipe) {
        this.assertMainThread();
        this.recipes.add(recipe);
        return true;
    }

    @Override
    public List<Recipe> getRecipesFor(ItemStack result) {
        this.assertMainThread();
        return this.recipes.stream().filter(recipe -> recipe.getResult().equals(result)).collect(Collectors.toList());
    }

    @Override
    public Iterator<Recipe> recipeIterator() {
        this.assertMainThread();
        return this.recipes.iterator();
    }

    @Override
    public void clearRecipes() {
        this.assertMainThread();
        this.recipes.clear();
    }

    @Override
    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        this.assertMainThread();
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        String[] args = Arrays.copyOfRange(commands, 1, commands.length);
        PluginCommand command = this.getPluginCommand(commandLabel);
        if (command != null) {
            return ((Command)command).execute(sender, commandLabel, args);
        }
        return false;
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getPort() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getViewDistance() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getIp() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getWorldType() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getGenerateStructures() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getAllowEnd() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getAllowNether() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean hasWhitelist() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setWhitelist(boolean value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void reloadWhitelist() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getUpdateFolder() {
        throw new UnimplementedOperationException();
    }

    @Override
    public File getUpdateFolderFile() {
        throw new UnimplementedOperationException();
    }

    @Override
    public long getConnectionThrottle() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getTicksPerAnimalSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getTicksPerMonsterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public ServicesManager getServicesManager() {
        throw new UnimplementedOperationException();
    }

    @Override
    public World createWorld(WorldCreator creator) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadWorld(String name, boolean save) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean unloadWorld(World world, boolean save) {
        throw new UnimplementedOperationException();
    }

    @Override
    public MapView createMap(World world) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void reload() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void reloadData() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void savePlayers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void resetRecipes() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Map<String, String[]> getCommandAliases() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getSpawnRadius() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setSpawnRadius(int value) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getOnlineMode() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean getAllowFlight() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isHardcore() {
        throw new UnimplementedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int broadcast(String message, String permission) {
        throw new UnimplementedOperationException();
    }

    @Override
    public OfflinePlayer getOfflinePlayer(String name) {
        Player player = this.getPlayer(name);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.getName().equals(name)) continue;
            return offlinePlayer;
        }
        return new OfflinePlayerMock(name);
    }

    @Override
    public OfflinePlayer getOfflinePlayer(UUID id) {
        Player player = this.getPlayer(id);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.getUniqueId().equals(id)) continue;
            return offlinePlayer;
        }
        return this.playerFactory.createRandomOfflinePlayer();
    }

    @Override
    public Set<OfflinePlayer> getBannedPlayers() {
        throw new UnimplementedOperationException();
    }

    @Override
    public File getWorldContainer() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Messenger getMessenger() {
        throw new UnimplementedOperationException();
    }

    @Override
    public HelpMap getHelpMap() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Merchant createMerchant(String title) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getMonsterSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getAmbientSpawnLimit() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean isPrimaryThread() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getMotd() {
        throw new UnimplementedOperationException();
    }

    @Override
    public String getShutdownMessage() {
        throw new UnimplementedOperationException();
    }

    @Override
    public Warning.WarningState getWarningState() {
        throw new UnimplementedOperationException();
    }

    @Override
    public ScoreboardManagerMock getScoreboardManager() {
        return this.scoreboardManager;
    }

    @Override
    public CachedServerIcon getServerIcon() {
        throw new UnimplementedOperationException();
    }

    @Override
    public CachedServerIcon loadServerIcon(File file) {
        throw new UnimplementedOperationException();
    }

    @Override
    public CachedServerIcon loadServerIcon(BufferedImage image) {
        throw new UnimplementedOperationException();
    }

    @Override
    public void setIdleTimeout(int threshold) {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getIdleTimeout() {
        throw new UnimplementedOperationException();
    }

    @Override
    public ChunkGenerator.ChunkData createChunkData(World world) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Entity getEntity(UUID uuid) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Advancement getAdvancement(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Iterator<Advancement> advancementIterator() {
        throw new UnimplementedOperationException();
    }

    @Override
    public UnsafeValues getUnsafe() {
        return this.unsafe;
    }

    @Override
    public BlockData createBlockData(Material material) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockData createBlockData(String data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public BlockData createBlockData(Material material, String data) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    @Override
    public LootTable getLootTable(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @Override
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        throw new UnimplementedOperationException();
    }

    @Override
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        throw new UnimplementedOperationException();
    }

    @Override
    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor color, BarStyle style, BarFlag ... flags) {
        throw new UnimplementedOperationException();
    }

    @Override
    public Iterator<KeyedBossBar> getBossBars() {
        throw new UnimplementedOperationException();
    }

    @Override
    public KeyedBossBar getBossBar(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean removeBossBar(NamespacedKey key) {
        throw new UnimplementedOperationException();
    }

    @Override
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        throw new UnimplementedOperationException();
    }

    @Override
    public MapView getMap(int id) {
        throw new UnimplementedOperationException();
    }

    @Override
    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        throw new UnimplementedOperationException();
    }

    public MockCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Override
    public int getTicksPerWaterSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public int getTicksPerAmbientSpawns() {
        throw new UnimplementedOperationException();
    }

    @Override
    public boolean removeRecipe(NamespacedKey key) {
        this.assertMainThread();
        Iterator<Recipe> iterator = this.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = iterator.next();
            if (!(recipe instanceof Keyed) || !((Keyed)((Object)recipe)).getKey().equals(key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }
}

