/*
 * Decompiled with CFR 0.152.
 */
package be.seeseemelk.mockbukkit;

import be.seeseemelk.mockbukkit.UnimplementedOperationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.BanEntry;
import org.bukkit.BanList;

public class MockBanList
implements BanList {
    private Map<String, BanEntry> bans = new HashMap<String, BanEntry>();

    @Override
    public BanEntry getBanEntry(String target) {
        return this.bans.getOrDefault(target, null);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        MockBanEntry entry = new MockBanEntry(target, expires, reason, source);
        this.bans.put(target, entry);
        return entry;
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        return new HashSet<BanEntry>(this.bans.values());
    }

    @Override
    public boolean isBanned(String target) {
        return this.bans.containsKey(target);
    }

    @Override
    public void pardon(String target) {
        this.bans.remove(target);
    }

    public static final class MockBanEntry
    implements BanEntry {
        private String target;
        private String source;
        private String reason;
        private Date created;
        private Date expires;

        public MockBanEntry(String target, Date expires, String reason, String source) {
            this.target = target;
            this.expires = expires;
            this.reason = reason;
            this.source = source;
            this.created = new Date();
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public Date getCreated() {
            return this.created;
        }

        @Override
        public void setCreated(Date created) {
            this.created = created;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public Date getExpiration() {
            return this.expires;
        }

        @Override
        public void setExpiration(Date expiration) {
            this.expires = expiration;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public void save() {
            throw new UnimplementedOperationException();
        }

        public int hashCode() {
            return this.created.hashCode() + this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof BanEntry) {
                BanEntry banEntry = (BanEntry)obj;
                return this.target.equals(banEntry.getTarget()) && this.expires.equals(banEntry.getExpiration()) && this.reason.equals(banEntry.getReason()) && this.source.equals(banEntry.getSource()) && this.created.equals(banEntry.getCreated());
            }
            return false;
        }
    }
}

