/*
 * JS CSS Tooltip v1.2.3
 * https://github.com/mirelvt/js-css-tooltip
 *
 * Released under the MIT license
 *
 * Date: 2017-05-31
 */
"use strict";
let isBottom = false;
function pageSlide() {
    $(window).scroll(function(){
        let scrollTop = $(this).scrollTop();
        let scrollHeight = $(document).height();
        let windowHeight = $(this).height();
        if(scrollTop + windowHeight > scrollHeight - 30 && scrollTop + windowHeight < scrollHeight){
            isBottom = true;
        } else {
            isBottom = false;
        }
    });
}
pageSlide();

function ToolTipInit() {
    "use strict";
    let tooltip, elm_edges, tooltip_text;

    var Tooltip = {
        create: function(tooltip, elm) {
            elm_edges = elm.getBoundingClientRect();
            tooltip_text = document.createTextNode(elm.getAttribute('data-tooltip'));
            tooltip.appendChild(tooltip_text);

            if (elm_edges.left > window.innerWidth - 100) {
                tooltip.className = 'tooltip-container tooltip-left';
            }

            else if ((elm_edges.left + (elm_edges.width / 2)) < 100) {
                tooltip.className = 'tooltip-container tooltip-right';
            }

            else {
                if(isBottom && window.innerHeight - elm_edges.bottom < 70 && window.innerHeight - elm_edges.bottom > -1) {
                    tooltip.className = 'tooltip-container tooltip-top';
                } else {
                    tooltip.className = 'tooltip-container tooltip-center';
                }
            }
        },
        position: function(tooltip, elm) {

            const elm_top = elm_edges.top + elm_edges.height + 10;
            const elm_bottom = elm_edges.top - elm_edges.height - 20; // TODO fix height:80
            const viewport_edges = window.innerWidth - 100;

            if (elm_edges.left > viewport_edges && elm_edges.width < 50) {
                tooltip.style.left = (elm_edges.left - (tooltip.offsetWidth + elm_edges.width)) + 'px';
                tooltip.style.top = (elm.offsetTop + $(window).scrollTop()) + 'px';
            }
            else if (elm_edges.left > viewport_edges && elm_edges.width > 50) {
                tooltip.style.left = (elm_edges.left - tooltip.offsetWidth - 20) + 'px';
                tooltip.style.top = (elm.offsetTop + $(window).scrollTop()) + 'px';
            }

            else if ((elm_edges.left + (elm_edges.width / 2)) < 100) {
                tooltip.style.left = (elm_edges.left + elm_edges.width + 20) + 'px';
                tooltip.style.top = (elm.offsetTop + $(window).scrollTop()) + 'px';
            }
            else {
                const centered = (elm_edges.left + (elm_edges.width / 2)) - (tooltip.offsetWidth / 2);
                if (isBottom && window.innerHeight - elm_edges.bottom < 70 && window.innerHeight - elm_edges.bottom > -1) {
                    tooltip.style.left = centered + 'px';
                    tooltip.style.top = (elm_bottom + $(window).scrollTop()) + 'px';
                } else {
                    tooltip.style.left = centered + 'px';
                    tooltip.style.top = (elm_top + $(window).scrollTop()) + 'px';
                }
            }
        }
    };

    function showTooltip(evt) {
        const item = Object.create(Tooltip);
        item.create(tooltip, evt.currentTarget);
        item.position(tooltip, evt.currentTarget);
    }

    function hideTooltip() {
        tooltip.className = 'tooltip-container no-display';
        tooltip.removeChild(tooltip.firstChild);
        tooltip.removeAttribute('style');
    }

    function onReady() {
        tooltip = document.documentElement.querySelector('.tooltip-container');
        const tooltip_elms = document.documentElement.querySelectorAll('[data-tooltip]');

        Array.prototype.forEach.call(tooltip_elms, function(elm) {
            elm.addEventListener('mouseover', showTooltip, false);
            elm.addEventListener('mouseout', hideTooltip, false);
        });
    }

    onReady();
};
