"use strict";
var VECleanerInterface = (function(){
	function VECleanerInterface() {
	}
	VECleanerInterface.updateThemeWithAppSkinInfo = function(){
		function addStyleRule(selector, rule) {
			//该方法因为引用了闭包，无论如何都会创建style对象，所以不能做插件使用，需要自己手动修改，目前未进行修改
			var createSheet = function () {
				var style = document.createElement("style");
				document.head.appendChild(style);
				return style.sheet||style.styleSheet;
			};
			var sheet = createSheet();
			if( sheet.addRule )
			{
			   sheet.addRule(selector, rule);
			} 
			else if( sheet.insertRules )
			{
			   sheet.insertRules(selector + ' { ' + rule + ' }', sheet.cssRules.length);
			}
		}
		
		function toHex(color, delta) {
			function computeValue(value, delta) {
				var computedValue = !isNaN(delta) ? value + delta : value;
				if (computedValue < 0) {
					computedValue = 0;
				} else if (computedValue > 255) {
					computedValue = 255;
				}
		
				computedValue = Math.round(computedValue).toString(16);
				return computedValue.length == 1 ? "0" + computedValue : computedValue;
			}
			var hex = "";
			if (color) {
				hex = computeValue(color.red, delta) + computeValue(color.green, delta) + computeValue(color.blue, delta);
			}
			return "#" + hex;
		}
		
		function updateThemeWithAppSkinInfoPrivate(appSkinInfo) {
			var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
			document.body.bgColor = toHex(panelBackgroundColor);
			var gradientBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 40) + " , " + toHex(panelBackgroundColor, 10) + ");";
			var gradientDisabledBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 15) + " , " + toHex(panelBackgroundColor, 5) + ");";
			var boxShadow = "-webkit-box-shadow: inset 0 0px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);";
			var boxActiveShadow = "-webkit-box-shadow: inset 0 0px 1px rgba(0, 0, 0, 0.6);";    
			var isPanelThemeLight = panelBackgroundColor.red > 127;
			var fontColor, disabledFontColor;
			var borderColor;
			var inputBackgroundColor;
			var gradientHighlightBg;
			if(isPanelThemeLight) {
				fontColor = "#000000;";
				disabledFontColor = "color:" + toHex(panelBackgroundColor, -70) + ";";
				borderColor = "border-color: " + toHex(panelBackgroundColor, -90) + ";";
				inputBackgroundColor = toHex(panelBackgroundColor, 54) + ";";
				gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -40) + " , " + toHex(panelBackgroundColor,-50) + ");";
			} else {
				fontColor = "#C5C5C5;";
				disabledFontColor = "color:" + toHex(panelBackgroundColor, 100) + ";";
				borderColor = "border-color: " + toHex(panelBackgroundColor, -45) + ";";
				inputBackgroundColor = toHex(panelBackgroundColor, -20) + ";";
				gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -20) + " , " + toHex(panelBackgroundColor, -30) + ");";
			}
						
			addStyleRule("body", "font-family:"+appSkinInfo.baseFontFamily + ";");
			addStyleRule("body", "font-size:" + (appSkinInfo.baseFontSize + 2) + "px" + "; color:" + fontColor + "; background-color:" + toHex(panelBackgroundColor) + ";");
			addStyleRule("button, select, input[type=button], input[type=submit]", "background-color: " + toHex(panelBackgroundColor, 30) + ";");    
			addStyleRule("button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", "background-color: #53A0E9;");
			addStyleRule("[disabled]", gradientDisabledBg);
			addStyleRule("[disabled]", disabledFontColor);
			addStyleRule("input[type=text]", "padding:2px 4px;");
			addStyleRule("input[type=text]", "border: none;");
			addStyleRule("input[type=text]", "color: #C5C5C5;");
			addStyleRule("input[type=text]", "background-color: " + toHex(panelBackgroundColor, 30) + ";");
			addStyleRule("input[type=text]:focus", "background-color: #ffffff;");
			addStyleRule("input[type=text]:focus", "color: #000000;");
			addStyleRule("input[type=text]", "background-color: " + toHex(panelBackgroundColor, 30) + ";");
			addStyleRule(".action_list:before ", "color:" + fontColor);
			addStyleRule(".action_list a ", "color:" + fontColor);
			addStyleRule(".action_list a:hover", "color:" + fontColor);
			addStyleRule(".action_list ", "background-color: " + toHex(panelBackgroundColor, 5) + ";");
			addStyleRule(".action_list li:hover ", "background-color: " + toHex(panelBackgroundColor, 0) + ";");
			addStyleRule(".action_list_items ", "background-color: " + toHex(panelBackgroundColor, 20) + ";");
		}

		function onAppThemeColorChanged(event) {
			var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
			updateThemeWithAppSkinInfoPrivate(skinInfo);
		}
		updateThemeWithAppSkinInfoPrivate(VECleanerInterface.interface.hostEnvironment.appSkinInfo);
	};

	VECleanerInterface.isNodeJSEnabled = function () {		
		if (typeof(cep_node) !== 'undefined' || typeof(require) !== 'undefined') {
			return true
		}
		return false
	}

	VECleanerInterface.escapeString = function(str){
		return (str + '').replace(/[\\"']/g, '\\$&').replace(/\u0000/g, '\\0');
	}

	VECleanerInterface.hostRoot = function(){
		let appPath = VECleanerInterface.interface.getSystemPath(SystemPath.HOST_APPLICATION)
		if (VECleanerInterface.isWin()) {
			return appPath.substr(0, appPath.lastIndexOf("AfterFX.exe"))
		}else{
			let lastIndex = appPath.lastIndexOf("Adobe After Effects CC")
			if(lastIndex == null || typeof(lastIndex) == "undefined" || lastIndex < 0){
				lastIndex = appPath.lastIndexOf("Adobe After Effects 20");
			}
			return appPath.substr(0, lastIndex);
		}
	}

	VECleanerInterface.appScriptFolder = function() {
		return VECleanerInterface.hostRoot() + "Scripts/ScriptUI Panels"
	}

	VECleanerInterface.extensionRoot = function(){
		return VECleanerInterface.interface.getSystemPath(SystemPath.EXTENSION) + "/";
	}
	
	VECleanerInterface.binFolder = function(){
		return VECleanerInterface.interface.getSystemPath(SystemPath.EXTENSION) + "/.bin/";
	}

	VECleanerInterface.hostScriptRoot = function(){
		return VECleanerInterface.interface.getSystemPath(SystemPath.EXTENSION) + "/host/";
	}

	VECleanerInterface.getHostScript = function(name){
		return VECleanerInterface.interface.getSystemPath(SystemPath.EXTENSION) + "/host/" + name;
	}

	VECleanerInterface.scriptResourceFile = function(name){
		return VECleanerInterface.binFolder() + name
	}

	VECleanerInterface.checkResourceFiles = function(){
		const resourceFiles = ["ve_dummy.aep", "JSONParser.js", "lookup.png", "pngquant_mac/pngquant", "pngquant_win/pngquant.exe", "ffmpeg_mac/ffmpeg", "ffmpeg_win/avcodec-58.dll", "ffmpeg_win/avdevice-58.dll", "ffmpeg_win/avfilter-7.dll", "ffmpeg_win/avformat-58.dll", "ffmpeg_win/avutil-56.dll", "ffmpeg_win/ffmpeg.exe", "ffmpeg_win/postproc-55.dll", "ffmpeg_win/swresample-3.dll", "ffmpeg_win/swscale-5.dll"];
		var fs = require("fs");
		
		for (let index = 0; index < resourceFiles.length; index++) {
			if (!fs.existsSync(VECleanerInterface.scriptResourceFile(resourceFiles[index]))) {
				alert(VECleanerInterface.scriptResourceFile(resourceFiles[index]) + " missing!");
				return false
			}
		}
		if (VECleanerInterface.isMac()){
			fs.chmodSync(VECleanerInterface.binFolder() + "/ffmpeg_mac/ffmpeg", "0777");
			fs.chmodSync(VECleanerInterface.binFolder() + "/pngquant_mac/pngquant", "0777");
		}
		return true
	}

	VECleanerInterface.isMac = function(){
		let OSVersion = VECleanerInterface.interface.getOSInformation();
		if (OSVersion.indexOf("Mac") >= 0) {
			return true;
		}
		return false
	}
	
	VECleanerInterface.isWin = function(){
		let OSVersion = VECleanerInterface.interface.getOSInformation();
		if (OSVersion.indexOf("Windows") >= 0) {
			return true;
		}
		return false
	}

	VECleanerInterface.runAction = function (g, a){
		let action = null
		if (g >= 0 && g < VECleanerInterface.actionData.length){
			if (a >= 0 && a < VECleanerInterface.actionData[g].actions.length){
				action = VECleanerInterface.actionData[g].actions[a]
			}
		}

		if (action != null){
			VECleanerInterface.interface.evalScript('VECleaner.ActionSafetyCheck('+ g + ',' + a + ')', function(safe){
				if (safe === true || safe === "true") {
					if (action.twoStep === true){
						VECleanerInterface.showModal()
						VECleanerInterface.interface.evalScript('VECleaner.RunActionStepOne('+ g + ',' + a + ')', function(cmdStr){
							try {
								let cmdData = JSON.parse(cmdStr)
								VECleanerInterface.runCmdsNew(cmdData, function(err,stdout,stderr){
									if(err) {
										alert('error:'+ stderr);
										VECleanerInterface.interface.evalScript('VECleaner.RunActionStepTwo('+ g + ',' + a + ', "")')
									} else {
										let stepTwoCmd = 'VECleaner.RunActionStepTwo('+ g + ',' + a + ', \"' + VECleanerInterface.escapeString(JSON.stringify(cmdData)) +'\")'
										VECleanerInterface.interface.evalScript(stepTwoCmd, function(){
											VECleanerInterface.hideModal()
										})
									}
								});	
							} catch (error) {
								VECleanerInterface.hideModal()
							}
						});
					}else{
						VECleanerInterface.interface.evalScript('VECleaner.RunAction('+ g + ',' + a +  ')', function(){
						});
					}
				}
			})
		}
	}

	VECleanerInterface.toggleGroup = function(g){
		let listTitle = document.getElementById("action_list" + g)
		let listGr = document.getElementById("action_list_items" + g)
		let showing = listGr.style.display === "block"
		if(showing){
			listGr.style.display = "none"
			listTitle.classList.remove("unfold_title")
			listTitle.classList.add("fold_title")
		}else{
			listGr.style.display = "block"
			listTitle.classList.add("unfold_title")
			listTitle.classList.remove("fold_title")
		}
	}

	VECleanerInterface.toggleSaved = function (g, a) {
		let action = null
		if (g >= 0 && g < VECleanerInterface.actionData.length){
			if (a >= 0 && a < VECleanerInterface.actionData[g].actions.length){
				action = VECleanerInterface.actionData[g].actions[a]
			}
		}

		let btnID = "action_save_button_" + g + "_" + a;
		let btn = document.getElementById(btnID)
		if(btn){
			if(VECleanerInterface.saveAction(action)){
				btn.classList.add("fa-star")
				btn.classList.remove("fa-star-o")
			}else{
				btn.classList.add("fa-star-o")
				btn.classList.remove("fa-star")
			}
		}
	}
	
	VECleanerInterface.removeSaved = function (g, a) {
		let action = null
		if (g >= 0 && g < VECleanerInterface.actionData.length){
			if (a >= 0 && a < VECleanerInterface.actionData[g].actions.length){
				action = VECleanerInterface.actionData[g].actions[a]
			}
		}
		if(action){
			VECleanerInterface.saveAction(action)
			VECleanerInterface.loadMyActionList()
		}
	}

	VECleanerInterface.reloadActionDatas = function(callback){
		VECleanerInterface.interface.evalScript('VECleaner.GetAllActionGroupsContent()', function(actions){
			VECleanerInterface.actionData = JSON.parse(actions)
			let allActionDatas = []
			for(let g = 0; g < VECleanerInterface.actionData.length; g++){
				let group = VECleanerInterface.actionData[g]
				for(let a = 0; a < group.actions.length; a++){
					allActionDatas.push(group.actions[a])
				}
			}
			VECleanerInterface.loadSavedActions(allActionDatas);
			callback()
		});
	}

	VECleanerInterface.loadMyActionList = function(){
		let actionMenuElement = document.getElementById("my_action_menu")
		let changeTab = actionMenuElement.style.display != "block"
		if(changeTab){
			let mytoolsTab = document.getElementById("mytools")
			let alltoolsTab = document.getElementById("alltools")
			mytoolsTab.style.backgroundColor = "rgb(41, 41, 41)"
			mytoolsTab.style.color = "#53A0E9"
			alltoolsTab.style.backgroundColor = "#575757"
			alltoolsTab.style.color = "#C5C5C5"
			actionMenuElement.style.display = "block"
			document.getElementById("main_action_menu").style.display = "none"
		}

		while (actionMenuElement.hasChildNodes()) {
			actionMenuElement.removeChild(actionMenuElement.firstChild)
		}

		let htmlContent = ""
		if(VECleanerInterface.savedActionData.length > 0){
			htmlContent += "<div class=\"action_list action_list_items\" style=\"display:block;\">"
			for(let i = 0; i < VECleanerInterface.savedActionData.length; i++){
				let action = VECleanerInterface.savedActionData[i]
				let g = action.g
				let a = action.a
				htmlContent += "<li><table style='margin-left:25px'><tr><th style='width:50px'><button class='fa fa-star favorite' onclick=\"VECleanerInterface.removeSaved(" + g + "," + a + ")\"></button></th><th style='width:100%'><a data-tooltip=\"" + action.description + "\" >" + VECleanerInterface.escapeString(action.name) + "</a></th><th style='width:50px'><button class='fa fa-play-circle' style='margin-right:15px;padding: 5px 10px;color: #53A0E9;' onclick=\"VECleanerInterface.runAction(" + g + "," + a + ")\"></button></th></tr></table></li>\n"
			}
			htmlContent += "</div>"
		}else{
			htmlContent += "<div style=\"display:block; font-size:20px; text-align:center; padding-top:30px; padding-left:20px; padding-right:20px;\">" + VECleanerInterface.resourceBundle.HOST_UI_Add_Tools_Hint + "</div>"
		}
		actionMenuElement.innerHTML = htmlContent
		ToolTipInit()
	}
	
	VECleanerInterface.loadAllActionList = function () {
		let actionMenuElement = document.getElementById("main_action_menu")
		let changeTab = actionMenuElement.style.display != "block"
		if(changeTab){
			let mytoolsTab = document.getElementById("mytools")
			let alltoolsTab = document.getElementById("alltools")
			mytoolsTab.style.backgroundColor = "#575757"
			mytoolsTab.style.color = "#C5C5C5"
			alltoolsTab.style.backgroundColor = "rgb(41, 41, 41)"
			alltoolsTab.style.color = "#53A0E9"

			actionMenuElement.style.display = "block"
			document.getElementById("my_action_menu").style.display = "none"
		}
		while (actionMenuElement.hasChildNodes()) {
			actionMenuElement.removeChild(actionMenuElement.firstChild)
		}
		let htmlContent = ""
		for(let g = 0; g < VECleanerInterface.actionData.length; g++){
			let group = VECleanerInterface.actionData[g]
			htmlContent += "<li class=\"action_list\"><a style='padding-left:45px;' data-tooltip=\"" + group.description + "\" class=\"fold_title\" id=\"action_list"+g+"\" onclick=\"VECleanerInterface.toggleGroup(" + g + ")\">" + VECleanerInterface.escapeString(group.name) + "</a>\n<ul class=\"action_list_items\" id=\"action_list_items"+g+"\">"
			for(let a = 0; a < group.actions.length; a++){
				let action = group.actions[a]
				let saveBtnStyle = 'fa-star-o'
				if(VECleanerInterface.isActionSaved(action)){
					saveBtnStyle = 'fa-star'
				}
				htmlContent += "<li><table style='margin-left:45px'><tr><th style='width:50px'><button class='fa " + saveBtnStyle+ " favorite' id='action_save_button_" + g + "_" + a +"' onclick=\"VECleanerInterface.toggleSaved(" + g + "," + a + ")\"></button></th><th style='width:100%'><a data-tooltip=\"" + action.description + "\">" + VECleanerInterface.escapeString(action.name) + "</a></th><th style='width:50px'><button class='fa fa-play-circle' style='margin-right:15px;padding: 5px 10px;color: #53A0E9;' onclick=\"VECleanerInterface.runAction(" + g + "," + a + ")\"></button></th></tr></table></li>\n"
			}
			htmlContent += "</ul>\n</li>\n"
		}
		actionMenuElement.innerHTML = htmlContent
		ToolTipInit()
	}

	VECleanerInterface.isActionSaved = function (act) {
		if(act){
			for(let s = 0; s < VECleanerInterface.savedActionData.length; s++){
				let action = VECleanerInterface.savedActionData[s]
				if(action.diskID ==	act.diskID){
					return true
				}
			}
		}
		return false
	}

	VECleanerInterface.saveAction = function (act) {
		if(act){
			for(let s = 0; s < VECleanerInterface.savedActionData.length; s++){
				let action = VECleanerInterface.savedActionData[s]
				if(action.diskID ==	act.diskID){
					VECleanerInterface.savedActionData.splice(s, 1); 
					localStorage.savedActions = JSON.stringify(VECleanerInterface.savedActionData)
					return false
				}
			}
	
			VECleanerInterface.savedActionData.push(act)
			localStorage.savedActions = JSON.stringify(VECleanerInterface.savedActionData)
			return true
		}
		return false
	}

	VECleanerInterface.loadSavedActions = function (allActionDatas) {
		if(localStorage.savedActions){
			let savedActions = JSON.parse(localStorage.savedActions)
			VECleanerInterface.savedActionData = []
			for(let s = 0; s < savedActions.length; s++){
				for (let a = 0; a < allActionDatas.length; a++) {
					if(allActionDatas[a].diskID == savedActions[s].diskID){
						VECleanerInterface.savedActionData.push(savedActions[s])
					}
				}
			}
		}
	}

	VECleanerInterface.init = function(){
		VECleanerInterface.interface = new CSInterface();
		VECleanerInterface.updateThemeWithAppSkinInfo()
		VECleanerInterface.resourceBundle = VECleanerInterface.interface.initResourceBundle();
		document.getElementById('mytools_title').innerHTML = VECleanerInterface.resourceBundle.HOST_UI_My_Tools
		document.getElementById('alltools_title').innerHTML = VECleanerInterface.resourceBundle.HOST_UI_All_Tools
		if(VECleanerInterface.checkResourceFiles() !== true){
			VECleanerInterface.showModal(VECleanerInterface.resourceBundle.HOST_UI_ResourceFileMissing_Title, VECleanerInterface.resourceBundle.HOST_UI_ResourceFileMissing)
		}else{
			VECleanerInterface.interface.evalScript('$.evalFile("'+ VECleanerInterface.getHostScript('Entry.jsx') +'")', function(){
				VECleanerInterface.interface.evalScript('VECleaner.kTranslator.loadData("'+ VECleanerInterface.escapeString(JSON.stringify(VECleanerInterface.resourceBundle)) +'")', function(){
					VECleanerInterface.interface.evalScript('VECleaner.Settings.InitSetting("'+ VECleanerInterface.extensionRoot() +'","' + VECleanerInterface.appScriptFolder() + '")')
					VECleanerInterface.reloadActionDatas(function(){
						VECleanerInterface.loadMyActionList()
					})
				})
			});
		}
	}

	VECleanerInterface.showModal = function(title, content){
		if (typeof(title) != "undefined" &&  typeof(content) != "undefined") {
			document.getElementById('modal-title').innerHTML = title
			document.getElementById('modal-text').innerHTML = content
		}else{
			document.getElementById('modal-title').innerHTML = VECleanerInterface.resourceBundle.HOST_UI_Processing_Modal_Title
			document.getElementById('modal-text').innerHTML = VECleanerInterface.resourceBundle.HOST_UI_Processing_Modal_Content
		}
		document.getElementById('modal').style.display = "block";
	}
	
	VECleanerInterface.hideModal = function(){
		document.getElementById('modal').style.display = "none";
	}

	VECleanerInterface.runCmd = function(cmdStr, cmdData, callback){
		if(cmdStr.indexOf("pngquant_nofile:") == 0){
			let cmd = cmdStr.slice("pngquant_nofile:".length)
			let folder = cmdData.folder.replace(/\\/g, "\/")
			let baseName = cmdData.name
			if(cmd.length > 0 && (typeof folder == "string" && folder.length > 0) && (typeof baseName == "string" && baseName.length > 0)){
				const fs = require("fs");
				let files = fs.readdirSync(folder)
				if(files.length > 0){
					let cmds = []
					let tempFolder = "C:/pngquant_temp"
					if(VECleanerInterface.isWin()){
						cmds.push("xcopy \"" + folder + "\" \""+tempFolder + "\" /e /I /Y")
					}
					for(let f = 0; f < files.length; f++){
						let name = files[f]
						if(name.lastIndexOf(".png") == name.length - 4){
							let path = tempFolder + "/" + name
							if(VECleanerInterface.isMac()){
								path = folder + "/" + name
							}
							cmds.push(cmd + '"' + path + '" --output "' + path + '"')
						}
					}
					if(VECleanerInterface.isWin()){
						cmds.push("xcopy \"" + tempFolder + "\" \""+ folder + "\" /e /I /Y")
						cmds.push("rd /s/q \"" + tempFolder + "\"")
					}

					VECleanerInterface.runCmds(cmds, cmdData, callback)
				}
			}
		}else{
			VECleanerInterface.cmd(cmdStr, callback)
		}
	}

	VECleanerInterface.runCmds = function(cmdStrArr, cmdData, callback) {
		if(cmdStrArr.length > 0){
			let cmdStr = cmdStrArr[0]
			cmdStrArr.splice(0, 1)
			if (cmdStr.length == 0){
				callback("empty cmd", null, "empty cmd")
			}else{
				VECleanerInterface.runCmd(cmdStr, cmdData, function(err,stdout,stderr){
					if(err || cmdStrArr.length == 0){
						callback(err, stdout, stderr)
					}else{
						VECleanerInterface.runCmds(cmdStrArr, cmdData, callback)
					}
				})
			}
		}
	}

	VECleanerInterface.runCmdsNew = function(cmdData, callback){
		let cmdStrArr = cmdData.cmds
		if(typeof cmdStrArr != "undefined" && cmdStrArr.length > 0){
			let cmdStr = cmdStrArr[0]
			cmdStrArr.splice(0, 1)
			if (cmdStr.length == 0){
				callback("empty cmd", null, "empty cmd")
			}else{
				VECleanerInterface.runCmd(cmdStr, cmdData, function(err,stdout,stderr){
					if(err || cmdStrArr.length == 0){
						callback(err, stdout, stderr)
					}else{
						VECleanerInterface.runCmds(cmdStrArr, cmdData, callback)
					}
				})
			}
		}
	}

	VECleanerInterface.cmd = require('child_process').exec;
	VECleanerInterface.interface = null
	VECleanerInterface.actionData = null
	VECleanerInterface.savedActionData = []
	VECleanerInterface.resourceBundle = null
	return VECleanerInterface;
}());





