function checkPassword(value)
{
	try{

		// document.getElementById('next').disabled = false;
		//showMessage('tips', '');

		var psw = document.getElementById('password');
		var repsw = document.getElementById('repassword');
		var psw1 = psw.value.trim();
		var psw2 = repsw.value.trim();
		if (psw1.length < 6 || psw1.length > 64) {
			//showMessage('tips', '密码长度必须6到64位');
			uiShowBlockMsg('密码长度必须6到64位', undefined, 1500);
			//document.getElementById('next').disabled = true;
			return false;
		}
		else if (psw1 != psw2) {
			//showMessage('tips', '两次输入的密码不一致');
			uiShowBlockMsg('两次输入的密码不一致', undefined, 1500);
			//document.getElementById('next').disabled = true;
			return false;
		}

	}catch(e){
		uiDismissBlockMsg();
		return false;
	}
	return true;

};


var APIFactory = new APIFactory_Sim();
var VDiskAPI = APIFactory.getVDiskAPI();
var AccountAPI = APIFactory.getAccountAPI();
var FacilityAPI = APIFactory.getFacilityAPI();


$(document).ready(function(){
	$("#prestep").hide();
	$(":input").keydown(function(event) {
		if(13 == event.which) {
			$("#next").click();
		}
	});
});

document.getElementById('next').onclick = function() {
	try{
		//获取传递到当前页面的参数
		var jsonString= FacilityAPI.getViewParam();
		var getjson=JSON.parse(jsonString);
		//var getjson = {account:"18900000000@189.cn", fsType:"NTFS", size:1024, path:"c:\\image.bin"};
		var account = AccountAPI.getLoggedInAccount();
		var fsType =getjson.fsType;
		var size=parseInt(getjson.size);
		var path=getjson.path; //选择的分区

		//先判定前置条件：未绑定本地同步文件夹
		var accountjosnString=AccountAPI.getBindHistory();
		var accountjson=JSON.parse(accountjosnString);
		for(var i=0;i<accountjson.length;i++){
			if((account==accountjson[i].account)&&(accountjson[i].syncFolder!=null)){
				var description="已绑定本地同步文件夹";
				uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
				return false;
			}
		}
		var needPassword=0;
		var password = "";
		if($("#needpwd-radio")[0].checked) {
			needPassword = 1;
			if(!checkPassword()) {
				return false;
			}
			password = document.getElementById('password').value;
		}
		
		var  json={
			'account':'',
			'path':'',
			'needPassword':'',
			'password':password
		};

		json.account = account;
		json.path=path;
		json.needPassword = needPassword;
		var jsonString=JSON.stringify(json);
		FacilityAPI.manageView(4);
		uiShowBlockMsg("正在创建加密磁盘，请稍候");
		//创建虚拟加密磁盘接口
		VDiskAPI.tryCreateVDisk(path, password, fsType, size, 'onCreateVDisk', jsonString);
		//showIndicator(showIndicatorId);


	}catch(e){
		uiDismissBlockMsg();
		FacilityAPI.manageView(3);
	}

};

function onCreateVDisk(errCode, result, tag){
	FacilityAPI.manageView(3);
	uiDismissBlockMsg();
	try{
		//disableIndicator(showIndicatorId);
		var tagjson=JSON.parse(tag);
		var account=tagjson.account;
		var needPassword=tagjson.needPassword;
		var syncFolder=tagjson.path;
		var password = tagjson.password;
		if(0==errCode){
			//绑定用户同步设置信息
			var resultjson=JSON.parse(result);
			var cryptFile=resultjson.cryptFile;
			//AccountAPI.bindSyncSetting(account,syncFolder, cryptFile, needPassword);
			var tagjson={
				'account':'',
				'syncFolder':'',
				'cryptFile':'',
				'needPassword':''
			};
			tagjson.account=account;
			tagjson.syncFolder=syncFolder;
			tagjson.cryptFile=cryptFile;
			tagjson.needPassword=needPassword;
			var tagString=JSON.stringify(tagjson);

			//挂载虚拟加密磁盘接口
			uiShowBlockMsg('正在挂载虚拟磁盘，请稍候！');
			VDiskAPI.tryMountVDisk(cryptFile, password, 'onMountVDisk', tagString);
			//showIndicator(showIndicatorId);
		}else{
			var description=getDescription(errCode);
			uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
			return false;
		}

	}catch(e){ }
	};

	function onMountVDisk(errCode, result, tag){
		uiDismissBlockMsg();
		try{
			//disableIndicator(showIndicatorId);
			if(0==errCode){
				//绑定用户同步设置信息
				var tagjson=JSON.parse(tag);
				var account=tagjson.account;
				var syncFolder=tagjson.syncFolder;
				var cryptFile=tagjson.cryptFile;
				var needPassword=tagjson.needPassword;
				//AccountAPI.bindSyncSetting(account,'', cryptFile, needPassword);
				//关闭
				FacilityAPI.manageView(1);
			}else{
				var description=getDescription(errCode);
				uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
				return false;
			}
		}catch(e){

		}


	};


	document.getElementById('prestep').onclick = function(){
		try{
			var jsonString= FacilityAPI.getViewParam();
			var getjson=JSON.parse(jsonString);
			//用户名
			var account =getjson.account;
			//用户ID
			var userId =getjson.userId;
			//虚拟盘的文件系统类型。取值”NTFS”或”FAT32”
			var fsType =getjson.fsType;
			//映像文件路径
			var cryptFile=getjson.cryptFile;
			var  json={
				'account':'',
				'userId':'',
				'fsType':'',
				'cryptFile':''
			}

			json.account = account;
			json.userId=userId;
			json.fsType = fsType;
			json.cryptFile=cryptFile;
			var jsonString=JSON.stringify(json);
			//页面跳转
			var errorcode=FacilityAPI.redirectToView('wizard/select_syncpath.html',-1,-1,-1,-1,jsonString);
			if(errorcode!=0){
				var description=getDescription(errorcode);
				uiShowBlockMsg('错误信息提示:'+description, undefined, 1500);
				return false;
				//var newwin= window.showModalDialog('../error.html',description,'dialogWidth=100px;dialogHeight=100px;help=no');
				//setTimeout('window.newwin.close()','5000');
			}

		}catch(e){

		}

	};