var enterEvents = {};


//允许被选择的控件列表
var allowedControls = {
    'TEXTAREA': 1,
    'INPUT': 1
};

//网页控件屏蔽
document.oncontextmenu = function(){//屏蔽右键菜单
    allowSelected = 1 == allowedControls[event.srcElement.tagName] ? true : false;
    event.returnValue = allowSelected;
}
document.onselectstart = function()//屏蔽控件选中
{
    //允许被选择的控件列表
    allowSelected = 1 == allowedControls[event.srcElement.tagName] ? true : false;
    event.returnValue = allowSelected;
}
document.onkeydown = function(){
    keyCodeOfF5 = 116 == window.event.keyCode;//F5键
    keyCodeOfF11 = 122 == window.event.keyCode;//F11键
    keyCodeOfF = 70 == window.event.keyCode;//组合键CTR + F
    keyCodeOfN = 78 == window.event.keyCode;//组合键CTR + N
    keyCodeOfO = 79 == window.event.keyCode;//组合键CTR + O
    keyCodeOfP = 80 == window.event.keyCode;//组合键CTR + P
    keyCodeOfLeft = 37 == window.event.keyCode;//组合键ALT + <-
    keyCodeOfRight = 39 == window.event.keyCode;//组合键ALT + ->
    keyCodeOfEnter = 13 == window.event.keyCode;//回车键
    keyCodeOfBackSpace = 8 == window.event.keyCode;//回退删除键
    if (keyCodeOfF5 ||
    keyCodeOfF11 ||
    window.event.ctrlKey && (keyCodeOfN || keyCodeOfO || keyCodeOfP || keyCodeOfF) ||
    window.event.altKey && (keyCodeOfLeft || keyCodeOfRight)) {
        window.event.keyCode = 0;
        window.event.returnValue = false;
    }
    else 
        if (keyCodeOfBackSpace) {
            window.event.returnValue = 1 == allowedControls[event.srcElement.tagName];
        }
        else 
            if (keyCodeOfEnter) {//回车事件处理            	
                FireEnterEvent(window.event.srcElement);
            }
}
//网页控件屏蔽--end

//通用处理函数
String.prototype.trim = function(){
    return this.replace(/\s+$|^\s+/g, '');
}

function isValidMail(email) {
	var filter = /^(?:[a-zA-Z0-9]+[_\-\+\.]?)*[a-zA-Z0-9]+@(?:([a-zA-Z0-9]+[_\-]?)*[a-zA-Z0-9]+\.)+([a-zA-Z]{2,})+$/;
	return filter.test(email);
}

function isValidMobile(mobile){
	var filter=/^[1][358]\d{9}$/;
	return filter.test(mobile);
}

function isVersion(version){
    return /^(\d{1,4}\.){1,4}\d{1,4}$/.test(version.trim())
}

function isWindowsPath(path){
    return /^[a-z]:\\([^\\\/:*?"<>|\r\n\t]+\\?)*$/i.test(path)
}

function getDomById(divId){
    return document.getElementById(divId)
}


//绑定节点的css样式
function setStyle(divId, styles){
    domNode = getDomById(divId);
    for (styleEvent in styles) {
        setDomCss(domNode, styleEvent, styles[styleEvent]);
    }
}

function setDomCss(domNode, domEvent, cssClass){
    if (domNode && domNode.attachEvent) {
        domNode.attachEvent(domEvent, function(){
            domNode.className = cssClass;
        });
    }
}

//事件绑定
function bindEvent(bindList){
    for (var divId in bindList) {
        var eventName = bindList[divId][0];
        var action = bindList[divId][1];
        getDomById(divId).attachEvent(eventName, action);
    }
}

//回车键绑定
/** 
 * @param {string} divId
 */
function registerEnterEvent(type, DivId){
    enterEvents[DivId] = type;
}

function FireEnterEvent(targetControl){
    for (var divKey in enterEvents) {
        if ('undefined' != getDomById(divKey).isHide && true == getDomById(divKey).isHide) {
            continue;
        }
        
        if ('limit' == enterEvents[divKey]) {
            if ('button_focus' != targetControl.className) {
                return;
            }
        }
        window.event.returnValue = false;
        window.event.cancel = true;
        getDomById(divKey).fireEvent('onclick');
        return;
    }
}

//光标移动到text末尾
function moveTextTail(obj)
{
	if(obj){
		obj.onfocus = function(){
			var len = this.value.length;
			var rng = this.createTextRange();
			rng.moveStart("character", len);
			rng.collapse(true);
			rng.select();
		}
	}
}
//显示进度图标
function  showIndicator(id){
    var obj=getDomById(id);
	obj.style.display=block;
  
}
//不显示进度图标
function   disableIndicator(id){
    var obj=getDomById(id);
	obj.style.display=none;
  
}
//获取json 长度
function getJsonLength(json){
	var len=0;
	if(Boolean(json)){
		for(i in json)len++;
	}
	return len;
}
//由错误码获得描述
   function getDescription(code){
     var description ='操作失败';
	 if(0==code){ description="操作成功";}
   else if(-1==code){ description="请求失败";}
	 else if(-2==code){ description="操作被取消";}
	 else if(-3==code){ description="连接服务器失败";}
	 else if(-4==code){ description="网络连接被断开";}
	 else if(-5==code){ description="操作超时";}
	 else if(-6==code){ description="数据大小超出允许范围";}
	 else if(-7==code){ description="用户未登录";}
	 else if(-8==code){ description="密码不正确";}
	 else if(-9==code){ description="参数不正确";}
	 else if(-10==code){ description="磁盘空间不足";}
	 else if(-12==code){ description="没有权限";}
	 else if(-13==code){ description="数据访问错误";}
	 else if(-14==code){ description="此用户不存在或未激活"; }
    return description;
   }
  //由服务器响应码获得描述
    function getResDescription(code){
	 var description ='请求失败';
	 if("FileAlreadyExists"==code){ description="文件或文件夹已存在";}
	 else if("FileNotFound"==code){ description="文件或文件夹不存在";}
	 else if("FileTooLarge"==code){ description="上传文件超过最大限制";}
	 else if("InternalError"==code){ description="内部错误";}
	 else if("InvalidArgument"==code){ description="非法参数";}
	 else if("InvalidPassword"==code){ description="密码不正确";}
	 else if("InvalidSessionKey"==code){ description="非法登录会话Key";}
	 else if("InvalidSignature"==code){ description="非法签名";}
	 else if("NoSuchUser"==code){ description="此用户不存在或未激活";}
	 else if("ParentNotFolder"==code){ description="父文件夹类型不正确";}
	 return description;
	}
	
	function getReadableSize(rawBytesSize) {
		if(rawBytesSize < 1024) {
			return rawBytesSize+'B';
		}
		else if(rawBytesSize < 1048576) {
			// KB
			return (Number(rawBytesSize/1024).toFixed(2) + 'KB');
		}
		else if(rawBytesSize < 1073741824) {
			// MB
			return (Number(rawBytesSize/1048576).toFixed(2) + 'MB');
		}
		// GB
		return (Number(rawBytesSize/1073741824).toFixed(2) + 'GB');
	}