#ifndef ZOMBIE_MODE_H
#define ZOMBIE_MODE_H

#include "scenario.h"
#include "standard-skillcards.h"
#include "maneuvering.h"

class ZombieScenario : public Scenario{
    Q_OBJECT

public:
    explicit ZombieScenario();

    virtual bool exposeRoles() const;
    virtual void assign(QStringList &generals, QStringList &roles) const;
    virtual int getPlayerCount() const;
    virtual void getRoles(char *roles) const;
    virtual bool generalSelection() const;
    virtual AI::Relation relationTo(const ServerPlayer *a, const ServerPlayer *b) const;

private:
    QStringList females;
};

class GanranEquip: public IronChain{
    Q_OBJECT

public:
    Q_INVOKABLE GanranEquip(Card::Suit suit, int number);
};

class PeachingCard: public QingnangCard{
    Q_OBJECT

public:
    Q_INVOKABLE PeachingCard();
    virtual bool targetFilter(const QList<const Player *> &targets, const Player *to_select, const Player *Self) const;
};


#endif // ZOMBIE_MODE_H
