BEGIN TRANSACTION;
CREATE TABLE "gongxun"([level] int(11) NOT NULL,[name] varchar(20) NOT NULL,[score] int(11) NOT NULL,[category] varchar(10) NOT NULL, Primary Key(level,category) ON CONFLICT Ignore);
CREATE TABLE "skills"([skillname] varchar(20) NOT NULL,[gained] int(11) NOT NULL,[used] int(11) NOT NULL, Primary Key(skillname) ON CONFLICT Ignore);
CREATE TABLE "gamedata"([id] varchar(20) NOT NULL,[num] int(11) NOT NULL, Primary Key(id) ON CONFLICT Ignore);
CREATE TABLE "zhangong"([id] varchar(10) NOT NULL,[name] varchar(30) NOT NULL,[score] int(11) NOT NULL,[description] varchar(250) NOT NULL,[gained] int(11) NOT NULL,[category] varchar(20) NOT NULL,[lasttime] datetime NOT NULL,[general] varchar(40) NOT NULL,[num] int(11) NOT NULL,[count] int(11) NOT NULL, Primary Key(id) ON CONFLICT Ignore);
CREATE TABLE "results"([id] int(11) NOT NULL,[general] varchar(30) NOT NULL,[role] varchar(10) NOT NULL,[kingdom] varchar(10) NOT NULL,[hegemony] int(11) NOT NULL,[mode] varchar(10) NOT NULL,[turncount] int(11) NOT NULL,[alive] int(11) NOT NULL,[result] varchar(10) NOT NULL,[wen] int(11) NOT NULL,[wu] int(11) NOT NULL,[expval] int(11) NOT NULL,[zhangong] varchar(255) NOT NULL, Primary Key(id) ON CONFLICT Ignore);
CREATE TABLE "zgcard"([id] varchar(20) NOT NULL,[gained] int(11) NOT NULL,[used] int(11) NOT NULL, Primary Key(id) ON CONFLICT Ignore);
CREATE INDEX [gamedata_num] On [gamedata] ([num] );
CREATE INDEX [results_result] On [results] ([result]);
CREATE INDEX [results_role] On [results] ([role]);
CREATE INDEX [results_general] On [results] ([general]);
CREATE INDEX [results_kingdom] On [results] ([kingdom]);
CREATE INDEX [results_hegemony] On [results] ([hegemony]);
CREATE INDEX [results_mode] On [results] ([mode]);
CREATE INDEX [gongxun_score] On [gongxun] ([score]);
CREATE INDEX [gongxun_category] On [gongxun] ([category]);
CREATE INDEX [zhangong_category] On [zhangong] ([category]);
CREATE INDEX [zhangong_general] On [zhangong] ([general]);
CREATE INDEX [zhangong_num] On [zhangong] ([num]);
CREATE INDEX [skills_gained] On [skills] ([gained]);
CREATE INDEX [skills_used] On [skills] ([used]);
INSERT INTO "zgcard"  VALUES('luckycard',100,0);
INSERT INTO "gongxun" VALUES(0, '平民', 0, 'wen');
INSERT INTO "gongxun" VALUES(1, '里长', 100, 'wen');
INSERT INTO "gongxun" VALUES(2, '亭长', 300, 'wen');
INSERT INTO "gongxun" VALUES(3, '蔷夫', 600, 'wen');
INSERT INTO "gongxun" VALUES(4, '县尉', 1000, 'wen');
INSERT INTO "gongxun" VALUES(5, '郎中', 1500, 'wen');
INSERT INTO "gongxun" VALUES(6, '侍郎', 2100, 'wen');
INSERT INTO "gongxun" VALUES(7, '县丞', 2800, 'wen');
INSERT INTO "gongxun" VALUES(8, '县长', 3600, 'wen');
INSERT INTO "gongxun" VALUES(9, '博士', 4500, 'wen');
INSERT INTO "gongxun" VALUES(10, '议郎', 5500, 'wen');
INSERT INTO "gongxun" VALUES(11, '中郎', 6600, 'wen');
INSERT INTO "gongxun" VALUES(12, '谒者', 7800, 'wen');
INSERT INTO "gongxun" VALUES(13, '郡长史', 9100, 'wen');
INSERT INTO "gongxun" VALUES(14, '州刺史', 10500, 'wen');
INSERT INTO "gongxun" VALUES(15, '郡太守丞', 12000, 'wen');
INSERT INTO "gongxun" VALUES(16, '谏大夫', 13600, 'wen');
INSERT INTO "gongxun" VALUES(17, '太常丞', 15300, 'wen');
INSERT INTO "gongxun" VALUES(18, '光禄丞', 17100, 'wen');
INSERT INTO "gongxun" VALUES(19, '卫尉丞', 19000, 'wen');
INSERT INTO "gongxun" VALUES(20, '太仆丞', 21000, 'wen');
INSERT INTO "gongxun" VALUES(21, '大鸿胪丞', 23100, 'wen');
INSERT INTO "gongxun" VALUES(22, '宗正丞', 25300, 'wen');
INSERT INTO "gongxun" VALUES(23, '大司农丞', 27600, 'wen');
INSERT INTO "gongxun" VALUES(24, '少府丞', 30000, 'wen');
INSERT INTO "gongxun" VALUES(25, '太中大夫', 32500, 'wen');
INSERT INTO "gongxun" VALUES(26, '谒者仆射', 35100, 'wen');
INSERT INTO "gongxun" VALUES(27, '廷尉正监', 37800, 'wen');
INSERT INTO "gongxun" VALUES(28, '中常侍', 40600, 'wen');
INSERT INTO "gongxun" VALUES(29, '尚书令', 43500, 'wen');
INSERT INTO "gongxun" VALUES(30, '御史中丞', 46500, 'wen');
INSERT INTO "gongxun" VALUES(31, '司徒长史', 49600, 'wen');
INSERT INTO "gongxun" VALUES(32, '太尉长史', 52800, 'wen');
INSERT INTO "gongxun" VALUES(33, '司空长史', 56100, 'wen');
INSERT INTO "gongxun" VALUES(34, '丞相司直', 59500, 'wen');
INSERT INTO "gongxun" VALUES(35, '光禄大夫', 63000, 'wen');
INSERT INTO "gongxun" VALUES(36, '侍中', 66600, 'wen');
INSERT INTO "gongxun" VALUES(37, '州牧', 70300, 'wen');
INSERT INTO "gongxun" VALUES(38, '郡太守', 74100, 'wen');
INSERT INTO "gongxun" VALUES(39, '执金吾', 78000, 'wen');
INSERT INTO "gongxun" VALUES(40, '太常', 82000, 'wen');
INSERT INTO "gongxun" VALUES(41, '光禄勋', 86100, 'wen');
INSERT INTO "gongxun" VALUES(42, '卫尉', 90300, 'wen');
INSERT INTO "gongxun" VALUES(43, '太仆', 94600, 'wen');
INSERT INTO "gongxun" VALUES(44, '廷尉', 99000, 'wen');
INSERT INTO "gongxun" VALUES(45, '大鸿胪', 103500, 'wen');
INSERT INTO "gongxun" VALUES(46, '宗正', 108100, 'wen');
INSERT INTO "gongxun" VALUES(47, '司徒', 112800, 'wen');
INSERT INTO "gongxun" VALUES(48, '太尉', 117600, 'wen');
INSERT INTO "gongxun" VALUES(49, '司空', 122500, 'wen');
INSERT INTO "gongxun" VALUES(50, '丞相', 127500, 'wen');
INSERT INTO "gongxun" VALUES(0, '平民', 0, 'wu');
INSERT INTO "gongxun" VALUES(1, '兵卒', 100, 'wu');
INSERT INTO "gongxun" VALUES(2, '屯长', 300, 'wu');
INSERT INTO "gongxun" VALUES(3, '军侯', 600, 'wu');
INSERT INTO "gongxun" VALUES(4, '军司马', 1000, 'wu');
INSERT INTO "gongxun" VALUES(5, '都尉', 1500, 'wu');
INSERT INTO "gongxun" VALUES(6, '校尉', 2100, 'wu');
INSERT INTO "gongxun" VALUES(7, '中郎将', 2800, 'wu');
INSERT INTO "gongxun" VALUES(8, '裨将军', 3600, 'wu');
INSERT INTO "gongxun" VALUES(9, '偏将军', 4500, 'wu');
INSERT INTO "gongxun" VALUES(10, '牙门将军', 5500, 'wu');
INSERT INTO "gongxun" VALUES(11, '伏波将军', 6600, 'wu');
INSERT INTO "gongxun" VALUES(12, '翊武将军', 7800, 'wu');
INSERT INTO "gongxun" VALUES(13, '翊师将军', 9100, 'wu');
INSERT INTO "gongxun" VALUES(14, '建威将军', 10500, 'wu');
INSERT INTO "gongxun" VALUES(15, '建武将军', 12000, 'wu');
INSERT INTO "gongxun" VALUES(16, '振威将军', 13600, 'wu');
INSERT INTO "gongxun" VALUES(17, '振武将军', 15300, 'wu');
INSERT INTO "gongxun" VALUES(18, '领军将军', 17100, 'wu');
INSERT INTO "gongxun" VALUES(19, '护军将军', 19000, 'wu');
INSERT INTO "gongxun" VALUES(20, '武卫将军', 21000, 'wu');
INSERT INTO "gongxun" VALUES(21, '中垒将军', 23100, 'wu');
INSERT INTO "gongxun" VALUES(22, '镇军将军', 25300, 'wu');
INSERT INTO "gongxun" VALUES(23, '抚军将军', 27600, 'wu');
INSERT INTO "gongxun" VALUES(24, '镇国将军', 30000, 'wu');
INSERT INTO "gongxun" VALUES(25, '龙骧将军', 32500, 'wu');
INSERT INTO "gongxun" VALUES(26, '平东将军', 35100, 'wu');
INSERT INTO "gongxun" VALUES(27, '平南将军', 37800, 'wu');
INSERT INTO "gongxun" VALUES(28, '平西将军', 40600, 'wu');
INSERT INTO "gongxun" VALUES(29, '平北将军', 43500, 'wu');
INSERT INTO "gongxun" VALUES(30, '安东将军', 46500, 'wu');
INSERT INTO "gongxun" VALUES(31, '安南将军', 49600, 'wu');
INSERT INTO "gongxun" VALUES(32, '安西将军', 52800, 'wu');
INSERT INTO "gongxun" VALUES(33, '安北将军', 56100, 'wu');
INSERT INTO "gongxun" VALUES(34, '镇东将军', 59500, 'wu');
INSERT INTO "gongxun" VALUES(35, '镇南将军', 63000, 'wu');
INSERT INTO "gongxun" VALUES(36, '镇西将军', 66600, 'wu');
INSERT INTO "gongxun" VALUES(37, '镇北将军', 70300, 'wu');
INSERT INTO "gongxun" VALUES(38, '征东将军', 74100, 'wu');
INSERT INTO "gongxun" VALUES(39, '征南将军', 78000, 'wu');
INSERT INTO "gongxun" VALUES(40, '征西将军', 82000, 'wu');
INSERT INTO "gongxun" VALUES(41, '征北将军', 86100, 'wu');
INSERT INTO "gongxun" VALUES(42, '前将军', 90300, 'wu');
INSERT INTO "gongxun" VALUES(43, '后将军', 94600, 'wu');
INSERT INTO "gongxun" VALUES(44, '左将军', 99000, 'wu');
INSERT INTO "gongxun" VALUES(45, '右将军', 103500, 'wu');
INSERT INTO "gongxun" VALUES(46, '骠骑将军', 108100, 'wu');
INSERT INTO "gongxun" VALUES(47, '车骑将军', 112800, 'wu');
INSERT INTO "gongxun" VALUES(48, '卫将军', 117600, 'wu');
INSERT INTO "gongxun" VALUES(49, '安国将军', 122500, 'wu');
INSERT INTO "gongxun" VALUES(50, '大将军', 127500, 'wu');
INSERT INTO "skills" VALUES('zhiyu', 0, 0);
INSERT INTO "skills" VALUES('miji', 0, 0);
INSERT INTO "skills" VALUES('anxu', 0, 0);
INSERT INTO "skills" VALUES('jiangchi', 0, 0);
INSERT INTO "skills" VALUES('zishou', 0, 0);
INSERT INTO "skills" VALUES('zongshi', 0, 0);
INSERT INTO "skills" VALUES('lihuo', 0, 0);
INSERT INTO "skills" VALUES('mashu', 0, 0);
INSERT INTO "skills" VALUES('kuanggu', 0, 0);
INSERT INTO "skills" VALUES('liegong', 0, 0);
INSERT INTO "skills" VALUES('shensu', 0, 0);
INSERT INTO "skills" VALUES('hongyuan', 0, 0);
INSERT INTO "skills" VALUES('mingzhe', 0, 0);
INSERT INTO "skills" VALUES('wansha', 0, 0);
INSERT INTO "skills" VALUES('yinghun', 0, 0);
INSERT INTO "skills" VALUES('weimu', 0, 0);
INSERT INTO "skills" VALUES('roulin', 0, 0);
INSERT INTO "skills" VALUES('zaiqi', 0, 0);
INSERT INTO "skills" VALUES('haoshi', 0, 0);
INSERT INTO "skills" VALUES('dimeng', 0, 0);
INSERT INTO "skills" VALUES('xingshang', 0, 0);
INSERT INTO "skills" VALUES('fangzhu', 0, 0);
INSERT INTO "skills" VALUES('duanliang', 0, 0);
INSERT INTO "skills" VALUES('lieren', 0, 0);
INSERT INTO "skills" VALUES('longdan', 0, 0);
INSERT INTO "skills" VALUES('qicai', 0, 0);
INSERT INTO "skills" VALUES('tieji', 0, 0);
INSERT INTO "skills" VALUES('wushuang', 0, 0);
INSERT INTO "skills" VALUES('tiandu', 0, 0);
INSERT INTO "skills" VALUES('guose', 0, 0);
INSERT INTO "skills" VALUES('zhiheng', 0, 0);
INSERT INTO "skills" VALUES('lijian', 0, 0);
INSERT INTO "skills" VALUES('biyue', 0, 0);
INSERT INTO "skills" VALUES('ganglie', 0, 0);
INSERT INTO "skills" VALUES('qianxun', 0, 0);
INSERT INTO "skills" VALUES('wusheng', 0, 0);
INSERT INTO "skills" VALUES('qingguo', 0, 0);
INSERT INTO "skills" VALUES('fankui', 0, 0);
INSERT INTO "skills" VALUES('jianxiong', 0, 0);
INSERT INTO "skills" VALUES('guanxing', 0, 0);
INSERT INTO "skills" VALUES('tuxi', 0, 0);
INSERT INTO "skills" VALUES('yingzi', 0, 0);
INSERT INTO "skills" VALUES('fanjian', 0, 0);
INSERT INTO "skills" VALUES('dahe', 0, 0);
INSERT INTO "skills" VALUES('yanzheng', 0, 0);
INSERT INTO "skills" VALUES('tanhu', 0, 0);
INSERT INTO "skills" VALUES('yanxiao', 0, 0);
INSERT INTO "skills" VALUES('anxian', 0, 0);
INSERT INTO "skills" VALUES('jilei', 0, 0);
INSERT INTO "skills" VALUES('danlao', 0, 0);
INSERT INTO "skills" VALUES('weidi', 0, 0);
INSERT INTO "skills" VALUES('yicong', 0, 0);
INSERT INTO "skills" VALUES('mengjin', 0, 0);
INSERT INTO "skills" VALUES('xiuluo', 0, 0);
INSERT INTO "skills" VALUES('shenwei', 0, 0);
INSERT INTO "skills" VALUES('shenji', 0, 0);
INSERT INTO "skills" VALUES('zhulou', 0, 0);
INSERT INTO "skills" VALUES('tannang', 0, 0);
INSERT INTO "skills" VALUES('neofanjian', 0, 0);
INSERT INTO "skills" VALUES('yishi', 0, 0);
INSERT INTO "skills" VALUES('enyuan', 0, 0);
INSERT INTO "skills" VALUES('xuanhuo', 0, 0);
INSERT INTO "skills" VALUES('xianzhen', 0, 0);
INSERT INTO "skills" VALUES('xuanfeng', 0, 0);
INSERT INTO "skills" VALUES('yizhong', 0, 0);
INSERT INTO "skills" VALUES('shangshi', 0, 0);
INSERT INTO "skills" VALUES('ganlu', 0, 0);
INSERT INTO "skills" VALUES('luoying', 0, 0);
INSERT INTO "skills" VALUES('jujian', 0, 0);
INSERT INTO "skills" VALUES('xinzhan', 0, 0);
INSERT INTO "skills" VALUES('zhichi', 0, 0);
INSERT INTO "skills" VALUES('mingce', 0, 0);
INSERT INTO "skills" VALUES('pojun', 0, 0);
INSERT INTO "skills" VALUES('qiangxi', 0, 0);
INSERT INTO "skills" VALUES('lianhuan', 0, 0);
INSERT INTO "skills" VALUES('tianyi', 0, 0);
INSERT INTO "skills" VALUES('bazhen', 0, 0);
INSERT INTO "skills" VALUES('quhu', 0, 0);
INSERT INTO "skills" VALUES('luanji', 0, 0);
INSERT INTO "skills" VALUES('feiying', 0, 0);
INSERT INTO "skills" VALUES('qinyin', 0, 0);
INSERT INTO "skills" VALUES('juejing', 0, 0);
INSERT INTO "skills" VALUES('shelie', 0, 0);
INSERT INTO "skills" VALUES('gongxin', 0, 0);
INSERT INTO "skills" VALUES('jiang', 0, 0);
INSERT INTO "skills" VALUES('guzheng', 0, 0);
INSERT INTO "skills" VALUES('zhijian', 0, 0);
INSERT INTO "skills" VALUES('tiaoxin', 0, 0);
INSERT INTO "skills" VALUES('xiangle', 0, 0);
INSERT INTO "skills" VALUES('fangquan', 0, 0);
INSERT INTO "skills" VALUES('nosenyuan', 0, 0);
INSERT INTO "skills" VALUES('jueqing', 0, 0);
INSERT INTO "skills" VALUES('yiji', 0, 0);
INSERT INTO "skills" VALUES('liuli', 0, 0);
INSERT INTO "skills" VALUES('neoganglie', 0, 0);
INSERT INTO "skills" VALUES('beige', 0, 0);
INSERT INTO "skills" VALUES('zhiji', 0, 0);
INSERT INTO "skills" VALUES('zhiba', 0, 0);
INSERT INTO "skills" VALUES('nosxuanhuo', 0, 0);
INSERT INTO "skills" VALUES('juxiang', 0, 0);
INSERT INTO "gamedata" VALUES('bszj', 0);
INSERT INTO "gamedata" VALUES('yqt', 0);
INSERT INTO "gamedata" VALUES('gddph', 0);
INSERT INTO "gamedata" VALUES('ph', 0);
INSERT INTO "zhangong" VALUES('ccml', '初出茅庐', 3, '进行1局游戏后', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('csss', '初试身手', 5, '进行5局游戏后', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('xsnd', '小试牛刀', 8, '进行10局游戏', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('xymq', '小有名气', 10, '进行20局游戏', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('fmbl', '锋芒毕露', 15, '进行30局游戏', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ccsg', '初尝胜果', 3, '获得1局胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 1, 0);
INSERT INTO "zhangong" VALUES('cjss', '初级杀手', 5, '获得5局胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 5, 0);
INSERT INTO "zhangong" VALUES('zjss', '中级杀手', 8, '获得10局胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 10, 0);
INSERT INTO "zhangong" VALUES('gjss', '高级杀手', 10, '获得20局胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 20, 0);
INSERT INTO "zhangong" VALUES('qzss', '全职杀手', 15, '获得30局胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 30, 0);
INSERT INTO "zhangong" VALUES('mbgj', '命不该绝', 3, '被闪电劈中但是没有死', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('lczz', '乱臣贼子', 3, '身为反贼在1局游戏中，手刃至少2个忠臣或内奸', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('cdzx', '赤胆忠心', 5, '身为忠臣在1局游戏中，手刃至少2个反贼或内奸', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('hydt', '鸿运当头', 5, '在1个回合内使用至少3次无中生有', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('pfdj', '平反大将', 4, '在1局游戏中手刃4个反贼', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('bgws', '秉公无私', 4, '身为主公在一局游戏中从未对忠臣造成伤害，并取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('tq', '天谴', 4, '不被改判定牌的情况下被闪电劈死', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('lsch', '辣手摧花', 10, '一局游戏中杀死至少2名女性角色', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('djyd', '打酱油的', 3, '在1局游戏中，在自己的回合开始前就死亡', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('xbtc', '先拔头筹', 10, '一局游戏中，自己的首回合结束前杀死至少一名非本方武将', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('wwdz', '唯我独尊', 10, '身为内奸取得1次胜利', 0, 'zhonghe', '1999-12-31 00:00:00', 'renegade', 1, 0);
INSERT INTO "zhangong" VALUES('srxsm', '射人先射马', 10, '一局游戏中发动麒麟弓特效至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('srpz', '势如破竹', 10, '一局游戏中发动贯石斧特效至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('shd', '杀很大', 10, '一回合中发动诸葛连弩特效至少4次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jdld', '绝对零度', 10, '一局游戏中发动寒冰剑特效至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('dqbr', '刀枪不入', 10, '一局游戏中发动仁王盾特效3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('gycc', '苟延残喘', 5, '在1局游戏中被救活至少5次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('hsqj', '横扫千军', 8, '在1局游戏中，手刃7名角色并且获得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('qkds', '旗开得胜', 10, '一局游戏中，在自己的首回合结束前获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('cxer', '趁虚而入', 8, '身为反贼在1局游戏中，在自己的第1回合时手刃主公', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zgyd', '忠肝义胆', 7, '身为忠臣在1局游戏中存活，并且主公满体力的情况下取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jlsj', '极乐世界', 5, '在1局游戏中，累计3次被乐不思蜀后判定牌都是红桃', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('alg', '安乐公', 5, '在1局游戏中，累计3次被乐不思蜀后判定牌都不是红桃', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ph', '炮灰', 5, '被南蛮入侵或万箭齐发打死累计10次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('gddph', '更大的炮灰', 10, '被南蛮入侵或万箭齐发打死累计50次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('yqt', '一骑讨', 15, '与人决斗胜利累计30次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('lmss', '老谋深算', 15, '身为内奸在1局游戏中手刃至少4个反贼或忠臣并且取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('tdwy', '天道威仪', 7, '身为主公在1局游戏中，在忠臣全部死亡后杀死至少3名角色，取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('tw', '桃王', 5, '在1局游戏中给自己吃过5个或者更多得桃（不包括华佗的技能）', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('tx', '桃仙', 5, '在1局游戏中，使用桃救人至少5次（不包括华佗的技能）', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('bmjs', '八门金锁', 7, '在1局游戏中，装备八卦阵连续判定红色花色至少5次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jzjz', '竭智尽忠', 8, '身为忠臣在1局游戏中，在自己的首回合中手刃一个反贼或内奸，最后取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zxgg', '忠心耿耿', 12, '身为忠臣取得胜利累计60次', 0, 'zhonghe', '1999-12-31 00:00:00', 'loyalist', 60, 0);
INSERT INTO "zhangong" VALUES('jcfs', '绝处逢生', 8, '身为反贼在1局游戏中，在其他反贼全部死亡且忠臣全部存活的情况下获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('cttz', '草头天子', 12, '身为反贼取得胜利累计100次', 0, 'zhonghe', '1999-12-31 00:00:00', 'rebel', 100, 0);
INSERT INTO "zhangong" VALUES('yzzf', '异族之愤', 5, '使用1次南蛮入侵打死至少3名角色', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jwxf', '箭无虚发', 5, '使用1次万箭齐发打死至少3名角色', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zszm', '至圣至明', 8, '身为主公在一局游戏中手刃所有反贼和内奸，并在忠臣全部存活的情况下获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jltx', '君临天下', 12, '身为主公取得胜利累计40次', 0, 'zhonghe', '1999-12-31 00:00:00', 'lord', 40, 0);
INSERT INTO "zhangong" VALUES('ljjh', '老奸巨猾', 10, '身为内奸在1局游戏中，在主公杀死过忠臣的情况下取得胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ycww', '运筹帷幄', 10, '身为内奸取得胜利累计20次', 0, 'zhonghe', '1999-12-31 00:00:00', 'renegade', 20, 0);
INSERT INTO "zhangong" VALUES('bszj', '搬石砸脚', 10, '与人决斗失败累计10次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('csjj', '常胜将军', 10, '连续胜利10局', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ljxs', '落井下石', 15, '一局游戏中发动古锭刀特效至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zqxj', '朱雀星君', 15, '一局游戏中发动朱雀羽扇特效至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('tjb', '藤甲兵', 15, '一局游戏中发动藤甲效果抵挡杀、南蛮入侵或万箭齐发至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('dshx', '大事化小', 15, '一局游戏中发动白银狮子特效减少伤害至少1次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('swsm', '塞翁失马', 15, '一局游戏中，失去白银狮子回复体力至少2次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('rhss', '惹火上身', 15, '一局游戏中，装备藤甲的时受到至少3次火焰伤害', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('hyjy', '何以解忧', 15, '一局游戏中，使用酒回复体力至少2次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('gqbb', '攻其不备', 15, '一局游戏中，成功使用火攻造成伤害至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('bkclm', '被看穿了吗', 15, '一局游戏中，使用火攻失败至少3次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jcll', '饥肠辘辘', 15, '在1局游戏中，累计3次被兵粮寸断后判定牌都不是草花', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('bjlz', '兵精粮足', 15, '在1局游戏中，累计3次被兵粮寸断后判定牌都是草花', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('yntd', '有难同当', 15, '1局游戏中，使用铁索连环累计横置其他角色至少6次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('qgqc', '倾国倾城', 10, '使用貂蝉在1局游戏中发动离间造成至少3名角色死亡', 0, 'qun', '1999-12-31 00:00:00', 'diaochan', 0, 0);
INSERT INTO "zhangong" VALUES('lsmy', '乱世名医', 5, '使用华佗在1局游戏中发动急救使至少3个不同的角色脱离濒死状态', 0, 'qun', '1999-12-31 00:00:00', 'huatuo', 0, 0);
INSERT INTO "zhangong" VALUES('yqwb', '掩其无备', 5, '使用张辽在1局游戏中发动至少10次突袭', 0, 'wei', '1999-12-31 00:00:00', 'zhangliao', 0, 0);
INSERT INTO "zhangong" VALUES('nswh', '你死我活', 5, '使用夏侯惇在1局游戏中发动刚烈杀死至少1名角色', 0, 'wei', '1999-12-31 00:00:00', 'xiahoudun', 0, 0);
INSERT INTO "zhangong" VALUES('mwl', '妈，我冷', 5, '使用许褚在1局游戏中发动裸衣至少2次并在裸衣的回合中杀死过至少2名角色', 0, 'wei', '1999-12-31 00:00:00', 'xuchu', 0, 0);
INSERT INTO "zhangong" VALUES('byyl', '不遗余力', 5, '使用郭嘉在1局游戏中发动遗计至少5次', 0, 'wei', '1999-12-31 00:00:00', 'guojia', 0, 0);
INSERT INTO "zhangong" VALUES('sytt', '手眼通天', 5, '使用司马懿在1局游戏中有至少2次发动反馈都抽到对方1张桃', 0, 'wei', '1999-12-31 00:00:00', 'simayi', 0, 0);
INSERT INTO "zhangong" VALUES('lsf', '洛神赋', 5, '使用甄姬一回合内发动洛神在不被改变判定牌的情况下连续判定黑色花色至少8次', 0, 'wei', '1999-12-31 00:00:00', 'zhenji', 0, 0);
INSERT INTO "zhangong" VALUES('jjzx', '纠结之心', 5, '使用刘备在1局游戏中发动雌雄双股剑特效至少5次', 0, 'shu', '1999-12-31 00:00:00', 'liubei', 0, 0);
INSERT INTO "zhangong" VALUES('yrdpx', '燕人的咆哮', 5, '使用张飞在1局游戏中发动丈八蛇矛特效杀死至少1名角色', 0, 'shu', '1999-12-31 00:00:00', 'zhangfei', 0, 0);
INSERT INTO "zhangong" VALUES('qjtj', '全军突击', 5, '使用马超在1局游戏中发动铁骑连续判定红色花色至少5次', 0, 'shu', '1999-12-31 00:00:00', 'machao', 0, 0);
INSERT INTO "zhangong" VALUES('wsxl', '武圣显灵', 5, '使用关羽在1局游戏中发动武圣至少杀死3名角色', 0, 'shu', '1999-12-31 00:00:00', 'guanyu', 0, 0);
INSERT INTO "zhangong" VALUES('hssd', '浑身是胆', 5, '使用赵云在1局游戏中发动龙胆至少杀死3名角色', 0, 'shu', '1999-12-31 00:00:00', 'zhaoyun', 0, 0);
INSERT INTO "zhangong" VALUES('jnd', '锦囊袋', 5, '使用黄月英在1个回合内发动至少10次集智', 0, 'shu', '1999-12-31 00:00:00', 'huangyueying', 0, 0);
INSERT INTO "zhangong" VALUES('kcjc', '空城绝唱', 5, '使用诸葛亮在1局游戏中有至少5个回合结束时是空城状态', 0, 'shu', '1999-12-31 00:00:00', 'zhugeliang', 0, 0);
INSERT INTO "zhangong" VALUES('lbsd', '老不死的', 5, '使用孙权做主公在1局游戏中被吴国武将用桃救活至少3次', 0, 'wu', '1999-12-31 00:00:00', 'sunquan', 0, 0);
INSERT INTO "zhangong" VALUES('scgm', '神出鬼没', 5, '使用甘宁在1个回合内发动至少6次奇袭', 0, 'wu', '1999-12-31 00:00:00', 'ganning', 0, 0);
INSERT INTO "zhangong" VALUES('wjdbt', '无尽的鞭挞', 5, '使用黄盖1个回合内发动至少8次苦肉', 0, 'wu', '1999-12-31 00:00:00', 'huanggai', 0, 0);
INSERT INTO "zhangong" VALUES('yhjm', '移花接木', 5, '使用大乔在一局游戏中累计发动5次流离', 0, 'wu', '1999-12-31 00:00:00', 'daqiao', 0, 0);
INSERT INTO "zhangong" VALUES('wjdzz', '无尽的挣扎', 5, '使用周瑜在1局游戏中使用反间杀死至少3名角色', 0, 'wu', '1999-12-31 00:00:00', 'zhouyu', 0, 0);
INSERT INTO "zhangong" VALUES('lmbj', '连绵不绝', 5, '使用陆逊在1个回合内发动至少10次连营', 0, 'wu', '1999-12-31 00:00:00', 'luxun', 0, 0);
INSERT INTO "zhangong" VALUES('fcdc', '风驰电掣', 5, '使用夏侯渊在1局游戏中，有连续至少3个回合每个回合都发动2次神速', 0, 'wei', '1999-12-31 00:00:00', 'xiahouyuan', 0, 0);
INSERT INTO "zhangong" VALUES('ljdnx', '老将的逆袭', 5, '使用黄忠在1局游戏中，剩余1点体力时累计发动烈弓杀死至少3名角色', 0, 'shu', '1999-12-31 00:00:00', 'huangzhong', 0, 0);
INSERT INTO "zhangong" VALUES('jqbd', '金枪不倒', 5, '使用周泰在1局游戏中拥有过至少9张不屈牌并且未死', 0, 'wu', '1999-12-31 00:00:00', 'zhoutai', 0, 0);
INSERT INTO "zhangong" VALUES('sxcx', '嗜血成性', 5, '使用魏延在1回合内发动狂骨回复至少3点体力', 0, 'shu', '1999-12-31 00:00:00', 'weiyan', 0, 0);
INSERT INTO "zhangong" VALUES('grjt', '固若金汤', 5, '使用曹仁在一局游戏中发动至少3次据守，并且在损失体力不多于3点的情况下获胜。', 0, 'wei', '1999-12-31 00:00:00', 'caoren', 0, 0);
INSERT INTO "zhangong" VALUES('lxxy', '怜香惜玉', 5, '使用小乔在一局游戏中发动天香让某名男性武将摸牌至少15张', 0, 'wu', '1999-12-31 00:00:00', 'xiaoqiao', 0, 0);
INSERT INTO "zhangong" VALUES('kbdwn', '狂奔的蜗牛', 5, '使用张角在1局游戏发动雷击杀死至少3名角色', 0, 'qun', '1999-12-31 00:00:00', 'zhangjiao', 0, 0);
INSERT INTO "zhangong" VALUES('sgmc', '神鬼莫测', 5, '使用于吉在1局游戏中累计蛊惑假牌至少成功3次', 0, 'qun', '1999-12-31 00:00:00', 'yuji', 0, 0);
INSERT INTO "zhangong" VALUES('sssg', '四世三公', 5, '使用袁术在1回合内消灭场上4个势力中的3个', 0, 'qun', '1999-12-31 00:00:00', 'yuanshu', 0, 0);
INSERT INTO "zhangong" VALUES('bmyc', '白马义从', 5, '使用公孙瓒在体力大于2的情况下杀死至少3名角色，并且在体力1的情况下存活并获胜。', 0, 'qun', '1999-12-31 00:00:00', 'gongsunzan', 0, 0);
INSERT INTO "zhangong" VALUES('yfdg', '一夫当关', 5, '使用典韦在1局游戏中发动至少5次强袭', 0, 'wei', '1999-12-31 00:00:00', 'dianwei', 0, 0);
INSERT INTO "zhangong" VALUES('qhtl', '驱虎吞狼', 5, '使用荀彧在1局游戏中至少发动5次驱虎并拼点成功', 0, 'wei', '1999-12-31 00:00:00', 'xunyu', 0, 0);
INSERT INTO "zhangong" VALUES('tslz', '铁锁连舟', 5, '使用庞统在1回合内发动连环横置至少6名角色', 0, 'shu', '1999-12-31 00:00:00', 'pangtong', 0, 0);
INSERT INTO "zhangong" VALUES('thly', '天火燎原', 5, '使用卧龙诸葛亮在1回合内发动火计造成至少6点伤害', 0, 'shu', '1999-12-31 00:00:00', 'wolong', 0, 0);
INSERT INTO "zhangong" VALUES('jdzh', '江东之虎', 5, '使用太史慈在1回合内发动天义拼点胜利后，使用【杀】杀死至少3名角色', 0, 'wu', '1999-12-31 00:00:00', 'taishici', 0, 0);
INSERT INTO "zhangong" VALUES('ljsd', '乱箭肃敌', 5, '使用袁绍在1回合内发动乱击至少6次', 0, 'qun', '1999-12-31 00:00:00', 'yuanshao', 0, 0);
INSERT INTO "zhangong" VALUES('qldj', '其利断金', 5, '使用颜良文丑在1局游戏中发动双雄至少3次并在双雄的回合中杀死过至少3名角色', 0, 'qun', '1999-12-31 00:00:00', 'yanliangwenchou', 0, 0);
INSERT INTO "zhangong" VALUES('zkzj', '周苛之节', 5, '使用庞德在1局游戏中发动猛进至少5次', 0, 'qun', '1999-12-31 00:00:00', 'pangde', 0, 0);
INSERT INTO "zhangong" VALUES('zcxb', '战场新兵', 5, '获得1场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', '-', 1, 0);
INSERT INTO "zhangong" VALUES('bsyz', '背水一战', 15, '身为主帅，在本方两名前锋阵亡的情况下，杀死对方3人后获胜', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ygzq', '一鼓作气', 12, '一回合内杀死对方3名角色', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('swjd', '肆无忌惮', 12, '一回合内使用至少3张南蛮入侵或万箭齐发', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('fxss', '锋线杀手', 12, '身为前锋获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'guard', 20, 0);
INSERT INTO "zhangong" VALUES('ybyf', '用兵有方', 12, '身为主帅获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'leader', 20, 0);
INSERT INTO "zhangong" VALUES('wzbz', '魏之霸者', 15, '使用魏国武将获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'wei', 20, 0);
INSERT INTO "zhangong" VALUES('szbz', '蜀之霸者', 15, '使用蜀国武将获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'shu', 20, 0);
INSERT INTO "zhangong" VALUES('wuzbz', '吴之霸者', 15, '使用吴国武将获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'wu', 20, 0);
INSERT INTO "zhangong" VALUES('qxbz', '群雄霸者', 15, '使用群雄武将获得20场3V3游戏胜利', 0, '3v3', '1999-12-31 00:00:00', 'qun', 20, 0);
INSERT INTO "zhangong" VALUES('ssqy', '舍生取义', 15, '身为前锋，被本方角色杀死累计10次', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zdhl', '直捣黄龙', 12, '在对方两名前锋都没有受伤的情况下杀死对方主帅', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('szsj', '速战速决', 10, '在自己的首回合结束前获得胜利', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('cjz', '持久战', 10, '在自己的第5回合结束后获得胜利', 0, '3v3', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('clzd', '初来乍到', 5, '获得1场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', '-', 1, 0);
INSERT INTO "zhangong" VALUES('mlgr', '谋略过人', 12, '选择了3名3血武将并且获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ymgr', '勇猛过人', 12, '选择了3名4血武将并且获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('xfzr', '先发制人', 10, '先手出牌获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'renegade', 30, 0);
INSERT INTO "zhangong" VALUES('hfzr', '后发制人', 10, '后手出牌获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'lord', 30, 0);
INSERT INTO "zhangong" VALUES('wzwz', '魏之武者', 15, '使用魏国武将获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'wei', 30, 0);
INSERT INTO "zhangong" VALUES('szwz', '蜀之武者', 15, '使用蜀国武将获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'shu', 30, 0);
INSERT INTO "zhangong" VALUES('wuzwz', '吴之武者', 15, '使用吴国武将获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'wu', 30, 0);
INSERT INTO "zhangong" VALUES('qxwz', '群雄武者', 15, '使用群雄武将获得30场1V1游戏胜利', 0, '1v1', '1999-12-31 00:00:00', 'qun', 30, 0);
INSERT INTO "zhangong" VALUES('bbxr', '兵不血刃', 11, '对方3名武将都在他们各自的回合阵亡', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jgyx', '巾帼英雄', 10, '选择3名女性武将并且获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('hgjs', '护国军师', 12, '以诸葛亮、司马懿、周瑜为上场武将的情况下获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('hfws', '毫发无伤', 15, '在本方所有武将满体力的情况下胜利', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('jtnz', '惊天逆转', 15, '在本方剩余1名武将时，杀死对方3名武将获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('yywm', '有勇无谋', 12, '以吕布、张飞、许褚为上场武将的情况下获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('zysq', '智勇双全', 12, '以关羽、赵云、黄忠为上场武将的情况下获胜', 0, '1v1', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO "zhangong" VALUES('ahdkls', '暗黑的傀儡师', 20, '使用☆SP貂蝉获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'bgm_diaochan', 30, 0);
INSERT INTO "zhangong" VALUES('gyj', '弓腰姬', 20, '使用孙尚香获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'sunshangxiang', 30, 0);
INSERT INTO "zhangong" VALUES('bydj', '白衣渡江', 20, '使用吕蒙获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'lvmeng', 30, 0);
INSERT INTO "zhangong" VALUES('hzld', '汉昭烈帝', 20, '使用☆SP刘备获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'bgm_liubei', 30, 0);
INSERT INTO "zhangong" VALUES('ldjx', '料敌机先', 20, '使用张郃获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'zhanghe', 30, 0);
INSERT INTO "zhangong" VALUES('snjj', '少年将军', 20, '使用赵云获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'zhaoyun', 30, 0);
INSERT INTO "zhangong" VALUES('gydjn', '归隐的杰女', 20, '使用黄月英获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'huangyueying', 30, 0);
INSERT INTO "zhangong" VALUES('bmxf', '白马先锋', 20, '使用☆SP赵云获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'bgm_zhaoyun', 30, 0);
INSERT INTO "zhangong" VALUES('gwbk', '攻无不克', 20, '使用高顺获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'gaoshun', 30, 0);
INSERT INTO "zhangong" VALUES('cwdmz', '曹魏的谋主', 20, '使用荀攸获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xunyou', 30, 0);
INSERT INTO "zhangong" VALUES('hmlm', '横矛立马', 20, '使用☆SP张飞获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'bgm_zhangfei', 30, 0);
INSERT INTO "zhangong" VALUES('xlzd', '修罗之道', 20, '使用神吕布获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu', 30, 0);
INSERT INTO "zhangong" VALUES('hqld', '豪情烈胆', 20, '使用凌统获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'lingtong', 30, 0);
INSERT INTO "zhangong" VALUES('ljcs', '历尽沧桑', 20, '使用廖化获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'liaohua', 30, 0);
INSERT INTO "zhangong" VALUES('jydjg', '决意的巾帼', 20, '使用王异获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'wangyi', 30, 0);
INSERT INTO "zhangong" VALUES('jczgj', '荆楚之高俊', 20, '使用☆SP庞统获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'bgm_pangtong', 30, 0);
INSERT INTO "zhangong" VALUES('wld', '武烈帝', 20, '使用孙坚获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'sunjian', 30, 0);
INSERT INTO "zhangong" VALUES('sy', '神医', 20, '使用华佗获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'huatuo', 30, 0);
INSERT INTO "zhangong" VALUES('sxddl', '嗜血的独狼', 20, '使用魏延获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'weiyan', 30, 0);
INSERT INTO "zhangong" VALUES('lzzq', '历战之驱', 20, '使用周泰获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'zhoutai', 30, 0);
INSERT INTO "zhangong" VALUES('ldyz', '老当益壮', 20, '使用黄忠获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'huangzhong', 30, 0);
INSERT INTO "zhangong" VALUES('wfbd', '万夫不当', 20, '使用张飞获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'zhangfei', 30, 0);
INSERT INTO "zhangong" VALUES('xbcn', '险不辞难', 20, '使用☆SP曹仁获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'bgm_caoren', 30, 0);
INSERT INTO "zhangong" VALUES('lkdds', '冷酷的毒士', 20, '使用贾诩获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'jiaxu', 30, 0);
INSERT INTO "zhangong" VALUES('hc', '虎痴', 20, '使用许褚获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xuchu', 30, 0);
INSERT INTO "zhangong" VALUES('yqdq', '一骑当千', 20, '使用马超获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'machao', 30, 0);
INSERT INTO "zhangong" VALUES('wdhs', '武的化身', 20, '使用吕布获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'lvbu', 30, 0);
INSERT INTO "zhangong" VALUES('wwdzmz', '无为的真命主', 20, '使用刘禅获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'liushan', 30, 0);
INSERT INTO "zhangong" VALUES('gzel', '古之恶来', 20, '使用典韦获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'dianwei', 30, 0);
INSERT INTO "zhangong" VALUES('tgjj', '天公将军', 20, '使用张角获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'zhangjiao', 30, 0);
INSERT INTO "zhangong" VALUES('wmzh', '无冕之后', 20, '使用步练师获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'bulianshi', 30, 0);
INSERT INTO "zhangong" VALUES('scfk', '恃才放旷', 20, '使用杨修获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'yangxiu', 30, 0);
INSERT INTO "zhangong" VALUES('cszyj', '超世之英杰', 20, '使用神曹操获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shencaocao', 30, 0);
INSERT INTO "zhangong" VALUES('zzdxz', '早终的先知', 20, '使用郭嘉获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'guojia', 30, 0);
INSERT INTO "zhangong" VALUES('zjd', '仲家帝', 20, '使用袁术获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'yuanshu', 30, 0);
INSERT INTO "zhangong" VALUES('bmjj', '白马将军', 20, '使用公孙瓒获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'gongsunzan', 30, 0);
INSERT INTO "zhangong" VALUES('jqzh', '矫情之花', 20, '使用小乔获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'xiaoqiao', 30, 0);
INSERT INTO "zhangong" VALUES('mw', '魔王', 20, '使用董卓获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'dongzhuo', 30, 0);
INSERT INTO "zhangong" VALUES('nmw', '南蛮王', 20, '使用孟获获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'menghuo', 30, 0);
INSERT INTO "zhangong" VALUES('jczh', '矜持之花', 20, '使用大乔获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'daqiao', 30, 0);
INSERT INTO "zhangong" VALUES('dddwjj', '独断的外交家', 20, '使用鲁肃获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'lusu', 30, 0);
INSERT INTO "zhangong" VALUES('gszl', '鬼神再临', 20, '使用神关羽获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenguanyu', 30, 0);
INSERT INTO "zhangong" VALUES('cbdhs', '赤壁的火神', 20, '使用神周瑜获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenzhouyu', 30, 0);
INSERT INTO "zhangong" VALUES('jfyx', '锦帆游侠', 20, '使用甘宁获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'ganning', 30, 0);
INSERT INTO "zhangong" VALUES('nqdxj', '年轻的贤君', 20, '使用孙权获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'sunquan', 30, 0);
INSERT INTO "zhangong" VALUES('wlhh', '武烈皇后', 20, '使用吴国太获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'wuguotai', 30, 0);
INSERT INTO "zhangong" VALUES('bydjcz', '霸业的继承者', 20, '使用曹丕获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'caopi', 30, 0);
INSERT INTO "zhangong" VALUES('hxe', '黄须儿', 20, '使用曹彰获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'caozhang', 30, 0);
INSERT INTO "zhangong" VALUES('bdzc', '八斗之才', 20, '使用曹植获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'caozhi', 30, 0);
INSERT INTO "zhangong" VALUES('sch', '石城侯', 20, '使用韩当获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'handang', 30, 0);
INSERT INTO "zhangong" VALUES('yxdgn', '异乡的孤女', 20, '使用蔡文姬获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'caiwenji', 30, 0);
INSERT INTO "zhangong" VALUES('lsdwj', '乱世的舞姬', 20, '使用貂蝉获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'diaochan', 30, 0);
INSERT INTO "zhangong" VALUES('ldyb', '龙的衣钵', 20, '使用姜维获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'jiangwei', 30, 0);
INSERT INTO "zhangong" VALUES('djj', '大将军', 20, '使用曹仁获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'caoren', 30, 0);
INSERT INTO "zhangong" VALUES('zxdxs', '忠孝的侠士', 20, '使用徐庶获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'xushu', 30, 0);
INSERT INTO "zhangong" VALUES('dydls', '独眼的罗刹', 20, '使用夏侯惇获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xiahoudun', 30, 0);
INSERT INTO "zhangong" VALUES('cbdyss', '赤壁的妖术师', 20, '使用神诸葛亮获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenzhugeliang', 30, 0);
INSERT INTO "zhangong" VALUES('rsxc', '儒生雄才', 20, '使用陆逊获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'luxun', 30, 0);
INSERT INTO "zhangong" VALUES('swrl', '神威如龙', 20, '使用神赵云获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenzhaoyun', 30, 0);
INSERT INTO "zhangong" VALUES('mrg', '美髯公', 20, '使用关羽获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'guanyu', 30, 0);
INSERT INTO "zhangong" VALUES('jtwd', '经天纬地', 20, '使用张昭张纮获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'erzhang', 30, 0);
INSERT INTO "zhangong" VALUES('mzxr', '迷之仙人', 20, '使用左慈获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'zuoci', 30, 0);
INSERT INTO "zhangong" VALUES('zyfzf', '周亚夫之风', 20, '使用徐晃获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xuhuang', 30, 0);
INSERT INTO "zhangong" VALUES('sgzgs', '圣光之国士', 20, '使用神吕蒙获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenlvmeng', 30, 0);
INSERT INTO "zhangong" VALUES('hczf', '怀才自负', 20, '使用马谡获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'masu', 30, 0);
INSERT INTO "zhangong" VALUES('lmdwxz', '联盟的维系者', 20, '使用诸葛瑾获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'zhugejin', 30, 0);
INSERT INTO "zhangong" VALUES('lsdxx', '乱世的枭雄', 20, '使用刘备获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'liubei', 30, 0);
INSERT INTO "zhangong" VALUES('jxdlb', '疾行的猎豹', 20, '使用夏侯渊获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xiahouyuan', 30, 0);
INSERT INTO "zhangong" VALUES('fc', '凤雏', 20, '使用庞统获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'pangtong', 30, 0);
INSERT INTO "zhangong" VALUES('dlzs', '笃烈之士', 20, '使用太史慈获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'taishici', 30, 0);
INSERT INTO "zhangong" VALUES('jadyxj', '桀骜的野心家', 20, '使用钟会获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'zhonghui', 30, 0);
INSERT INTO "zhangong" VALUES('jddxbw', '江东的小霸王', 20, '使用孙策获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'sunce', 30, 0);
INSERT INTO "zhangong" VALUES('hsth', '汉寿亭侯', 20, '使用SP关羽获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'sp_guanyu', 30, 0);
INSERT INTO "zhangong" VALUES('bxdmr', '薄幸的美人', 20, '使用甄姬获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'zhenji', 30, 0);
INSERT INTO "zhangong" VALUES('tpdr', '太平道人', 20, '使用于吉获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'yuji', 30, 0);
INSERT INTO "zhangong" VALUES('wl', '卧龙', 20, '使用卧龙诸葛亮获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'wolong', 30, 0);
INSERT INTO "zhangong" VALUES('kdhn', '跨蹈汉南', 20, '使用刘表获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'liubiao', 30, 0);
INSERT INTO "zhangong" VALUES('lgzg', '狼顾之鬼', 20, '使用司马懿获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'simayi', 30, 0);
INSERT INTO "zhangong" VALUES('gszf', '国士之风', 20, '使用☆SP吕蒙获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'bgm_lvmeng', 30, 0);
INSERT INTO "zhangong" VALUES('rmyt', '人马一体', 20, '使用庞德获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'pangde', 30, 0);
INSERT INTO "zhangong" VALUES('wwd', '魏武帝', 20, '使用曹操获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'caocao', 30, 0);
INSERT INTO "zhangong" VALUES('jrdzs', '矫然的壮士', 20, '使用邓艾获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'dengai', 30, 0);
INSERT INTO "zhangong" VALUES('qswg', '轻身为国', 20, '使用黄盖获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'huanggai', 30, 0);
INSERT INTO "zhangong" VALUES('gzzl', '刚直壮烈', 20, '使用陈宫获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'chengong', 30, 0);
INSERT INTO "zhangong" VALUES('sgys', '韶光易逝', 20, '使用☆SP大乔获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'bgm_daqiao', 30, 0);
INSERT INTO "zhangong" VALUES('cmdcx', '迟暮的丞相', 20, '使用诸葛亮获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'zhugeliang', 30, 0);
INSERT INTO "zhangong" VALUES('schc', '三朝虎臣', 20, '使用程普获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'chengpu', 30, 0);
INSERT INTO "zhangong" VALUES('jgzz', '晋国之祖', 20, '使用神司马懿获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shensimayi', 30, 0);
INSERT INTO "zhangong" VALUES('hlxd', '虎狼兄弟', 20, '使用颜良文丑获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'yanliangwenchou', 30, 0);
INSERT INTO "zhangong" VALUES('qjj', '前将军', 20, '使用张辽获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'zhangliao', 30, 0);
INSERT INTO "zhangong" VALUES('wzzc', '王佐之才', 20, '使用荀彧获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'xunyu', 30, 0);
INSERT INTO "zhangong" VALUES('ggdmm', '高贵的名门', 20, '使用袁绍获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'yuanshao', 30, 0);
INSERT INTO "zhangong" VALUES('yxdnw', '野性的女王', 20, '使用祝融获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'zhurong', 30, 0);
INSERT INTO "zhangong" VALUES('mj', '魔将', 20, '使用华雄获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'huaxiong', 30, 0);
INSERT INTO "zhangong" VALUES('lwsm', '临危受命', 20, '使用马岱获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'madai', 30, 0);
INSERT INTO "zhangong" VALUES('jddtb', '江东的铁壁', 20, '使用徐盛获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'xusheng', 30, 0);
INSERT INTO "zhangong" VALUES('ddd', '大都督', 20, '使用周瑜获得30场身份模式游戏胜利', 0, 'wu', '1999-12-31 00:00:00', 'zhouyu', 30, 0);
INSERT INTO "zhangong" VALUES('jmhz', '将门虎子', 20, '使用关兴张苞获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'guanxingzhangbao', 30, 0);
INSERT INTO "zhangong" VALUES('jsdwj', '绝世的舞姬', 20, '使用SP貂蝉获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'sp_diaochan', 30, 0);
INSERT INTO "zhangong" VALUES('tczw', '枱榇之悟', 20, '使用SP庞德获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'sp_pangde', 30, 0);
INSERT INTO "zhangong" VALUES('zqsh', '最强神话', 20, '使用虎牢关吕布获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu1', 30, 0);
INSERT INTO "zhangong" VALUES('bndzs', '暴怒的战神', 20, '使用虎牢关吕布获得30场身份模式游戏胜利', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu2', 30, 0);
INSERT INTO "zhangong" VALUES('jbzc', '金璧之才', 20, '使用SP蔡文姬获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'sp_caiwenji', 30, 0);
INSERT INTO "zhangong" VALUES('xldms', '西凉的猛狮', 20, '使用SP马超获得30场身份模式游戏胜利', 0, 'qun', '1999-12-31 00:00:00', 'sp_machao', 30, 0);
INSERT INTO "zhangong" VALUES('swyc', '算无遗策', 20, '使用SP贾诩获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'sp_jiaxu', 30, 0);
INSERT INTO "zhangong" VALUES('shdfy', '蜀汉的辅翼', 20, '使用法正获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'fazheng', 30, 0);
INSERT INTO "zhangong" VALUES('wwzg', '魏武之刚', 20, '使用于禁获得30场身份模式游戏胜利', 0, 'wei', '1999-12-31 00:00:00', 'yujin', 30, 0);
INSERT INTO "zhangong" VALUES('mzly', '梦醉良缘', 20, '使用SP孙尚香获得30场身份模式游戏胜利', 0, 'shu', '1999-12-31 00:00:00', 'sp_sunshangxiang', 30, 0);
INSERT INTO "zhangong" VALUES('cmr', '刺美人', 5, '使用祝融在1局游戏中对一名男性发动烈刃并拼点赢至少3次', 0, 'shu', '1999-12-31 00:00:00', 'zhurong', 0, 0);
INSERT INTO "zhangong" VALUES('pndjj', '破虏大将军', 5, '使用孙坚连续至少3回合在1体力时发动英魂', 0, 'wu', '1999-12-31 00:00:00', 'sunjian', 0, 0);
INSERT INTO "zhangong" VALUES('zqxz', '指囷相赠', 5, '使用鲁肃在1局游戏中发动好施分给其他角色至少15张牌', 0, 'wu', '1999-12-31 00:00:00', 'lusu', 0, 0);
INSERT INTO "zhangong" VALUES('rs', '肉山', 5, '使用董卓在1局游戏中使用杀杀死至少3名女性角色', 0, 'qun', '1999-12-31 00:00:00', 'dongzhuo', 0, 0);
INSERT INTO "zhangong" VALUES('lsgj', '乱世歌姬', 5, '使用蔡文姬在一局中发动悲歌至少4次 发动断肠并最终获胜', 0, 'wei', '1999-12-31 00:00:00', 'caiwenji', 0, 0);
INSERT INTO "zhangong" VALUES('dzry', '大智若愚', 5, '使用刘禅每回合都发动放权并最终获胜', 0, 'shu', '1999-12-31 00:00:00', 'liushan', 0, 0);
INSERT INTO "zhangong" VALUES('mrgs', '猛锐盖世', 5, '使用孙策在一局游戏中发动激昂摸牌至少5张并发动技能魂姿', 0, 'wu', '1999-12-31 00:00:00', 'sunce', 0, 0);
INSERT INTO "zhangong" VALUES('szzjz', '蜀之终结者', 5, '使用邓艾在一回合内发动急袭至少4次', 0, 'wei', '1999-12-31 00:00:00', 'dengai', 0, 0);
INSERT INTO "zhangong" VALUES('cjww', '才兼文武', 5, '使用姜维在一局游戏中发动挑衅弃掉牌至少4张并发动观星至少2次', 0, 'shu', '1999-12-31 00:00:00', 'jiangwei', 0, 0);
INSERT INTO "zhangong" VALUES('dhhs', '大幻化师', 5, '使用左慈在一局游戏中获得化身牌至少10张', 0, 'qun', '1999-12-31 00:00:00', 'zuoci', 0, 0);
INSERT INTO "zhangong" VALUES('lyws', '炼狱武神', 5, '使用神关羽在一局游戏中使用红桃花色的杀杀死至少3名角色', 0, 'god', '1999-12-31 00:00:00', 'shenguanyu', 0, 0);
INSERT INTO "zhangong" VALUES('hlyh', '红莲业火', 5, '使用神周瑜在一回合发动业炎造成至少5点伤害', 0, 'god', '1999-12-31 00:00:00', 'shenzhouyu', 0, 0);
INSERT INTO "zhangong" VALUES('hdyx', '换斗移星', 5, '使用神诸葛在一局游戏中让至少一名狂风状态的角色被火攻杀死', 0, 'god', '1999-12-31 00:00:00', 'shenzhugeliang', 0, 0);
INSERT INTO "zhangong" VALUES('txgx', '天下归心', 5, '使用神曹操在一局游戏中发动归心获得至少10张牌', 0, 'god', '1999-12-31 00:00:00', 'shencaocao', 0, 0);
INSERT INTO "zhangong" VALUES('sgws', '神鬼无双', 5, '使用神吕布在一局游戏中发动神愤至少2次', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu', 0, 0);
INSERT INTO "zhangong" VALUES('xltj', '西凉铁骑', 5, '使用SP马超在一局游戏中至少发动5次铁骑并判定为红色', 0, 'qun', '1999-12-31 00:00:00', 'sp_machao', 0, 0);
INSERT INTO "zhangong" VALUES('njnt', '能进能退', 5, '使用☆SP赵云在一局游戏中至少发动冲阵获得6张牌并获胜', 0, 'qun', '1999-12-31 00:00:00', 'bgm_zhaoyun', 0, 0);
INSERT INTO "zhangong" VALUES('sll', '失礼了', 5, '使用☆SP貂蝉在一局游戏中至少发动3次离魂并获胜', 0, 'qun', '1999-12-31 00:00:00', 'bgm_diaochan', 0, 0);
INSERT INTO "zhangong" VALUES('pzzj', '破阵斩将', 5, '使用高顺在一局游戏中发动陷阵拼点赢的情况下杀死至少两名角色并获胜', 0, 'qun', '1999-12-31 00:00:00', 'gaoshun', 0, 0);
INSERT INTO "zhangong" VALUES('bykt', '霸业可图', 5, '使用陈宫在一局游戏中对吕布发动明策至少2次', 0, 'qun', '1999-12-31 00:00:00', 'chengong', 0, 0);
INSERT INTO "zhangong" VALUES('djzc', '大军在此', 5, '使用徐盛在一局游戏中发动破军至少3次并获胜', 0, 'wu', '1999-12-31 00:00:00', 'xusheng', 0, 0);
INSERT INTO "zhangong" VALUES('wgzm', '吴国之母', 5, '使用吴国太在一局游戏中发动补益使至少3名不同的吴国武将脱离频死状态', 0, 'wu', '1999-12-31 00:00:00', 'wuguotai', 0, 0);
INSERT INTO "zhangong" VALUES('xyzj', '须臾之间', 5, '使用凌统在一局游戏中发动旋风至少弃置敌方角色装备区的牌至少8张', 0, 'wu', '1999-12-31 00:00:00', 'lingtong', 0, 0);
INSERT INTO "zhangong" VALUES('wkhn', '我看好你', 5, '使用徐庶在一局游戏中发动举荐至少6次', 0, 'shu', '1999-12-31 00:00:00', 'xushu', 0, 0);
INSERT INTO "zhangong" VALUES('txbf', '通晓兵法', 5, '使用马谡在一局游戏中发动心战获得桃和无中生有至少各2张', 0, 'shu', '1999-12-31 00:00:00', 'masu', 0, 0);
INSERT INTO "zhangong" VALUES('sbfh', '十倍奉还', 5, '使用法正在一局游戏中发动眩惑获得其他角色至少3张桃', 0, 'shu', '1999-12-31 00:00:00', 'fazheng', 0, 0);
INSERT INTO "zhangong" VALUES('styj', '身体要紧', 5, '在主公是刘备的情况下，使用SP孙尚香做内奸取得胜利', 0, 'shu', '1999-12-31 00:00:00', 'sp_sunshangxiang', 0, 0);
INSERT INTO "zhangong" VALUES('yzkw', '严整溃围', 5, '使用☆SP曹仁在一局游戏中发动溃围摸牌至少11张并发动严整至少4次', 0, 'wei', '1999-12-31 00:00:00', 'bgm_caoren', 0, 0);
INSERT INTO "zhangong" VALUES('wjjh', '文姬归汉', 5, '在主公是曹操的情况下，使用SP蔡文姬做内奸取得胜利', 0, 'wei', '1999-12-31 00:00:00', 'sp_caiwenji', 0, 0);
INSERT INTO zhangong VALUES('ajnf', '暗箭难防', 10, '使用马岱在一局游戏中发动“潜袭”成功至少6次', 0, 'shu', '1999-12-31 00:00:00', 'madai', 0, 0);
INSERT INTO zhangong VALUES('bj', '暴君', 15, '身为主公在1局游戏中，在反贼和内奸全部存活的情况下杀死全部忠臣，并最后胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('bjz', '败家子', 15, '在一局游戏中，弃牌阶段累计弃掉至少10张桃', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('bnzw', '暴虐之王', 10, '使用董卓在一局游戏中利用技能“暴虐”至少回血10次', 0, 'qun', '1999-12-31 00:00:00', 'dongzhuo', 0, 0);
INSERT INTO zhangong VALUES('bqk', '兵器库', 15, '在一局游戏中，累计装备过至少10次武器以及10次防具', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('brz', '百人斩', 15, '累积杀死100人', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('cbhw', '长坂虎威', 10, '使用张飞在一回合内使用8张杀', 0, 'shu', '1999-12-31 00:00:00', 'zhangfei', 0, 0);
INSERT INTO zhangong VALUES('cbyx', '长坂英雄', 10, '使用赵云在一局游戏中，在刘禅为队友且存活情况下获胜', 0, 'shu', '1999-12-31 00:00:00', 'zhaoyun', 0, 0);
INSERT INTO zhangong VALUES('cqb', '拆迁办', 15, '在一个回合内使用卡牌过河拆桥/顺手牵羊累计4次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('cqcz', '此情常在', 10, '在一局游戏中，布练师发动安恤4次并在阵亡情况下获胜', 0, 'wu', '1999-12-31 00:00:00', 'bulianshi', 0, 0);
INSERT INTO zhangong VALUES('cqdd', '拆迁大队', 15, '在一局游戏中，累计使用卡牌过河拆桥10次以上', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('ctbc', '拆桃不偿', 10, '使用甘宁在一局游戏中至少拆掉对方5张桃', 0, 'wu', '1999-12-31 00:00:00', 'ganning', 0, 0);
INSERT INTO zhangong VALUES('dcxj', '雕虫小技', 10, '使用卧龙在一局游戏中发动“看破”至少15次', 0, 'shu', '1999-12-31 00:00:00', 'wolong', 0, 0);
INSERT INTO zhangong VALUES('dkjj', '荡寇将军', 10, '使用程普在一局游戏中，发动技能“疠火”杀死至少三名反贼最终获得胜利', 0, 'wu', '1999-12-31 00:00:00', 'chengpu', 0, 0);
INSERT INTO zhangong VALUES('dkzz', '杜康之子', 10, '使用曹植在一局游戏中发动酒诗后成功用杀造成伤害累计5次', 0, 'wei', '1999-12-31 00:00:00', 'caozhi', 0, 0);
INSERT INTO zhangong VALUES('dqzw', '大权在握', 10, '使用钟会在一局游戏中有超过8张权', 0, 'wei', '1999-12-31 00:00:00', 'zhonghui', 0, 0);
INSERT INTO zhangong VALUES('dgxl', '东宫西略', 15, '在一局游戏中，身份为男性主公，而忠臣为两名女性武将并在女性忠臣全部存活的情况下获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('dym', '大姨妈', 10, '使用甄姬连续5回合洛神的第一次结果都是红色，不包括改判', 0, 'wei', '1999-12-31 00:00:00', 'zhenji', 0, 0);
INSERT INTO zhangong VALUES('dyzh', '当阳之吼', 10, '在一局游戏中，使用☆SP张飞累计两次发动大喝与一名角色拼点成功的回合中用红“杀”手刃该角色', 0, 'shu', '1999-12-31 00:00:00', 'bgm_zhangfei', 0, 0);
INSERT INTO zhangong VALUES('gjcc', '诡计重重', 15, '在一局游戏中，累计使用锦囊牌至少20次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('glnc', '刚烈难存', 10, '使用夏侯惇在一局游戏中连续4次刚烈判定均为红桃', 0, 'wei', '1999-12-31 00:00:00', 'xiahoudun', 0, 0);
INSERT INTO zhangong VALUES('gqzl', '顾曲周郎', 10, '使用神周瑜连续至少4回合发动琴音回复体力', 0, 'god', '1999-12-31 00:00:00', 'shenzhouyu', 0, 0);
INSERT INTO zhangong VALUES('lgzw', '雷公助我', 10, '使用张角在一局游戏中在未更改判定牌的情况下至少4次雷击成功', 0, 'qun', '1999-12-31 00:00:00', 'zhangjiao', 0, 0);
INSERT INTO zhangong VALUES('hlzms', '挥泪斩马谡', 10, '使用诸葛亮杀死马谡', 0, 'shu', '1999-12-31 00:00:00', 'zhugeliang', 0, 0);
INSERT INTO zhangong VALUES('hztx', '虎子同心', 10, '使用关兴张苞在父魂成功后，一个回合杀死至少三名反贼', 0, 'shu', '1999-12-31 00:00:00', 'guanxingzhangbao', 0, 0);
INSERT INTO zhangong VALUES('jcyd', '将驰有度', 10, '使用曹彰发动将驰的两种效果各连续两回合', 0, 'wei', '1999-12-31 00:00:00', 'caozhang', 0, 0);
INSERT INTO zhangong VALUES('jdfy', '绝对防御', 15, '在一局游戏中，使用八挂累计出闪20次', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('jfhz', '解烦护主', 10, '使用韩当在一局游戏游戏中发动“解烦”救过队友孙权至少两次', 0, 'wu', '1999-12-31 00:00:00', 'handang', 0, 0);
INSERT INTO zhangong VALUES('jg', '酒鬼', 15, '出牌阶段开始时，手牌中至少有3张“酒”', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('jhlt', '举火燎天', 15, '在一局游戏中，造成火焰伤害累计10点以上，不含武将技能', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('jjfs', '绝境逢生', 10, '使用神赵云在一局游戏中,当体力为一的时候，一直保持一体力直到游戏获胜', 0, 'god', '1999-12-31 00:00:00', 'shenzhaoyun', 0, 0);
INSERT INTO zhangong VALUES('jjh', '交际花', 10, '使用孙尚香和全部其他(且至少4个)角色皆使用过结姻', 0, 'wu', '1999-12-31 00:00:00', 'sunshangxiang', 0, 0);
INSERT INTO zhangong VALUES('jjyb', '戒酒以备', 10, '使用高顺在一局游戏中使用技能“禁酒”将至少6张酒当成杀使用或打出', 0, 'qun', '1999-12-31 00:00:00', 'gaoshun', 0, 0);
INSERT INTO zhangong VALUES('jsbc', '坚守不出', 10, '使用曹仁在一局游戏中连续8回合发动据守', 0, 'wei', '1999-12-31 00:00:00', 'caoren', 0, 0);
INSERT INTO zhangong VALUES('lpkd', '连破克敌', 10, '使用神司马懿在一局游戏中发动3次连破并最后获胜', 0, 'god', '1999-12-31 00:00:00', 'shensimayi', 0, 0);
INSERT INTO zhangong VALUES('qbcs', '七步成诗', 10, '使用曹植在一局游戏中发动酒诗7次', 0, 'wei', '1999-12-31 00:00:00', 'caozhi', 0, 0);
INSERT INTO zhangong VALUES('qjbc', '奇计百出', 10, '使用荀攸在一局游戏中，发动“奇策”使用至少六种锦囊', 0, 'wei', '1999-12-31 00:00:00', 'xunyou', 0, 0);
INSERT INTO zhangong VALUES('qldy', '枪林弹雨', 10, '使用袁绍在一回合内发动8次乱击', 0, 'qun', '1999-12-31 00:00:00', 'yuanshao', 0, 0);
INSERT INTO zhangong VALUES('qmjj', '奇谋九计', 10, '使用王异在一局游戏中至少成功发动九次秘计并获胜。', 0, 'wei', '1999-12-31 00:00:00', 'wangyi', 0, 0);
INSERT INTO zhangong VALUES('qrz', '千人斩', 15, '累积杀1000人', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('qshs', '起死回生', 15, '在一局游戏中，累计受过至少20点伤害且最后存活获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('rxbz', '仁心布众', 10, '使用刘备在一局游戏中，累计仁德至少30张牌', 0, 'shu', '1999-12-31 00:00:00', 'liubei', 0, 0);
INSERT INTO zhangong VALUES('sbfs', '生不逢时', 10, '使用双雄对关羽使用决斗，并因这个决斗被关羽杀死', 0, 'qun', '1999-12-31 00:00:00', 'yanliangwenchou', 0, 0);
INSERT INTO zhangong VALUES('sfgj', '三分归晋', 10, '使用神司马懿杀死刘备，孙权，曹操各累计10次', 0, 'god', '1999-12-31 00:00:00', 'shensimayi', 0, 0);
INSERT INTO zhangong VALUES('shgx', '四海归心', 10, '使用神曹操在一局游戏中受到2点伤害之后发动2次归心', 0, 'god', '1999-12-31 00:00:00', 'shencaocao', 0, 0);
INSERT INTO zhangong VALUES('ssex', '三思而行', 10, '使用孙权在一局游戏中利用制衡获得至少4张无中生有以及4张桃', 0, 'wu', '1999-12-31 00:00:00', 'sunquan', 0, 0);
INSERT INTO zhangong VALUES('sssl', '深思熟虑', 10, '使用孙权在一个回合内发动制衡的牌不少于10张', 0, 'wu', '1999-12-31 00:00:00', 'sunquan', 0, 0);
INSERT INTO zhangong VALUES('stzs', '神偷再世', 15, '在一局游戏中，累计使用卡牌顺手牵羊10次以上', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('syjh', '岁月静好', 10, '使用☆SP大乔在一局游戏中发动安娴五次并获胜', 0, 'wu', '1999-12-31 00:00:00', 'bgm_daqiao', 0, 0);
INSERT INTO zhangong VALUES('syqd', '恃勇轻敌', 10, '使用华雄在一局游戏中，在没有马岱在场的情况下由于体力上限减至0而死亡', 0, 'qun', '1999-12-31 00:00:00', 'huaxiong', 0, 0);
INSERT INTO zhangong VALUES('tyzm', '桃园之梦', 10, '使用神关羽在一局游戏中阵亡后发动武魂判定结果为桃园结义', 0, 'god', '1999-12-31 00:00:00', 'shenguanyu', 0, 0);
INSERT INTO zhangong VALUES('tyzy', '桃园之义', 15, '在一局游戏中，场上同时存在刘备、关羽、张飞三人且为队友，而你是其中一个并最后获胜', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('wmsz', '无谋竖子', 10, '使用神吕布在一局游戏中发动无谋至少8次', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu', 0, 0);
INSERT INTO zhangong VALUES('wsww', '为时未晚', 15, '身为反贼，在一局游戏中杀死了除自己以外所有反贼并获得游戏的胜利', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('wxwd', '惟贤惟德', 10, '使用刘备在一个回合内发动仁德给的牌不少于10张', 0, 'shu', '1999-12-31 00:00:00', 'liubei', 0, 0);
INSERT INTO zhangong VALUES('wyyd', '无言以对', 10, '使用徐庶在一局游戏中发动“无言”躲过南蛮入侵或万箭齐发累计4次', 0, 'shu', '1999-12-31 00:00:00', 'xushu', 0, 0);
INSERT INTO zhangong VALUES('wzxj', '稳重行军', 10, '使用于禁在一局游戏中发动“毅重”抵御至少4次黑色杀', 0, 'wei', '1999-12-31 00:00:00', 'yujin', 0, 0);
INSERT INTO zhangong VALUES('xhjs', '悬壶济世', 15, '在一局游戏中，使用桃或技能累计将我方队友脱离濒死状态4次以上', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('xlfm', '小露锋芒', 15, '进行1000局游戏', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('xlwzy', '星落五丈原', 10, '使用诸葛亮，在司马懿为敌方时阵亡', 0, 'shu', '1999-12-31 00:00:00', 'zhugeliang', 0, 0);
INSERT INTO zhangong VALUES('xnhx', '邪念惑心', 15, '作为忠臣在一局游戏中，在场上没有反贼时手刃主公', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('xxf', '小旋风', 10, '使用凌统在一局游戏中发动技能“旋风”弃掉其他角色累计15张牌', 0, 'wu', '1999-12-31 00:00:00', 'lingtong', 0, 0);
INSERT INTO zhangong VALUES('xysc', '小有所成', 15, '进行100局游戏', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('xzxm', '先知续命', 10, '使用郭嘉在一局游戏中利用技能“天妒”收进至少4个桃', 0, 'wei', '1999-12-31 00:00:00', 'guojia', 0, 0);
INSERT INTO zhangong VALUES('ybyt', '义薄云天', 10, '使用SP关羽在觉醒后杀死两个反贼并最后获胜', 0, 'wei', '1999-12-31 00:00:00', 'sp_guanyu', 0, 0);
INSERT INTO zhangong VALUES('ynnd', '有难你当', 10, '使用小乔在一局游戏中发动“天香”导致一名其他角色死亡', 0, 'wu', '1999-12-31 00:00:00', 'xiaoqiao', 0, 0);
INSERT INTO zhangong VALUES('yrbf', '隐忍不发', 10, '使用神司马懿在一局游戏中发动忍戒至少10次并获胜', 0, 'god', '1999-12-31 00:00:00', 'shensimayi', 0, 0);
INSERT INTO zhangong VALUES('ysadj', '以死安大局', 10, '使用马谡在一局游戏中发动“挥泪”使一名角色弃置8张牌', 0, 'shu', '1999-12-31 00:00:00', 'masu', 0, 0);
INSERT INTO zhangong VALUES('yzrx', '医者仁心', 10, '使用华佗在一局游戏中对4个身份的人都发动过青囊并最后获胜', 0, 'qun', '1999-12-31 00:00:00', 'huatuo', 0, 0);
INSERT INTO zhangong VALUES('zlzn', '昭烈之怒', 10, '在一局游戏中，使用☆SP刘备发动昭烈杀死至少2人', 0, 'shu', '1999-12-31 00:00:00', 'bgm_liubei', 0, 0);
INSERT INTO zhangong VALUES('zmjzg', '走马荐诸葛', 10, '使用旧徐庶在一局游戏中至少有3次举荐诸葛且用于举荐的牌里必须有马', 0, 'shu', '1999-12-31 00:00:00', 'xushu', 0, 0);
INSERT INTO zhangong VALUES('zsbsh', '宗室遍四海', 10, '使用刘表在一局游戏中利用技能“宗室”提高4手牌上限', 0, 'qun', '1999-12-31 00:00:00', 'liubiao', 0, 0);
INSERT INTO zhangong VALUES('zszn', '战神之怒', 10, '使用神吕布在一局游戏中发动至少4次神愤、3次无前', 0, 'god', '1999-12-31 00:00:00', 'shenlvbu', 0, 0);
INSERT INTO zhangong VALUES('zzhs', '智之化身', 10, '使用黄月英在一局游戏发动“集智”至少20次', 0, 'shu', '1999-12-31 00:00:00', 'huangyueying', 0, 0);
INSERT INTO zhangong VALUES('sxnj', '神仙难救', 10, '使用贾诩在你的回合中有至少3个角色阵亡', 0, 'qun', '1999-12-31 00:00:00', 'jiaxu', 0, 0);
INSERT INTO zhangong VALUES('jzyf', '见者有份', 10, '使用杨修在一局游戏中发动技能“啖酪”至少6次', 0, 'wei', '1999-12-31 00:00:00', 'yangxiu', 0, 0);
INSERT INTO zhangong VALUES('lbss', '乐不思蜀', 10, '在对你的“乐不思蜀”生效后的回合弃牌阶段弃置超过8张手牌', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('ydqb', '原地起爆', 10, '回合开始阶段你1血0牌的情况下，一回合内杀死3名角色', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('hyhs', '红颜祸水', 10, '使用SP貂蝉在一局游戏中，两次对主公和忠臣发动技能“离间”并导致2名忠臣阵亡', 0, 'qun', '1999-12-31 00:00:00', 'sp_diaochan', 0, 0);
INSERT INTO zhangong VALUES('wzsh', '威震四海', 15, '一次对另外一名角色造成至少5点伤害', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('dsdnx', '屌丝的逆袭', 15, '身为虎牢关联军的先锋，第一回合就爆了虎牢布的菊花', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('kdzz', '坑爹自重', 15, '使用刘禅，孙权&孙策，曹丕&曹植坑了自己的老爹', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
INSERT INTO zhangong VALUES('yfnzmk', '元芳你怎么看', 15, '元芳，你怎么看？大人，这不科学。', 0, 'zhonghe', '1999-12-31 00:00:00', '-', 0, 0);
COMMIT;