/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.AMediaCoderMixin;
import com.xuggle.mediatool.IMediaCoder;
import com.xuggle.mediatool.IMediaGenerator;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.event.AddStreamEvent;
import com.xuggle.mediatool.event.AudioSamplesEvent;
import com.xuggle.mediatool.event.CloseCoderEvent;
import com.xuggle.mediatool.event.CloseEvent;
import com.xuggle.mediatool.event.OpenCoderEvent;
import com.xuggle.mediatool.event.OpenEvent;
import com.xuggle.mediatool.event.ReadPacketEvent;
import com.xuggle.mediatool.event.VideoPictureEvent;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MediaReader
extends AMediaCoderMixin
implements IMediaReader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Integer, IStreamCoder> mCoders;
    private final Collection<IStream> mOpenedStreams;
    private ConverterFactory.Type mConverterType;
    private boolean mStreamsCanBeAddedDynamically;
    private boolean mQueryStreamMetaData;
    private IConverter mVideoConverter;
    private boolean mCloseOnEofOnly;
    private int mBufferedImageType;

    MediaReader(String url) {
        super(url, IContainer.make());
        this.log.trace("<init>");
        this.mCoders = new HashMap<Integer, IStreamCoder>();
        this.mOpenedStreams = new Vector<IStream>();
        this.mStreamsCanBeAddedDynamically = false;
        this.mQueryStreamMetaData = true;
        this.mCloseOnEofOnly = false;
        this.mBufferedImageType = -1;
    }

    MediaReader(IContainer container) {
        super(container.getURL(), container);
        this.log.trace("<init>");
        this.mCoders = new HashMap<Integer, IStreamCoder>();
        this.mOpenedStreams = new Vector<IStream>();
        this.mStreamsCanBeAddedDynamically = false;
        this.mQueryStreamMetaData = true;
        this.mCloseOnEofOnly = false;
        this.mBufferedImageType = -1;
        this.mStreamsCanBeAddedDynamically = container.canStreamsBeAddedDynamically();
    }

    public void setAddDynamicStreams(boolean streamsCanBeAddedDynamically) {
        if (this.isOpen()) {
            throw new RuntimeException("media container is already open");
        }
        this.mStreamsCanBeAddedDynamically = streamsCanBeAddedDynamically;
    }

    public boolean canAddDynamicStreams() {
        return this.mStreamsCanBeAddedDynamically;
    }

    public void setQueryMetaData(boolean queryStreamMetaData) {
        if (this.isOpen()) {
            throw new RuntimeException("media container is already open");
        }
        this.mQueryStreamMetaData = queryStreamMetaData;
    }

    public void setBufferedImageTypeToGenerate(int bufferedImageType) {
        if (bufferedImageType >= 0 && bufferedImageType != 5) {
            throw new RuntimeException("Only BufferedImage.TYPE_3BYTE_BGR supported: " + bufferedImageType);
        }
        this.mBufferedImageType = bufferedImageType;
    }

    public int getBufferedImageTypeToGenerate() {
        return this.mBufferedImageType;
    }

    public boolean willQueryMetaData() {
        return this.mQueryStreamMetaData;
    }

    public void setCloseOnEofOnly(boolean closeOnEofOnly) {
        this.mCloseOnEofOnly = closeOnEofOnly;
    }

    public boolean willCloseOnEofOnly() {
        return this.mCloseOnEofOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStreamCoder getStreamCoder(int streamIndex) {
        IStreamCoder coder = this.mCoders.get(streamIndex);
        if (coder == null) {
            int numStreams = this.getContainer().getNumStreams();
            if (streamIndex < 0 || streamIndex >= numStreams) {
                throw new RuntimeException("invalid stream index");
            }
            for (int i = 0; i < numStreams; ++i) {
                coder = this.mCoders.get(i);
                if (coder != null) continue;
                IStream stream = this.getContainer().getStream(i);
                try {
                    coder = stream.getStreamCoder();
                    this.mCoders.put(i, coder);
                    coder = null;
                    super.onAddStream(new AddStreamEvent(this, (Integer)i));
                    continue;
                }
                finally {
                    if (coder != null) {
                        coder.delete();
                    }
                    if (stream != null) {
                        stream.delete();
                    }
                }
            }
        }
        coder = this.mCoders.get(streamIndex);
        IStream stream = this.getContainer().getStream(streamIndex);
        try {
            ICodec.Type type = coder.getCodecType();
            if (!(coder.isOpen() || type != ICodec.Type.CODEC_TYPE_AUDIO && type != ICodec.Type.CODEC_TYPE_VIDEO)) {
                if (coder.open() < 0) {
                    throw new RuntimeException("could not open coder for stream: " + streamIndex);
                }
                this.mOpenedStreams.add(stream);
                super.onOpenCoder(new OpenCoderEvent(this, (Integer)stream.getIndex()));
                stream = null;
            }
        }
        finally {
            if (stream != null) {
                stream.delete();
            }
        }
        return coder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IError readPacket() {
        if (!this.isOpen()) {
            this.open();
        }
        IPacket packet = IPacket.make();
        try {
            int rv = this.getContainer().readNextPacket(packet);
            if (rv < 0) {
                IError error = IError.make(rv);
                if (!this.mCloseOnEofOnly || IError.Type.ERROR_EOF == error.getType()) {
                    this.close();
                }
                IError iError = error;
                return iError;
            }
            super.onReadPacket(new ReadPacketEvent((IMediaCoder)this, packet));
            IStreamCoder coder = this.getStreamCoder(packet.getStreamIndex());
            switch (coder.getCodecType()) {
                case CODEC_TYPE_AUDIO: {
                    this.decodeAudio(coder, packet);
                    return null;
                }
                case CODEC_TYPE_VIDEO: {
                    this.decodeVideo(coder, packet);
                    return null;
                }
            }
            return null;
        }
        finally {
            if (packet != null) {
                packet.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeVideo(IStreamCoder videoCoder, IPacket packet) {
        IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
        try {
            int rv = videoCoder.decodeVideo(picture, packet, 0);
            if (rv < 0) {
                throw new RuntimeException("error " + MediaReader.getErrorMessage(rv) + " decoding video");
            }
            if (picture.isComplete()) {
                this.dispatchVideoPicture(packet.getStreamIndex(), picture);
            }
        }
        finally {
            if (picture != null) {
                picture.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAudio(IStreamCoder audioCoder, IPacket packet) {
        int offset = 0;
        while (offset < packet.getSize()) {
            IAudioSamples samples = IAudioSamples.make(1024L, audioCoder.getChannels());
            int bytesDecoded = audioCoder.decodeAudio(samples, packet, offset);
            if (bytesDecoded < 0) {
                throw new RuntimeException("error " + bytesDecoded + " decoding audio");
            }
            offset += bytesDecoded;
            try {
                if (!samples.isComplete()) continue;
                this.dispatchAudioSamples(packet.getStreamIndex(), samples);
            }
            finally {
                if (samples == null) continue;
                samples.delete();
            }
        }
    }

    private void dispatchVideoPicture(int streamIndex, IVideoPicture picture) {
        BufferedImage image = null;
        if (this.mBufferedImageType >= 0) {
            if (this.mConverterType == null) {
                this.mConverterType = ConverterFactory.findRegisteredConverter("XUGGLER-BGR-24");
                if (this.mConverterType == null) {
                    throw new UnsupportedOperationException("No converter \"XUGGLER-BGR-24\" found.");
                }
            }
            if (this.mVideoConverter == null) {
                this.mVideoConverter = ConverterFactory.createConverter(this.mConverterType.getDescriptor(), picture);
            }
            image = this.mVideoConverter.toImage(picture);
        } else {
            this.mConverterType = null;
            this.mVideoConverter = null;
        }
        super.onVideoPicture(new VideoPictureEvent((IMediaGenerator)this, picture, image, picture.getTimeStamp(), TimeUnit.MICROSECONDS, (Integer)streamIndex));
    }

    private void dispatchAudioSamples(int streamIndex, IAudioSamples samples) {
        super.onAudioSamples(new AudioSamplesEvent(this, samples, streamIndex));
    }

    public void open() {
        if (this.getContainer().open(this.getUrl(), IContainer.Type.READ, null, this.mStreamsCanBeAddedDynamically, this.mQueryStreamMetaData) < 0) {
            throw new RuntimeException("could not open: " + this.getUrl());
        }
        super.onOpen(new OpenEvent(this));
        this.setShouldCloseContainer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int rv;
        for (IStream stream : this.mOpenedStreams) {
            IStreamCoder coder = stream.getStreamCoder();
            try {
                rv = coder.close();
                if (rv < 0) {
                    String errorString = MediaReader.getErrorMessage(rv);
                    throw new RuntimeException("error " + errorString + ", failed close coder " + coder);
                }
                super.onCloseCoder(new CloseCoderEvent(this, (Integer)stream.getIndex()));
            }
            finally {
                coder.delete();
                stream.delete();
            }
        }
        for (IStreamCoder coder : this.mCoders.values()) {
            coder.delete();
        }
        this.mCoders.clear();
        this.mOpenedStreams.clear();
        if (this.getShouldCloseContainer()) {
            rv = this.getContainer().close();
            if (rv < 0) {
                throw new RuntimeException("error " + MediaReader.getErrorMessage(rv) + ", failed close IContainer " + this.getContainer() + " for " + this.getUrl());
            }
            this.setShouldCloseContainer(false);
        }
        super.onClose(new CloseEvent(this));
    }

    private static String getErrorMessage(int rv) {
        String errorString = "";
        IError error = IError.make(rv);
        if (error != null) {
            errorString = error.toString();
            error.delete();
        }
        return errorString;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[");
        builder.append(this.getContainer() != null ? this.getContainer().getURL() : "");
        builder.append("]");
        return builder.toString();
    }
}

