/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibraryComPADRE {
    public static final String OSP_INFO_URL = "http://www.compadre.org/OSP/online_help/EjsDL/OSPCollection.html";
    public static final String EJS_SERVER_TREE = "http://www.compadre.org/osp/services/REST/osp_jars.cfm?verb=Identify&OSPType=EJS%20Model&AttachedDocument=Source%20Code";
    public static final String EJS_SERVER_RECORDS = "http://www.compadre.org/osp/services/REST/osp_jars.cfm?OSPType=EJS%20Model&AttachedDocument=Source%20Code";
    public static final String EJS_COLLECTION_NAME = "EJS OSP Collection";
    public static final String EJS_INFO_URL = "http://www.compadre.org/OSP/online_help/EjsDL/DLModels.html";
    public static final String TRACKER_SERVER_TREE = "http://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker";
    public static final String TRACKER_SERVER_RECORDS = "http://www.compadre.org/osp/services/REST/osp_tracker.cfm?OSPType=Tracker";
    public static final String TRACKER_COLLECTION_NAME = "Tracker OSP Collection";
    public static final String TRACKER_INFO_URL = "http://physlets.org/tracker/library/comPADRE_collection.html";
    public static final String PRIMARY_ONLY = "&OSPPrimary=Subject";
    public static final String GENERIC_COLLECTION_NAME = "ComPADRE OSP Collection";
    public static final String ABOUT_OSP = "About OSP and ComPADRE";
    public static final String HOST = "www.compadre.org";

    protected static boolean load(LibraryCollection libraryCollection, String string) {
        try {
            URL uRL = new URL(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(uRL.openStream());
            NodeList nodeList = document.getElementsByTagName("Identify");
            boolean bl = false;
            int n = 0;
            while (n < nodeList.getLength()) {
                bl = LibraryComPADRE.loadSubtrees(libraryCollection, nodeList.item(n).getChildNodes(), "osp-subject", "") || bl;
                ++n;
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected static boolean loadSubtrees(LibraryCollection libraryCollection, NodeList nodeList, String string, String string2) {
        boolean bl = false;
        String string3 = ToolsRes.getString("LibraryComPADRE.Description.DoubleClick");
        int n = 0;
        while (n < nodeList.getLength()) {
            List<Node> list;
            Element element;
            if (nodeList.item(n) instanceof Element && (element = (Element)nodeList.item(n)).getNodeName().equals("sub-tree-set") && string.equals(element.getAttribute("type")) && (list = LibraryComPADRE.getAllChildren(element, "sub-tree")).size() > 0) {
                String string4 = null;
                int n2 = 0;
                while (n2 < list.size()) {
                    if (list.get(n2) instanceof Element) {
                        Element element2 = (Element)list.get(n2);
                        String string5 = element2.getAttribute("name");
                        String string6 = element2.getAttribute("service-parameter");
                        string6 = String.valueOf(string2) + "&" + ResourceLoader.getNonURIPath(string6);
                        if (string5.equals("Unclassified")) {
                            string4 = string6;
                        } else {
                            LibraryCollection libraryCollection2 = new LibraryCollection(string5);
                            libraryCollection.addResource(libraryCollection2);
                            bl = true;
                            if (LibraryComPADRE.getAllChildren(element2, "sub-tree-set").isEmpty()) {
                                String string7 = "<h2>" + string5 + "</h2><blockquote>";
                                libraryCollection2.setDescription(String.valueOf(string7) + string3 + "</blockquote>");
                                libraryCollection2.setTarget(string6);
                            } else {
                                LibraryComPADRE.loadSubtrees(libraryCollection2, element2.getChildNodes(), String.valueOf(string) + "-detail", string6);
                            }
                        }
                    }
                    ++n2;
                }
                if (string4 != null) {
                    libraryCollection.setTarget(string4);
                }
            }
            ++n;
        }
        return bl;
    }

    protected static boolean loadResources(LibraryTreeNode libraryTreeNode) {
        LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
        boolean bl = false;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            String string = libraryTreeNode.getAbsoluteTarget();
            URL uRL = new URL(string);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(uRL.openStream());
            NodeList nodeList = document.getElementsByTagName("record");
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                String string2 = LibraryComPADRE.getChildValue(node, "osp-type");
                String[] stringArray = null;
                if (string2.startsWith("EJS")) {
                    stringArray = LibraryComPADRE.getAttachment(node, "Source Code");
                } else {
                    stringArray = LibraryComPADRE.getAttachment(node, "Main");
                    if (stringArray == null) {
                        stringArray = LibraryComPADRE.getAttachment(node, "Supplemental");
                    }
                }
                if (stringArray != null) {
                    String string3 = LibraryComPADRE.getChildValue(node, "title");
                    LibraryResource libraryResource = new LibraryResource(string3);
                    libraryCollection.addResource(libraryResource);
                    if (LibraryComPADRE.loadResource(libraryResource, node, stringArray, libraryTreeNode)) {
                        bl = true;
                        libraryResource.setProperty("reload_url", string);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        libraryCollection.setDescription(null);
        libraryCollection.setTarget(null);
        return bl;
    }

    protected static boolean reloadResource(LibraryTreeNode libraryTreeNode, String string) {
        boolean bl = false;
        try {
            LibraryResource libraryResource = libraryTreeNode.record;
            URL uRL = new URL(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(uRL.openStream());
            NodeList nodeList = document.getElementsByTagName("record");
            int n = 0;
            while (n < nodeList.getLength()) {
                String string2;
                Node node = nodeList.item(n);
                String string3 = LibraryComPADRE.getChildValue(node, "osp-type");
                String[] stringArray = null;
                if (string3.startsWith("EJS")) {
                    stringArray = LibraryComPADRE.getAttachment(node, "Source Code");
                } else {
                    stringArray = LibraryComPADRE.getAttachment(node, "Main");
                    if (stringArray == null) {
                        stringArray = LibraryComPADRE.getAttachment(node, "Supplemental");
                    }
                }
                if (stringArray != null && (string2 = LibraryComPADRE.processURL(stringArray[0])).equals(libraryResource.getTarget())) {
                    return LibraryComPADRE.loadResource(libraryResource, node, stringArray, libraryTreeNode);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected static boolean loadResource(LibraryResource libraryResource, Node node, String[] stringArray, LibraryTreeNode libraryTreeNode) {
        try {
            Object object;
            String string = LibraryComPADRE.processURL(stringArray[0]);
            libraryResource.setTarget(string);
            String string2 = LibraryComPADRE.getChildValue(node, "title");
            libraryResource.setName(string2);
            libraryResource.setProperty("download_filename", stringArray[1]);
            String string3 = LibraryComPADRE.getChildValue(node, "osp-type");
            if (string3.toUpperCase().startsWith("EJS")) {
                string3 = "EJS";
                libraryResource.setType(string3);
            } else if (string3.toUpperCase().startsWith("TRACKER")) {
                string3 = "Tracker";
                libraryResource.setType(string3);
            } else {
                libraryResource.setType("Unknown");
            }
            String string4 = LibraryComPADRE.getChildValue(node, "description");
            String string5 = LibraryComPADRE.getChildValue(node, "information-url");
            String string6 = LibraryComPADRE.getChildValue(node, "thumbnail-url");
            String string7 = "";
            for (Node object22 : LibraryComPADRE.getAllChildren(LibraryComPADRE.getFirstChild(node, "contributors"), "contributor")) {
                object = (Element)object22;
                if (!"Author".equals(object.getAttribute("role"))) continue;
                string7 = String.valueOf(string7) + LibraryComPADRE.getNodeValue(object22) + ", ";
            }
            if (string7.endsWith(", ")) {
                string7 = string7.substring(0, string7.length() - 2);
            }
            File file = ResourceLoader.getOSPCacheFile(string6);
            String string8 = file.getAbsolutePath();
            libraryResource.setThumbnail(string8);
            if (!file.exists()) {
                LibraryTreeNode libraryTreeNode2 = libraryTreeNode;
                libraryTreeNode2.getClass();
                new LibraryTreeNode.ThumbnailLoader(libraryTreeNode2, string6, string8).execute();
            }
            string6 = ResourceLoader.getURIPath(string8);
            object = LibraryResource.getHTMLBody(string2, string3, string6, string4, string7, null, string5, stringArray);
            libraryResource.setDescription((String)object);
            libraryResource.setMetadata(null);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Node node2 : LibraryComPADRE.getAllChildren(node, "osp-subject")) {
                Object object2;
                Object object3 = object2 = LibraryComPADRE.getNodeValue(node2).split(" / ");
                int n = ((Object)object3).length;
                int n2 = 0;
                while (n2 < n) {
                    Object object4 = object3[n2];
                    if (!((String)object4).equals("General") && !arrayList.contains(object4)) {
                        arrayList.add(object4);
                    }
                    ++n2;
                }
            }
            if (!arrayList.isEmpty()) {
                Object object52;
                StringBuffer stringBuffer = new StringBuffer();
                for (Object object52 : arrayList) {
                    stringBuffer.append(String.valueOf(object52) + ", ");
                }
                object52 = stringBuffer.toString();
                object52 = ((String)object52).substring(0, ((String)object52).length() - 2);
                libraryResource.addMetadata(new LibraryResource.Metadata("keywords", (String)object52));
            }
            if (!"".equals(string7)) {
                libraryResource.addMetadata(new LibraryResource.Metadata("author", string7));
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected static String[] getAttachment(Node node, String string) {
        String string2 = LibraryComPADRE.getChildValue(node, "file-identifier");
        NodeList nodeList = node.getChildNodes();
        String[] stringArray = null;
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node2;
            Node node3;
            Node node4 = nodeList.item(n);
            if (node4.getNodeName().equals("attached-document") && (node3 = LibraryComPADRE.getFirstChild(node4, "file-type")) != null && string.equals(LibraryComPADRE.getNodeValue(node3)) && (node2 = LibraryComPADRE.getFirstChild(node4, "download-url")) != null && (stringArray == null || string2.equals(LibraryComPADRE.getChildValue(node4, "file-identifier")))) {
                String string3 = LibraryComPADRE.getNodeValue(node2);
                Element element = (Element)LibraryComPADRE.getFirstChild(node4, "file-name");
                if (element != null) {
                    stringArray = new String[]{string3, LibraryComPADRE.getNodeValue(element), element.getAttribute("file-size")};
                } else {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = string3;
                    stringArray = stringArray2;
                }
            }
            ++n;
        }
        return stringArray;
    }

    protected static Node getFirstChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals(string)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    protected static List<Node> getAllChildren(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals(string)) {
                arrayList.add(node2);
            }
            ++n;
        }
        return arrayList;
    }

    protected static String getNodeValue(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 3) {
                return node2.getNodeValue();
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    protected static String getChildValue(Node node, String string) {
        Node node2 = LibraryComPADRE.getFirstChild(node, string);
        if (node2 != null) {
            return LibraryComPADRE.getNodeValue(node2);
        }
        return null;
    }

    protected static String processURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("&amp;");
        while (n >= 0) {
            stringBuffer.append(string.subSequence(0, n + 1));
            string = string.substring(n + 5);
            n = string.indexOf("&amp;");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected static String writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, streamResult);
            return ResourceLoader.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCollectionName(String string) {
        if (string.startsWith(EJS_SERVER_TREE)) {
            return EJS_COLLECTION_NAME;
        }
        if (string.startsWith(TRACKER_SERVER_TREE)) {
            return TRACKER_COLLECTION_NAME;
        }
        return GENERIC_COLLECTION_NAME;
    }

    protected static LibraryCollection getCollection(String string) {
        String string2 = LibraryComPADRE.getCollectionName(string);
        boolean bl = string.indexOf(PRIMARY_ONLY) > -1;
        LibraryCollection libraryCollection = new LibraryCollection(string2);
        if (string2.equals(EJS_COLLECTION_NAME)) {
            libraryCollection.setHTMLPath(EJS_INFO_URL);
        } else if (string2.equals(TRACKER_COLLECTION_NAME)) {
            libraryCollection.setHTMLPath(TRACKER_INFO_URL);
        }
        LibraryResource libraryResource = new LibraryResource(ABOUT_OSP);
        libraryResource.setHTMLPath(OSP_INFO_URL);
        libraryCollection.addResource(libraryResource);
        LibraryComPADRE.load(libraryCollection, string);
        String string3 = EJS_SERVER_RECORDS;
        if (string2.equals(TRACKER_COLLECTION_NAME)) {
            string3 = TRACKER_SERVER_RECORDS;
        }
        if (bl) {
            string3 = String.valueOf(string3) + PRIMARY_ONLY;
        }
        libraryCollection.setBasePath(string3);
        return libraryCollection;
    }

    protected static String getCollectionPath(String string, boolean bl) {
        boolean bl2 = string.endsWith(PRIMARY_ONLY);
        if (bl2 && bl) {
            return string;
        }
        if (!bl2 && !bl) {
            return string;
        }
        if (!bl2 && bl) {
            return String.valueOf(string) + PRIMARY_ONLY;
        }
        return string.substring(0, string.length() - PRIMARY_ONLY.length());
    }

    protected static boolean isComPADREPath(String string) {
        return string.startsWith(EJS_SERVER_TREE) || string.startsWith(TRACKER_SERVER_TREE);
    }

    protected static boolean isPrimarySubjectOnly(String string) {
        return string.indexOf(PRIMARY_ONLY) > -1;
    }
}

