/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.JComponent;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.Launcher;

class LaunchableClassMap
extends TreeMap<String, Class<?>> {
    ClassLoader classLoader;
    String[] jarOrDirectoryNames;
    boolean allLoaded = false;
    TreeMap<String, Class<?>> models = new TreeMap();

    LaunchableClassMap(String[] stringArray) {
        this.jarOrDirectoryNames = stringArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string = LaunchClassChooser.baseDirectoryPath;
        if (string == null) {
            string = OSPRuntime.getLaunchJarDirectory();
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = XML.getResolvedPath(stringArray[n], string);
            if (!string2.endsWith(".jar") && !string2.endsWith("/")) {
                string2 = String.valueOf(string2) + "/";
            }
            try {
                arrayList.add(new URL("file:" + string2));
            }
            catch (MalformedURLException malformedURLException) {
                OSPLog.info(malformedURLException + " " + string2);
            }
            ++n;
        }
        this.classLoader = URLClassLoader.newInstance(arrayList.toArray(new URL[0]));
    }

    Class<?> smartLoadClass(String string) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClass().getClassLoader().loadClass(string);
        }
    }

    ArrayList<File> getClassFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                arrayList.addAll(this.getClassFiles(file2));
            } else if (file2.getName().endsWith(".class")) {
                arrayList.add(file2);
            }
            ++n2;
        }
        return arrayList;
    }

    void loadAllClasses() {
        if (this.allLoaded) {
            return;
        }
        JApplet jApplet = OSPRuntime.applet;
        String[] stringArray = this.jarOrDirectoryNames;
        int n = this.jarOrDirectoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Object object2;
            String string = stringArray[n2];
            if (string.indexOf(".jar") > -1) {
                Object object3;
                object2 = null;
                try {
                    if (jApplet == null) {
                        object = LaunchClassChooser.baseDirectoryPath;
                        if (object == null) {
                            object = OSPRuntime.getLaunchJarDirectory();
                        }
                        String string2 = XML.getResolvedPath(string, (String)object);
                        object2 = new JarFile(string2);
                    } else {
                        object = XML.getResolvedPath(string, jApplet.getCodeBase().toExternalForm());
                        URL uRL = new URL("jar:" + (String)object + "!/");
                        object3 = (JarURLConnection)uRL.openConnection();
                        object2 = ((JarURLConnection)object3).getJarFile();
                    }
                }
                catch (Exception exception) {
                    OSPLog.info(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
                }
                if (object2 != null) {
                    object = ((JarFile)object2).entries();
                    while (object.hasMoreElements()) {
                        JarEntry jarEntry = (JarEntry)object.nextElement();
                        object3 = jarEntry.getName();
                        if (!((String)object3).endsWith(".class")) continue;
                        this.loadClass((String)object3);
                    }
                }
            } else {
                object2 = LaunchClassChooser.baseDirectoryPath;
                if (object2 == null) {
                    object2 = OSPRuntime.getLaunchJarDirectory();
                }
                object = XML.getResolvedPath(string, (String)object2);
                for (File file : this.getClassFiles(new File((String)object))) {
                    String string3 = XML.getPathRelativeTo(file.getPath(), (String)object);
                    this.loadClass(string3);
                }
            }
            ++n2;
        }
        this.allLoaded = true;
    }

    void loadClass(String string) {
        if (string.indexOf("$") == -1) {
            string = string.substring(0, string.indexOf(".class"));
            int n = string.indexOf("/");
            while (n != -1) {
                string = String.valueOf(string.substring(0, n)) + "." + string.substring(n + 1);
                n = string.indexOf("/");
            }
            if (this.get(string) != null || this.models.get(string) != null) {
                return;
            }
            try {
                Class<?> clazz = this.smartLoadClass(string);
                if (Launcher.isLaunchable(clazz)) {
                    this.put(string, clazz);
                }
                if (Launcher.isModel(clazz)) {
                    this.models.put(string, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                OSPLog.info(noClassDefFoundError.toString());
            }
        }
    }

    boolean includesJar(String string) {
        int n = 0;
        while (n < this.jarOrDirectoryNames.length) {
            if (this.jarOrDirectoryNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Class<?> getClass(String string) {
        Class<?> clazz = (Class<?>)this.get(string);
        if (clazz != null || this.allLoaded) {
            return clazz;
        }
        try {
            clazz = this.smartLoadClass(string);
            if (Launcher.isLaunchable(clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            OSPLog.info(noClassDefFoundError.toString());
        }
        return null;
    }

    Class<?> getModelClass(String string) {
        Class<?> clazz = this.models.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.smartLoadClass(string);
            if (Launcher.isModel(clazz)) {
                return clazz;
            }
            if (JComponent.class.isAssignableFrom(clazz)) {
                try {
                    clazz.getConstructor(null);
                    return clazz;
                }
                catch (Exception exception) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            OSPLog.info(noClassDefFoundError.toString());
        }
        return null;
    }

    Class<?> getClassOfType(String string, Class<?> clazz) {
        try {
            Class<?> clazz2 = this.smartLoadClass(string);
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            OSPLog.info(noClassDefFoundError.toString());
        }
        return null;
    }
}

