/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.xuggle.XuggleThumbnailTool;
import org.opensourcephysics.media.xuggle.XuggleVideo;
import org.opensourcephysics.media.xuggle.XuggleVideoRecorder;

public class XuggleVideoType
implements VideoType {
    protected static TreeSet<VideoFileFilter> xuggleFileFilters = new TreeSet();
    protected static String xuggleClass = "com.xuggle.xuggler.IContainer";
    protected static PropertyChangeListener errorListener;
    protected static boolean isXuggleAvailable;
    protected boolean recordable = true;
    private VideoFileFilter singleTypeFilter;

    static {
        isXuggleAvailable = true;
        errorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("xuggle_error")) {
                    isXuggleAvailable = false;
                }
            }
        };
        OSPLog.getOSPLog().addPropertyChangeListener(errorListener);
        XuggleThumbnailTool.start();
    }

    public XuggleVideoType() {
        if (!isXuggleAvailable) {
            throw new Error("Xuggle unavailable");
        }
        boolean bl = OSPLog.isConsoleMessagesLogged();
        try {
            OSPLog.setConsoleMessagesLogged(false);
            Class.forName(xuggleClass);
            OSPLog.setConsoleMessagesLogged(bl);
        }
        catch (Exception exception) {
            OSPLog.setConsoleMessagesLogged(bl);
            throw new Error("Xuggle unavailable");
        }
    }

    public XuggleVideoType(VideoFileFilter videoFileFilter) {
        this();
        if (videoFileFilter != null) {
            this.singleTypeFilter = videoFileFilter;
            xuggleFileFilters.add(videoFileFilter);
        }
    }

    @Override
    public Video getVideo(String string) {
        try {
            XuggleVideo xuggleVideo = new XuggleVideo(string);
            xuggleVideo.setProperty("video_type", this);
            return xuggleVideo;
        }
        catch (IOException iOException) {
            OSPLog.fine(String.valueOf(this.getDescription()) + ": " + iOException.getMessage());
            return null;
        }
    }

    @Override
    public boolean canRecord() {
        return this.recordable;
    }

    public void setRecordable(boolean bl) {
        this.recordable = bl;
    }

    @Override
    public VideoRecorder getRecorder() {
        return new XuggleVideoRecorder(this);
    }

    @Override
    public VideoFileFilter[] getFileFilters() {
        if (this.singleTypeFilter != null) {
            return new VideoFileFilter[]{this.singleTypeFilter};
        }
        return xuggleFileFilters.toArray(new VideoFileFilter[0]);
    }

    @Override
    public VideoFileFilter getDefaultFileFilter() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter;
        }
        return null;
    }

    @Override
    public boolean isType(Video video) {
        if (!video.getClass().equals(XuggleVideo.class)) {
            return false;
        }
        if (this.singleTypeFilter == null) {
            return true;
        }
        String string = (String)video.getProperty("name");
        return this.singleTypeFilter.accept(new File(string));
    }

    @Override
    public String getDescription() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDescription();
        }
        return MediaRes.getString("XuggleVideoType.Description");
    }

    @Override
    public String getDefaultExtension() {
        if (this.singleTypeFilter != null) {
            return this.singleTypeFilter.getDefaultExtension();
        }
        return null;
    }
}

