/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.ResourceLoader;

public class RotateFilter
extends Filter {
    private static final int NONE = -1;
    private static final int CCW_90 = 0;
    private static final int CW_90 = 1;
    private static final int FULL_180 = 2;
    private static final int[] types;
    private static final String[] typeNames;
    private static Icon cwIcon;
    private static Icon ccwIcon;
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixelsIn;
    private int[] pixelsOut;
    private int w;
    private int h;
    private Graphics2D gIn;
    private int rotationType = -1;
    private Inspector inspector;
    private JRadioButtonMenuItem[] buttons = new JRadioButtonMenuItem[4];
    private ButtonGroup buttonGroup;
    private JCheckBox reverseCheckbox;
    private JComponent rotationPanel;
    private JComponent reversePanel;
    private boolean reverse;

    static {
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 2;
        types = nArray;
        typeNames = new String[]{"None", "CCW", "CW", "180"};
        String string = "/org/opensourcephysics/resources/media/images/cw.gif";
        cwIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/media/images/ccw.gif";
        ccwIcon = ResourceLoader.getIcon(string);
    }

    public RotateFilter() {
        this.refresh();
        this.hasInspector = true;
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToRotate(this.input);
        return this.output;
    }

    private void setRotationType(int n) {
        if (n != this.rotationType) {
            this.rotationType = n;
            this.source = null;
            this.support.firePropertyChange("rotate", null, null);
        }
    }

    @Override
    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Rotate.Title"));
            this.rotationPanel.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("Filter.Rotate.Label.Rotate")));
            int n = 0;
            while (n < this.buttons.length) {
                this.buttons[n].setEnabled(this.isEnabled());
                this.buttons[n].setText(MediaRes.getString("Filter.Rotate.Button." + typeNames[n]));
                ++n;
            }
            this.reverseCheckbox.setText(MediaRes.getString("Filter.Rotate.Checkbox.Reverse"));
            this.reverseCheckbox.setSelected(this.reverse);
        }
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixelsIn = new int[this.w * this.h];
        this.pixelsOut = new int[this.w * this.h];
        this.output = this.rotationType == 1 || this.rotationType == 0 ? new BufferedImage(this.h, this.w, 1) : new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToRotate(BufferedImage bufferedImage) {
        bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.pixelsIn);
        int n = this.w * this.h - 1;
        if (this.rotationType > -1 || this.reverse) {
            int n2 = 0;
            while (n2 < this.pixelsIn.length) {
                int n3;
                int n4;
                if (this.rotationType == -1) {
                    n4 = n2 / this.w;
                    n3 = this.w - n2 % this.w - 1;
                    this.pixelsOut[this.w * n4 + n3] = this.pixelsIn[n2];
                } else if (this.rotationType == 1) {
                    if (this.reverse) {
                        n4 = this.h - n2 / this.w - 1;
                        n3 = this.w - n2 % this.w - 1;
                        this.pixelsOut[this.h * n3 + n4] = this.pixelsIn[n2];
                    } else {
                        n4 = this.h - n2 / this.w - 1;
                        n3 = n2 % this.w;
                        this.pixelsOut[this.h * n3 + n4] = this.pixelsIn[n2];
                    }
                } else if (this.rotationType == 0) {
                    if (this.reverse) {
                        n4 = n2 / this.w;
                        n3 = n2 % this.w;
                        this.pixelsOut[this.h * n3 + n4] = this.pixelsIn[n2];
                    } else {
                        n4 = n2 / this.w;
                        n3 = this.w - n2 % this.w - 1;
                        this.pixelsOut[this.h * n3 + n4] = this.pixelsIn[n2];
                    }
                } else if (this.reverse) {
                    n4 = this.h - n2 / this.w - 1;
                    n3 = n2 % this.w;
                    this.pixelsOut[this.w * n4 + n3] = this.pixelsIn[n2];
                } else {
                    this.pixelsOut[n - n2] = this.pixelsIn[n2];
                }
                ++n2;
            }
        }
        if (this.rotationType == -1 && !this.reverse) {
            this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixelsIn);
        } else if (this.rotationType == 1 || this.rotationType == 0) {
            this.output.getRaster().setDataElements(0, 0, this.h, this.w, this.pixelsOut);
        } else {
            this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixelsOut);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(RotateFilter.this.frame, !(RotateFilter.this.frame instanceof OSPFrame));
            this.setResizable(false);
            this.createGUI();
            this.setTitle(MediaRes.getString("Filter.Rotate.Title"));
            RotateFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            int n = 40;
            RotateFilter.this.rotationPanel = Box.createVerticalBox();
            RotateFilter.this.buttonGroup = new ButtonGroup();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < RotateFilter.this.buttons.length) {
                        if (RotateFilter.this.buttons[n].isSelected()) {
                            RotateFilter.this.setRotationType(types[n]);
                            break;
                        }
                        ++n;
                    }
                }
            };
            int n2 = 0;
            while (n2 < RotateFilter.this.buttons.length) {
                ((RotateFilter)RotateFilter.this).buttons[n2] = new JRadioButtonMenuItem();
                RotateFilter.this.buttons[n2].setSelected(RotateFilter.this.rotationType == types[n2]);
                RotateFilter.this.buttons[n2].addActionListener(actionListener);
                RotateFilter.this.buttons[n2].setBorder(BorderFactory.createEmptyBorder(2, n, 2, 2));
                RotateFilter.this.buttons[n2].setHorizontalTextPosition(2);
                if (types[n2] == 1) {
                    RotateFilter.this.buttons[n2].setIcon(cwIcon);
                } else if (types[n2] == 0) {
                    RotateFilter.this.buttons[n2].setIcon(ccwIcon);
                }
                RotateFilter.this.buttonGroup.add(RotateFilter.this.buttons[n2]);
                RotateFilter.this.rotationPanel.add(RotateFilter.this.buttons[n2]);
                ++n2;
            }
            RotateFilter.this.reversePanel = Box.createVerticalBox();
            RotateFilter.this.reverseCheckbox = new JCheckBox();
            RotateFilter.this.reverseCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RotateFilter.this.reverse = RotateFilter.this.reverseCheckbox.isSelected();
                    ((Inspector)Inspector.this).RotateFilter.this.support.firePropertyChange("rotate", null, null);
                }
            });
            RotateFilter.this.reversePanel.add(RotateFilter.this.reverseCheckbox);
            RotateFilter.this.reverseCheckbox.setBorder(BorderFactory.createEmptyBorder(2, n + 7, 2, 2));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            jPanel.add((Component)RotateFilter.this.rotationPanel, "North");
            jPanel.add((Component)RotateFilter.this.reversePanel, "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(RotateFilter.this.ableButton);
            jPanel2.add(RotateFilter.this.closeButton);
            jPanel.add((Component)jPanel2, "South");
        }

        void initialize() {
            RotateFilter.this.refresh();
            this.updateDisplay();
        }

        void updateDisplay() {
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            RotateFilter rotateFilter = (RotateFilter)object;
            if (rotateFilter.rotationType > -1) {
                xMLControl.setValue("rotation", typeNames[rotateFilter.rotationType + 1]);
            }
            xMLControl.setValue("reverse", rotateFilter.reverse);
            if (rotateFilter.frame != null && rotateFilter.inspector != null && rotateFilter.inspector.isVisible()) {
                int n = ((RotateFilter)rotateFilter).inspector.getLocation().x - rotateFilter.frame.getLocation().x;
                int n2 = ((RotateFilter)rotateFilter).inspector.getLocation().y - rotateFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new RotateFilter();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            RotateFilter rotateFilter = (RotateFilter)object;
            String string = xMLControl.getString("rotation");
            int n = 0;
            while (n < typeNames.length) {
                if (typeNames[n].equals(string)) {
                    rotateFilter.rotationType = types[n];
                }
                ++n;
            }
            rotateFilter.reverse = xMLControl.getBoolean("reverse");
            rotateFilter.inspectorX = xMLControl.getInt("inspector_x");
            rotateFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

